/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.codeless.CodelessManager;
import com.facebook.appevents.codeless.internal.UnityReflection;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewIndexer {
    private static final String TAG = ViewIndexer.class.getCanonicalName();
    private static final String SUCCESS = "success";
    private static final String TREE_PARAM = "tree";
    private static final String APP_VERSION_PARAM = "app_version";
    private static final String PLATFORM_PARAM = "platform";
    private static final String REQUEST_TYPE = "request_type";
    private final Handler uiThreadHandler;
    private WeakReference<Activity> activityReference;
    private Timer indexingTimer;
    private String previousDigest;
    private static ViewIndexer instance;

    public ViewIndexer(Activity activity) {
        this.activityReference = new WeakReference<Activity>(activity);
        this.previousDigest = null;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        instance = this;
    }

    public void schedule() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            final TimerTask indexingTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        Activity activity = (Activity)ViewIndexer.access$000(ViewIndexer.this).get();
                        if (null == activity) {
                            return;
                        }
                        String activityName = activity.getClass().getSimpleName();
                        View rootView = activity.getWindow().getDecorView().getRootView();
                        if (!CodelessManager.getIsAppIndexingEnabled()) {
                            return;
                        }
                        if (InternalSettings.isUnityApp()) {
                            UnityReflection.captureViewHierarchy();
                            return;
                        }
                        FutureTask<String> screenshotFuture = new FutureTask<String>(new ScreenshotTaker(rootView));
                        ViewIndexer.access$100(ViewIndexer.this).post(screenshotFuture);
                        String screenshot = "";
                        try {
                            screenshot = screenshotFuture.get(1L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            Log.e((String)ViewIndexer.access$200(), (String)"Failed to take screenshot.", (Throwable)e);
                        }
                        JSONObject viewTree = new JSONObject();
                        try {
                            viewTree.put("screenname", (Object)activityName);
                            viewTree.put("screenshot", (Object)screenshot);
                            JSONArray viewArray = new JSONArray();
                            JSONObject rootViewInfo = ViewHierarchy.getDictionaryOfView(rootView);
                            viewArray.put((Object)rootViewInfo);
                            viewTree.put("view", (Object)viewArray);
                        }
                        catch (JSONException e) {
                            Log.e((String)ViewIndexer.access$200(), (String)"Failed to create JSONObject");
                        }
                        String tree = viewTree.toString();
                        ViewIndexer.access$300(ViewIndexer.this, tree);
                    }
                    catch (Exception e) {
                        Log.e((String)ViewIndexer.access$200(), (String)"UI Component tree indexing failure!", (Throwable)e);
                    }
                }
            };
            FacebookSdk.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        try {
                            if (ViewIndexer.access$400(ViewIndexer.this) != null) {
                                ViewIndexer.access$400(ViewIndexer.this).cancel();
                            }
                            ViewIndexer.access$502(ViewIndexer.this, null);
                            ViewIndexer.access$402(ViewIndexer.this, new Timer());
                            ViewIndexer.access$400(ViewIndexer.this).scheduleAtFixedRate(indexingTask, 0L, 1000L);
                        }
                        catch (Exception e) {
                            Log.e((String)ViewIndexer.access$200(), (String)"Error scheduling indexing job", (Throwable)e);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public void unschedule() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            Activity activity = (Activity)this.activityReference.get();
            if (null == activity) {
                return;
            }
            if (this.indexingTimer != null) {
                try {
                    this.indexingTimer.cancel();
                    this.indexingTimer = null;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error unscheduling indexing job", (Throwable)e);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    public static void sendToServerUnityInstance(String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return;
        }
        try {
            String tree;
            if (null == instance) {
                return;
            }
            instance.sendToServerUnity(tree);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void sendToServerUnity(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void tree;
            instance.sendToServer((String)tree);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendToServer(String string) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void tree;
            FacebookSdk.getExecutor().execute(new Runnable((String)tree){
                final /* synthetic */ String val$tree;
                {
                    this.val$tree = string;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        String currentDigest = Utility.md5hash(this.val$tree);
                        AccessToken accessToken = AccessToken.getCurrentAccessToken();
                        if (currentDigest != null && currentDigest.equals(ViewIndexer.access$500(ViewIndexer.this))) {
                            return;
                        }
                        GraphRequest request = ViewIndexer.buildAppIndexingRequest(this.val$tree, accessToken, FacebookSdk.getApplicationId(), "app_indexing");
                        if (request != null) {
                            GraphResponse res = request.executeAndWait();
                            try {
                                JSONObject jsonRes = res.getJSONObject();
                                if (jsonRes != null) {
                                    if ("true".equals(jsonRes.optString(ViewIndexer.SUCCESS))) {
                                        Logger.log(LoggingBehavior.APP_EVENTS, ViewIndexer.access$200(), "Successfully send UI component tree to server");
                                        ViewIndexer.access$502(ViewIndexer.this, currentDigest);
                                    }
                                    if (jsonRes.has("is_app_indexing_enabled")) {
                                        Boolean appIndexingEnabled = jsonRes.getBoolean("is_app_indexing_enabled");
                                        CodelessManager.updateAppIndexing(appIndexingEnabled);
                                    }
                                } else {
                                    Log.e((String)ViewIndexer.access$200(), (String)("Error sending UI component tree to Facebook: " + res.getError()));
                                }
                            }
                            catch (JSONException e) {
                                Log.e((String)ViewIndexer.access$200(), (String)"Error decoding server response.", (Throwable)e);
                            }
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static GraphRequest buildAppIndexingRequest(String string, AccessToken accessToken, String string2, String string3) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            void requestType;
            void appId;
            void accessToken2;
            String appIndex;
            if (appIndex == null) {
                return null;
            }
            GraphRequest postRequest = GraphRequest.newPostRequest((AccessToken)accessToken2, String.format(Locale.US, "%s/app_indexing", appId), null, null);
            Bundle requestParameters = postRequest.getParameters();
            if (requestParameters == null) {
                requestParameters = new Bundle();
            }
            requestParameters.putString(TREE_PARAM, appIndex);
            requestParameters.putString(APP_VERSION_PARAM, AppEventUtility.getAppVersion());
            requestParameters.putString(PLATFORM_PARAM, "android");
            requestParameters.putString(REQUEST_TYPE, (String)requestType);
            if (requestType.equals("app_indexing")) {
                requestParameters.putString("device_session_id", CodelessManager.getCurrentDeviceSessionID());
            }
            postRequest.setParameters(requestParameters);
            postRequest.setCallback(new GraphRequest.Callback(){

                @Override
                public void onCompleted(GraphResponse response) {
                    Logger.log(LoggingBehavior.APP_EVENTS, ViewIndexer.access$200(), "App index sent to FB!");
                }
            });
            return postRequest;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    static /* synthetic */ WeakReference access$000(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer x0;
            return x0.activityReference;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    static /* synthetic */ Handler access$100(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer x0;
            return x0.uiThreadHandler;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    static /* synthetic */ String access$200() {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(ViewIndexer viewIndexer, String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return;
        }
        try {
            void x1;
            ViewIndexer x0;
            x0.sendToServer((String)x1);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return;
        }
    }

    static /* synthetic */ Timer access$400(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer x0;
            return x0.indexingTimer;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$502(ViewIndexer viewIndexer, String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer x0;
            void x1;
            x0.previousDigest = x1;
            return x0.previousDigest;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Timer access$402(ViewIndexer viewIndexer, Timer timer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer x0;
            void x1;
            x0.indexingTimer = x1;
            return x0.indexingTimer;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    static /* synthetic */ String access$500(ViewIndexer viewIndexer) {
        if (CrashShieldHandler.isObjectCrashing(ViewIndexer.class)) {
            return null;
        }
        try {
            ViewIndexer x0;
            return x0.previousDigest;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewIndexer.class);
            return null;
        }
    }

    private static class ScreenshotTaker
    implements Callable<String> {
        private WeakReference<View> rootView;

        ScreenshotTaker(View rootView) {
            this.rootView = new WeakReference<View>(rootView);
        }

        @Override
        public String call() {
            View view = (View)this.rootView.get();
            if (view == null || view.getWidth() == 0 || view.getHeight() == 0) {
                return "";
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.draw(canvas);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 10, (OutputStream)outputStream);
            return Base64.encodeToString((byte[])outputStream.toByteArray(), (int)2);
        }
    }
}

