/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.view.View;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class PredictionHistoryManager {
    private static final Map<String, String> clickedViewPaths = new HashMap<String, String>();
    private static final String SUGGESTED_EVENTS_HISTORY = "SUGGESTED_EVENTS_HISTORY";
    private static final String CLICKED_PATH_STORE = "com.facebook.internal.SUGGESTED_EVENTS_HISTORY";
    private static SharedPreferences shardPreferences;
    private static final AtomicBoolean initialized;

    PredictionHistoryManager() {
    }

    private static void initAndWait() {
        if (CrashShieldHandler.isObjectCrashing(PredictionHistoryManager.class)) {
            return;
        }
        try {
            if (initialized.get()) {
                return;
            }
            shardPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(CLICKED_PATH_STORE, 0);
            clickedViewPaths.putAll(Utility.JsonStrToMap(shardPreferences.getString(SUGGESTED_EVENTS_HISTORY, "")));
            initialized.set(true);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PredictionHistoryManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void addPrediction(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(PredictionHistoryManager.class)) {
            return;
        }
        try {
            void predictedEvent;
            String pathID;
            if (!initialized.get()) {
                PredictionHistoryManager.initAndWait();
            }
            clickedViewPaths.put(pathID, (String)predictedEvent);
            shardPreferences.edit().putString(SUGGESTED_EVENTS_HISTORY, Utility.mapToJsonStr(clickedViewPaths)).apply();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PredictionHistoryManager.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static String getPathID(View view, String string) {
        if (CrashShieldHandler.isObjectCrashing(PredictionHistoryManager.class)) {
            return null;
        }
        try {
            JSONObject pathRoute = new JSONObject();
            try {
                View view2;
                void text;
                pathRoute.put("text", (Object)text);
                JSONArray currentPath = new JSONArray();
                while (view2 != null) {
                    currentPath.put((Object)view2.getClass().getSimpleName());
                    view2 = ViewHierarchy.getParentOfView(view2);
                }
                pathRoute.put("classname", (Object)currentPath);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Utility.sha256hash(pathRoute.toString());
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PredictionHistoryManager.class);
            return null;
        }
    }

    @Nullable
    static String queryEvent(String string) {
        if (CrashShieldHandler.isObjectCrashing(PredictionHistoryManager.class)) {
            return null;
        }
        try {
            String pathID;
            return clickedViewPaths.containsKey(pathID) ? clickedViewPaths.get(pathID) : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, PredictionHistoryManager.class);
            return null;
        }
    }

    static {
        initialized = new AtomicBoolean(false);
    }
}

