/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.Window;
import com.facebook.FacebookSdk;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppEventUtility {
    private static final String regex = "[-+]*\\d+([\\,\\.]\\d+)*([\\.\\,]\\d+)?";

    public static void assertIsNotMainThread() {
    }

    public static void assertIsMainThread() {
    }

    public static double normalizePrice(String value) {
        try {
            Pattern pattern = Pattern.compile(regex, 8);
            Matcher matcher = pattern.matcher(value);
            if (matcher.find()) {
                String firstValue = matcher.group(0);
                return NumberFormat.getNumberInstance(Utility.getCurrentLocale()).parse(firstValue).doubleValue();
            }
            return 0.0;
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    private static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String getAppVersion() {
        Context context = FacebookSdk.getApplicationContext();
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
    }

    @Nullable
    public static View getRootView(@Nullable Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(AppEventUtility.class)) {
            return null;
        }
        try {
            Activity activity2;
            if (activity2 == null) {
                return null;
            }
            Window window = activity2.getWindow();
            if (window == null) {
                return null;
            }
            return window.getDecorView().getRootView();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, AppEventUtility.class);
            return null;
        }
    }
}

