/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RatingBar;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.TimePicker;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ViewHierarchy {
    private static final String TAG = ViewHierarchy.class.getCanonicalName();
    private static final String CLASS_RCTROOTVIEW = "com.facebook.react.ReactRootView";
    private static final String CLASS_RCTTEXTVIEW = "com.facebook.react.views.view.ReactTextView";
    private static final String CLASS_RCTVIEWGROUP = "com.facebook.react.views.view.ReactViewGroup";
    private static final String CLASS_TOUCHTARGETHELPER = "com.facebook.react.uimanager.TouchTargetHelper";
    private static final String METHOD_FIND_TOUCHTARGET_VIEW = "findTouchTargetView";
    private static final int ICON_MAX_EDGE_LENGTH = 44;
    private static WeakReference<View> RCTRootViewReference = new WeakReference<Object>(null);
    @Nullable
    private static Method methodFindTouchTargetView = null;

    @Nullable
    public static ViewGroup getParentOfView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            if (null == view2) {
                return null;
            }
            ViewParent parent = view2.getParent();
            if (parent instanceof ViewGroup) {
                return (ViewGroup)parent;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    public static List<View> getChildrenOfView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            ArrayList<View> children = new ArrayList<View>();
            if (view2 instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view2;
                int count = viewGroup.getChildCount();
                for (int i = 0; i < count; ++i) {
                    children.add(viewGroup.getChildAt(i));
                }
            }
            return children;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateBasicInfoOfView(View view, JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return;
        }
        try {
            try {
                void json;
                View view2;
                String text = ViewHierarchy.getTextOfView(view2);
                String hint = ViewHierarchy.getHintOfView(view2);
                Object tag = view2.getTag();
                CharSequence description = view2.getContentDescription();
                json.put("classname", (Object)view2.getClass().getCanonicalName());
                json.put("classtypebitmask", ViewHierarchy.getClassTypeBitmask(view2));
                json.put("id", view2.getId());
                if (!SensitiveUserDataUtils.isSensitiveUserData(view2)) {
                    json.put("text", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(text), ""));
                } else {
                    json.put("text", (Object)"");
                    json.put("is_user_input", true);
                }
                json.put("hint", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(hint), ""));
                if (tag != null) {
                    json.put("tag", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(tag.toString()), ""));
                }
                if (description != null) {
                    json.put("description", (Object)Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(description.toString()), ""));
                }
                JSONObject dimension = ViewHierarchy.getDimensionOfView(view2);
                json.put("dimension", (Object)dimension);
            }
            catch (JSONException e) {
                Utility.logd(TAG, (Exception)((Object)e));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateAppearanceOfView(View view, JSONObject jSONObject, float f) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return;
        }
        try {
            try {
                Bitmap bitmap;
                void displayDensity;
                Drawable drawable;
                void json;
                TextView textView;
                Typeface typeface;
                View view2;
                JSONObject textStyle = new JSONObject();
                if (view2 instanceof TextView && (typeface = (textView = (TextView)view2).getTypeface()) != null) {
                    textStyle.put("font_size", (double)textView.getTextSize());
                    textStyle.put("is_bold", typeface.isBold());
                    textStyle.put("is_italic", typeface.isItalic());
                    json.put("text_style", (Object)textStyle);
                }
                if (view2 instanceof ImageView && (drawable = ((ImageView)view2).getDrawable()) instanceof BitmapDrawable && (float)view2.getHeight() / displayDensity <= 44.0f && (float)view2.getWidth() / displayDensity <= 44.0f && (bitmap = ((BitmapDrawable)drawable).getBitmap()) != null) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                    byte[] byteArray = byteArrayOutputStream.toByteArray();
                    String encoded = Base64.encodeToString((byte[])byteArray, (int)0);
                    json.put("icon_image", (Object)encoded);
                }
            }
            catch (JSONException e) {
                Utility.logd(TAG, (Exception)((Object)e));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return;
        }
    }

    public static JSONObject getDictionaryOfView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            if (view2.getClass().getName().equals(CLASS_RCTROOTVIEW)) {
                RCTRootViewReference = new WeakReference<View>(view2);
            }
            JSONObject json = new JSONObject();
            try {
                ViewHierarchy.updateBasicInfoOfView(view2, json);
                JSONArray childViews = new JSONArray();
                List<View> children = ViewHierarchy.getChildrenOfView(view2);
                for (int i = 0; i < children.size(); ++i) {
                    View child = children.get(i);
                    JSONObject childInfo = ViewHierarchy.getDictionaryOfView(child);
                    childViews.put((Object)childInfo);
                }
                json.put("childviews", (Object)childViews);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed to create JSONObject for view.", (Throwable)e);
            }
            return json;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    public static int getClassTypeBitmask(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return 0;
        }
        try {
            View view2;
            int bitmask = 0;
            if (view2 instanceof ImageView) {
                bitmask |= 2;
            }
            if (view2.isClickable()) {
                bitmask |= 0x20;
            }
            if (ViewHierarchy.isAdapterViewItem(view2)) {
                bitmask |= 0x200;
            }
            if (view2 instanceof TextView) {
                bitmask |= 0x400;
                bitmask |= 1;
                if (view2 instanceof Button) {
                    bitmask |= 4;
                    if (view2 instanceof Switch) {
                        bitmask |= 0x2000;
                    } else if (view2 instanceof CheckBox) {
                        bitmask |= 0x8000;
                    }
                }
                if (view2 instanceof EditText) {
                    bitmask |= 0x800;
                }
            } else if (view2 instanceof Spinner || view2 instanceof DatePicker) {
                bitmask |= 0x1000;
            } else if (view2 instanceof RatingBar) {
                bitmask |= 0x10000;
            } else if (view2 instanceof RadioGroup) {
                bitmask |= 0x4000;
            } else if (view2 instanceof ViewGroup && ViewHierarchy.isRCTButton(view2, (View)RCTRootViewReference.get())) {
                bitmask |= 0x40;
            }
            return bitmask;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return 0;
        }
    }

    private static boolean isAdapterViewItem(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return false;
        }
        try {
            View view2;
            ViewParent parent = view2.getParent();
            if (parent instanceof AdapterView) {
                return true;
            }
            Class<?> nestedScrollingChildClass = ViewHierarchy.getExistingClass("android.support.v4.view.NestedScrollingChild");
            if (nestedScrollingChildClass != null && nestedScrollingChildClass.isInstance(parent)) {
                return true;
            }
            nestedScrollingChildClass = ViewHierarchy.getExistingClass("androidx.core.view.NestedScrollingChild");
            return nestedScrollingChildClass != null && nestedScrollingChildClass.isInstance(parent);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return false;
        }
    }

    public static String getTextOfView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            CharSequence textObj = null;
            if (view2 instanceof TextView) {
                textObj = ((TextView)view2).getText();
                if (view2 instanceof Switch) {
                    boolean isOn = ((Switch)view2).isChecked();
                    textObj = isOn ? "1" : "0";
                }
            } else if (view2 instanceof Spinner) {
                Object selectedItem;
                Spinner spinner = (Spinner)view2;
                if (spinner.getCount() > 0 && (selectedItem = ((Spinner)view2).getSelectedItem()) != null) {
                    textObj = selectedItem.toString();
                }
            } else if (view2 instanceof DatePicker) {
                DatePicker picker = (DatePicker)view2;
                int y = picker.getYear();
                int m = picker.getMonth();
                int d = picker.getDayOfMonth();
                textObj = String.format("%04d-%02d-%02d", y, m, d);
            } else if (view2 instanceof TimePicker) {
                TimePicker picker = (TimePicker)view2;
                int h = picker.getCurrentHour();
                int m = picker.getCurrentMinute();
                textObj = String.format("%02d:%02d", h, m);
            } else if (view2 instanceof RadioGroup) {
                RadioGroup radioGroup = (RadioGroup)view2;
                int checkedId = radioGroup.getCheckedRadioButtonId();
                int childCount = radioGroup.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    View child = radioGroup.getChildAt(i);
                    if (child.getId() != checkedId || !(child instanceof RadioButton)) continue;
                    textObj = ((RadioButton)child).getText();
                    break;
                }
            } else if (view2 instanceof RatingBar) {
                RatingBar bar = (RatingBar)view2;
                float rating = bar.getRating();
                textObj = String.valueOf(rating);
            }
            return textObj == null ? "" : ((Object)textObj).toString();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    public static String getHintOfView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            CharSequence hintObj = null;
            if (view2 instanceof EditText) {
                hintObj = ((EditText)view2).getHint();
            } else if (view2 instanceof TextView) {
                hintObj = ((TextView)view2).getHint();
            }
            return hintObj == null ? "" : hintObj.toString();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    private static JSONObject getDimensionOfView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            JSONObject dimension = new JSONObject();
            try {
                View view2;
                dimension.put("top", view2.getTop());
                dimension.put("left", view2.getLeft());
                dimension.put("width", view2.getWidth());
                dimension.put("height", view2.getHeight());
                dimension.put("scrollx", view2.getScrollX());
                dimension.put("scrolly", view2.getScrollY());
                dimension.put("visibility", view2.getVisibility());
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed to create JSONObject for dimension.", (Throwable)e);
            }
            return dimension;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    @Nullable
    public static View.OnClickListener getExistingOnClickListener(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            try {
                View view2;
                Object listenerObj;
                Field listenerInfoField = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
                if (listenerInfoField != null) {
                    listenerInfoField.setAccessible(true);
                }
                if ((listenerObj = listenerInfoField.get(view2)) == null) {
                    return null;
                }
                View.OnClickListener listener = null;
                Field listenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnClickListener");
                if (listenerField != null) {
                    listenerField.setAccessible(true);
                    listener = (View.OnClickListener)listenerField.get(listenerObj);
                }
                return listener;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setOnClickListener(View view, View.OnClickListener onClickListener) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return;
        }
        try {
            try {
                void newListener;
                View view2;
                Field listenerInfoField = null;
                Field listenerField = null;
                try {
                    listenerInfoField = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
                    listenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnClickListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (listenerInfoField == null || listenerField == null) {
                    view2.setOnClickListener((View.OnClickListener)newListener);
                    return;
                }
                listenerInfoField.setAccessible(true);
                listenerField.setAccessible(true);
                Object listenerObj = null;
                try {
                    listenerInfoField.setAccessible(true);
                    listenerObj = listenerInfoField.get(view2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (listenerObj == null) {
                    view2.setOnClickListener((View.OnClickListener)newListener);
                    return;
                }
                listenerField.set(listenerObj, newListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return;
        }
    }

    @Nullable
    public static View.OnTouchListener getExistingOnTouchListener(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            try {
                View view2;
                Object listenerObj;
                Field listenerInfoField = Class.forName("android.view.View").getDeclaredField("mListenerInfo");
                if (listenerInfoField != null) {
                    listenerInfoField.setAccessible(true);
                }
                if ((listenerObj = listenerInfoField.get(view2)) == null) {
                    return null;
                }
                View.OnTouchListener listener = null;
                Field listenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnTouchListener");
                if (listenerField != null) {
                    listenerField.setAccessible(true);
                    listener = (View.OnTouchListener)listenerField.get(listenerObj);
                }
                return listener;
            }
            catch (NoSuchFieldException e) {
                Utility.logd(TAG, e);
            }
            catch (ClassNotFoundException e) {
                Utility.logd(TAG, e);
            }
            catch (IllegalAccessException e) {
                Utility.logd(TAG, e);
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static View getTouchReactView(float[] fArray, @Nullable View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            void RCTRootView;
            ViewHierarchy.initTouchTargetHelperMethods();
            if (null == methodFindTouchTargetView || null == RCTRootView) {
                return null;
            }
            try {
                float[] location;
                View nativeTargetView = (View)methodFindTouchTargetView.invoke(null, location, RCTRootView);
                if (nativeTargetView != null && nativeTargetView.getId() > 0) {
                    View reactTargetView = (View)nativeTargetView.getParent();
                    return reactTargetView != null ? reactTargetView : null;
                }
            }
            catch (IllegalAccessException e) {
                Utility.logd(TAG, e);
            }
            catch (InvocationTargetException e) {
                Utility.logd(TAG, e);
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isRCTButton(View view, @Nullable View view2) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return false;
        }
        try {
            View view3;
            String className = view3.getClass().getName();
            if (className.equals(CLASS_RCTVIEWGROUP)) {
                void RCTRootView;
                float[] location = ViewHierarchy.getViewLocationOnScreen(view3);
                View touchTargetView = ViewHierarchy.getTouchReactView(location, (View)RCTRootView);
                return touchTargetView != null && touchTargetView.getId() == view3.getId();
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return false;
        }
    }

    public static boolean isRCTRootView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return false;
        }
        try {
            View view2;
            return view2.getClass().getName().equals(CLASS_RCTROOTVIEW);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return false;
        }
    }

    public static boolean isRCTTextView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return false;
        }
        try {
            View view2;
            return view2.getClass().getName().equals(CLASS_RCTTEXTVIEW);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return false;
        }
    }

    public static boolean isRCTViewGroup(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return false;
        }
        try {
            View view2;
            return view2.getClass().getName().equals(CLASS_RCTVIEWGROUP);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return false;
        }
    }

    @Nullable
    public static View findRCTRootView(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            while (null != view2) {
                if (ViewHierarchy.isRCTRootView(view2)) {
                    return view2;
                }
                ViewParent viewParent = view2.getParent();
                if (!(viewParent instanceof View)) break;
                view2 = (View)viewParent;
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    private static float[] getViewLocationOnScreen(View view) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            View view2;
            int[] location = new int[2];
            view2.getLocationOnScreen(location);
            float[] result = new float[]{location[0], location[1]};
            return result;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }

    private static void initTouchTargetHelperMethods() {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return;
        }
        try {
            if (null != methodFindTouchTargetView) {
                return;
            }
            try {
                Class<?> RCTTouchTargetHelper = Class.forName(CLASS_TOUCHTARGETHELPER);
                methodFindTouchTargetView = RCTTouchTargetHelper.getDeclaredMethod(METHOD_FIND_TOUCHTARGET_VIEW, float[].class, ViewGroup.class);
                methodFindTouchTargetView.setAccessible(true);
            }
            catch (ClassNotFoundException e) {
                Utility.logd(TAG, e);
            }
            catch (NoSuchMethodException e) {
                Utility.logd(TAG, e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return;
        }
    }

    private static Class<?> getExistingClass(String string) {
        if (CrashShieldHandler.isObjectCrashing(ViewHierarchy.class)) {
            return null;
        }
        try {
            try {
                String className;
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ViewHierarchy.class);
            return null;
        }
    }
}

