/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import com.facebook.appevents.codeless.internal.ParameterComponent;
import com.facebook.appevents.codeless.internal.PathComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventBinding {
    private final String eventName;
    private final MappingMethod method;
    private final ActionType type;
    private final String appVersion;
    private final List<PathComponent> path;
    private final List<ParameterComponent> parameters;
    private final String componentId;
    private final String pathType;
    private final String activityName;

    public EventBinding(String eventName, MappingMethod method, ActionType type, String appVersion, List<PathComponent> path, List<ParameterComponent> parameters, String componentId, String pathType, String activityName) {
        this.eventName = eventName;
        this.method = method;
        this.type = type;
        this.appVersion = appVersion;
        this.path = path;
        this.parameters = parameters;
        this.componentId = componentId;
        this.pathType = pathType;
        this.activityName = activityName;
    }

    public static List<EventBinding> parseArray(JSONArray array) {
        ArrayList<EventBinding> eventBindings = new ArrayList<EventBinding>();
        try {
            int length = array != null ? array.length() : 0;
            for (int i = 0; i < length; ++i) {
                EventBinding eventBinding = EventBinding.getInstanceFromJson(array.getJSONObject(i));
                eventBindings.add(eventBinding);
            }
        }
        catch (JSONException jSONException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return eventBindings;
    }

    public static EventBinding getInstanceFromJson(JSONObject mapping) throws JSONException, IllegalArgumentException {
        String eventName = mapping.getString("event_name");
        MappingMethod method = MappingMethod.valueOf(mapping.getString("method").toUpperCase(Locale.ENGLISH));
        ActionType type = ActionType.valueOf(mapping.getString("event_type").toUpperCase(Locale.ENGLISH));
        String appVersion = mapping.getString("app_version");
        JSONArray jsonPathArray = mapping.getJSONArray("path");
        ArrayList<PathComponent> path = new ArrayList<PathComponent>();
        for (int i = 0; i < jsonPathArray.length(); ++i) {
            JSONObject jsonPath = jsonPathArray.getJSONObject(i);
            PathComponent component = new PathComponent(jsonPath);
            path.add(component);
        }
        String pathType = mapping.optString("path_type", "absolute");
        JSONArray jsonParameterArray = mapping.optJSONArray("parameters");
        ArrayList<ParameterComponent> parameters = new ArrayList<ParameterComponent>();
        if (null != jsonParameterArray) {
            for (int i = 0; i < jsonParameterArray.length(); ++i) {
                JSONObject jsonParameter = jsonParameterArray.getJSONObject(i);
                ParameterComponent component = new ParameterComponent(jsonParameter);
                parameters.add(component);
            }
        }
        String componentId = mapping.optString("component_id");
        String activityName = mapping.optString("activity_name");
        return new EventBinding(eventName, method, type, appVersion, path, parameters, componentId, pathType, activityName);
    }

    public List<PathComponent> getViewPath() {
        return Collections.unmodifiableList(this.path);
    }

    public List<ParameterComponent> getViewParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String getEventName() {
        return this.eventName;
    }

    public ActionType getType() {
        return this.type;
    }

    public MappingMethod getMethod() {
        return this.method;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getPathType() {
        return this.pathType;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public static enum ActionType {
        CLICK,
        SELECTED,
        TEXT_CHANGED;

    }

    public static enum MappingMethod {
        MANUAL,
        INFERENCE;

    }
}

