/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.metrics;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.SystemClock;
import com.facebook.internal.Utility;
import com.facebook.internal.metrics.Tag;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class MetricsUtil {
    private final String CLASS_TAG = "internal.MetricsUtil";
    private final String STARTUP_METRICS_PREFERENCES = "MetricsUtil";
    private final String TIME_DIFFERENCE_BASE_PREF = "time_difference";
    private MetricsUtil metricsUtil;
    private HashMap<Tag, Long> taggedStartTimer = new HashMap();
    private WeakReference<Context> ctx;

    private MetricsUtil(Context ctx) {
        this.ctx = new WeakReference<Context>(ctx);
    }

    public synchronized MetricsUtil getInstance(Context ctx) {
        if (this.metricsUtil == null) {
            this.metricsUtil = new MetricsUtil(ctx);
            return this.metricsUtil;
        }
        return this.metricsUtil;
    }

    public void startMeasureFor(Tag tag) {
        this.taggedStartTimer.put(tag, SystemClock.elapsedRealtime());
    }

    public void stopMeasureFor(Tag tag) {
        long endTime = SystemClock.elapsedRealtime();
        if (!this.taggedStartTimer.containsKey((Object)tag)) {
            return;
        }
        long deltaTime = endTime - this.taggedStartTimer.get((Object)tag);
        this.taggedStartTimer.remove((Object)tag);
        this.updateLastTimeDifferenceFor(tag, deltaTime);
    }

    public long getLastTimeDifferenceFor(Tag tag) {
        if (this.ctx.get() == null) {
            Utility.logd("internal.MetricsUtil", "getLastTimeDifferenceFor: Context is null");
            return -1L;
        }
        SharedPreferences preferences = ((Context)this.ctx.get()).getSharedPreferences("MetricsUtil", 0);
        return preferences.getLong("time_difference" + tag.getSuffix(), -1L);
    }

    private void updateLastTimeDifferenceFor(Tag tag, long deltaTime) {
        if (this.ctx.get() == null) {
            Utility.logd("internal.MetricsUtil", "updateLastTimeDifferenceFor: Context is null");
            return;
        }
        SharedPreferences preferences = ((Context)this.ctx.get()).getSharedPreferences("MetricsUtil", 0);
        preferences.edit().putLong("time_difference" + tag.getSuffix(), deltaTime).apply();
    }
}

