/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import com.facebook.internal.logging.ExternalLog;
import com.facebook.internal.logging.LoggingCache;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MonitorLoggingQueue
implements LoggingCache {
    private static MonitorLoggingQueue monitorLoggingQueue;
    private Queue<ExternalLog> logQueue = new LinkedList<ExternalLog>();
    private static final Integer FLUSH_LIMIT;

    private MonitorLoggingQueue() {
    }

    public static synchronized MonitorLoggingQueue getInstance() {
        if (monitorLoggingQueue == null) {
            monitorLoggingQueue = new MonitorLoggingQueue();
        }
        return monitorLoggingQueue;
    }

    @Override
    public boolean addLog(ExternalLog log) {
        return this.addLogs(Arrays.asList(log));
    }

    @Override
    public boolean addLogs(List<? extends ExternalLog> logs) {
        if (logs != null) {
            this.logQueue.addAll(logs);
        }
        return this.hasReachedFlushLimit();
    }

    private boolean hasReachedFlushLimit() {
        return this.logQueue.size() >= FLUSH_LIMIT;
    }

    @Override
    public boolean isEmpty() {
        return this.logQueue.isEmpty();
    }

    @Override
    public ExternalLog fetchLog() {
        return this.logQueue.poll();
    }

    static {
        FLUSH_LIMIT = 100;
    }
}

