/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import android.os.Build;
import android.support.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.logging.ExternalLog;
import com.facebook.internal.logging.LoggingCache;
import com.facebook.internal.logging.LoggingManager;
import com.facebook.internal.logging.LoggingStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitorLoggingManager
implements LoggingManager {
    private static final int FLUSH_PERIOD = 60;
    private static final Integer MAX_LOG_NUMBER_PER_REQUEST = 100;
    private static final String ENTRIES_KEY = "entries";
    private static final String MONITORING_ENDPOINT = "monitorings";
    private final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
    private static MonitorLoggingManager monitorLoggingManager;
    private LoggingCache logQueue;
    private LoggingStore logStore;
    private ScheduledFuture flushTimer;
    private static String deviceOSVersion;
    private static String deviceModel;
    private final Runnable flushRunnable = new Runnable(){

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                MonitorLoggingManager.this.flushAndWait();
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }
    };

    private MonitorLoggingManager(LoggingCache monitorLoggingQueue, LoggingStore monitorLoggingStore) {
        if (this.logQueue == null) {
            this.logQueue = monitorLoggingQueue;
        }
        if (this.logStore == null) {
            this.logStore = monitorLoggingStore;
        }
    }

    public static synchronized MonitorLoggingManager getInstance(LoggingCache monitorLoggingQueue, LoggingStore logStore) {
        if (monitorLoggingManager == null) {
            monitorLoggingManager = new MonitorLoggingManager(monitorLoggingQueue, logStore);
        }
        return monitorLoggingManager;
    }

    @Override
    public void addLog(final ExternalLog log) {
        this.singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    if (MonitorLoggingManager.this.logQueue.addLog(log)) {
                        MonitorLoggingManager.this.flushAndWait();
                    } else if (MonitorLoggingManager.this.flushTimer == null) {
                        MonitorLoggingManager.this.flushTimer = MonitorLoggingManager.this.singleThreadExecutor.schedule(MonitorLoggingManager.this.flushRunnable, 60L, TimeUnit.SECONDS);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        });
    }

    @Override
    public void flushAndWait() {
        if (this.flushTimer != null) {
            this.flushTimer.cancel(true);
        }
        List<GraphRequest> requests = MonitorLoggingManager.buildRequests(this.logQueue);
        try {
            new GraphRequestBatch(requests).executeAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void flushLoggingStore() {
        List<ExternalLog> logsReadFromStore = this.logStore.readAndClearStore();
        this.logQueue.addLogs(logsReadFromStore);
        this.flushAndWait();
    }

    static List<GraphRequest> buildRequests(LoggingCache monitorLoggingQueue) {
        ArrayList<GraphRequest> requests = new ArrayList<GraphRequest>();
        String appID = FacebookSdk.getApplicationId();
        if (Utility.isNullOrEmpty(appID)) {
            return requests;
        }
        while (!monitorLoggingQueue.isEmpty()) {
            ArrayList<ExternalLog> logsReadyToBeSend = new ArrayList<ExternalLog>();
            for (int i = 0; i < MAX_LOG_NUMBER_PER_REQUEST && !monitorLoggingQueue.isEmpty(); ++i) {
                ExternalLog log = monitorLoggingQueue.fetchLog();
                logsReadyToBeSend.add(log);
            }
            GraphRequest postRequest = MonitorLoggingManager.buildPostRequestFromLogs(logsReadyToBeSend);
            if (postRequest == null) continue;
            requests.add(postRequest);
        }
        return requests;
    }

    @Nullable
    static GraphRequest buildPostRequestFromLogs(List<? extends ExternalLog> logs) {
        String packageName = FacebookSdk.getApplicationContext().getPackageName();
        JSONArray logsToParams = new JSONArray();
        for (ExternalLog externalLog : logs) {
            logsToParams.put((Object)externalLog.convertToJSONObject());
        }
        if (logsToParams.length() == 0) {
            return null;
        }
        JSONObject params = new JSONObject();
        try {
            params.put("device_os_version", (Object)deviceOSVersion);
            params.put("device_model", (Object)deviceModel);
            params.put("unique_application_identifier", (Object)packageName);
            params.put(ENTRIES_KEY, (Object)logsToParams);
        }
        catch (JSONException jSONException) {
            return null;
        }
        return GraphRequest.newPostRequest(null, String.format("%s/monitorings", FacebookSdk.getApplicationId()), params, null);
    }

    static {
        deviceOSVersion = Build.VERSION.RELEASE;
        deviceModel = Build.MODEL;
    }
}

