/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.instrument.ExceptionAnalyzer;
import com.facebook.internal.instrument.crashreport.CrashHandler;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.instrument.errorreport.ErrorReportHandler;
import com.facebook.internal.instrument.threadcheck.ThreadCheckHandler;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InstrumentManager {
    public static void start() {
        if (!FacebookSdk.getAutoLogAppEventsEnabled()) {
            return;
        }
        FeatureManager.checkFeature(FeatureManager.Feature.CrashReport, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (enabled) {
                    CrashHandler.enable();
                    if (FeatureManager.isEnabled(FeatureManager.Feature.CrashShield)) {
                        ExceptionAnalyzer.enable();
                        CrashShieldHandler.enable();
                    }
                    if (FeatureManager.isEnabled(FeatureManager.Feature.ThreadCheck)) {
                        ThreadCheckHandler.enable();
                    }
                }
            }
        });
        FeatureManager.checkFeature(FeatureManager.Feature.ErrorReport, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (enabled) {
                    ErrorReportHandler.enable();
                }
            }
        });
    }
}

