/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.ListView;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.CodelessLoggingEventListener;
import com.facebook.appevents.codeless.RCTCodelessLoggingEventListener;
import com.facebook.appevents.codeless.internal.EventBinding;
import com.facebook.appevents.codeless.internal.ParameterComponent;
import com.facebook.appevents.codeless.internal.PathComponent;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.instrument.threadcheck.ThreadCheckHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

class CodelessMatcher {
    private static final String PARENT_CLASS_NAME = "..";
    private static final String CURRENT_CLASS_NAME = ".";
    private static final String TAG = CodelessMatcher.class.getCanonicalName();
    private final Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    private Set<Activity> activitiesSet = Collections.newSetFromMap(new WeakHashMap());
    private Set<ViewMatcher> viewMatchers = new HashSet<ViewMatcher>();
    private HashSet<String> listenerSet = new HashSet();
    private HashMap<Integer, HashSet<String>> activityToListenerMap = new HashMap();
    private static CodelessMatcher codelessMatcher = null;

    private CodelessMatcher() {
    }

    public static synchronized CodelessMatcher getInstance() {
        if (CrashShieldHandler.isObjectCrashing(CodelessMatcher.class)) {
            return null;
        }
        try {
            if (codelessMatcher == null) {
                codelessMatcher = new CodelessMatcher();
            }
            return codelessMatcher;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessMatcher.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(Activity activity) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            ThreadCheckHandler.uiThreadViolationDetected(CodelessMatcher.class, "add", "(Landroid/app/Activity;)V");
        }
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void activity2;
            if (InternalSettings.isUnityApp()) {
                return;
            }
            if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
                throw new FacebookException("Can't add activity to CodelessMatcher on non-UI thread");
            }
            this.activitiesSet.add((Activity)activity2);
            this.listenerSet.clear();
            if (this.activityToListenerMap.containsKey(activity2.hashCode())) {
                this.listenerSet = this.activityToListenerMap.get(activity2.hashCode());
            }
            this.startTracking();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void remove(Activity activity) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            ThreadCheckHandler.uiThreadViolationDetected(CodelessMatcher.class, "remove", "(Landroid/app/Activity;)V");
        }
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void activity2;
            if (InternalSettings.isUnityApp()) {
                return;
            }
            if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
                throw new FacebookException("Can't remove activity from CodelessMatcher on non-UI thread");
            }
            this.activitiesSet.remove(activity2);
            this.viewMatchers.clear();
            this.activityToListenerMap.put(activity2.hashCode(), (HashSet)this.listenerSet.clone());
            this.listenerSet.clear();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void destroy(Activity activity) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            ThreadCheckHandler.uiThreadViolationDetected(CodelessMatcher.class, "destroy", "(Landroid/app/Activity;)V");
        }
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void activity2;
            this.activityToListenerMap.remove(activity2.hashCode());
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Bundle getParameters(EventBinding eventBinding, View view, View view2) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            ThreadCheckHandler.uiThreadViolationDetected(CodelessMatcher.class, "getParameters", "(Lcom/facebook/appevents/codeless/internal/EventBinding;Landroid/view/View;Landroid/view/View;)Landroid/os/Bundle;");
        }
        if (CrashShieldHandler.isObjectCrashing(CodelessMatcher.class)) {
            return null;
        }
        try {
            EventBinding mapping;
            Bundle params = new Bundle();
            if (null == mapping) {
                return params;
            }
            List<ParameterComponent> parameters = mapping.getViewParameters();
            if (null != parameters) {
                block2: for (ParameterComponent component : parameters) {
                    void rootView;
                    void hostView;
                    if (component.value != null && component.value.length() > 0) {
                        params.putString(component.name, component.value);
                        continue;
                    }
                    if (component.path.size() <= 0) continue;
                    String pathType = component.pathType;
                    List<MatchedView> matchedViews = pathType.equals("relative") ? ViewMatcher.findViewByPath(mapping, (View)hostView, component.path, 0, -1, hostView.getClass().getSimpleName()) : ViewMatcher.findViewByPath(mapping, (View)rootView, component.path, 0, -1, rootView.getClass().getSimpleName());
                    for (MatchedView view3 : matchedViews) {
                        String text;
                        if (view3.getView() == null || (text = ViewHierarchy.getTextOfView(view3.getView())).length() <= 0) continue;
                        params.putString(component.name, text);
                        continue block2;
                    }
                }
            }
            return params;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessMatcher.class);
            return null;
        }
    }

    private void startTracking() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                this.matchViews();
            } else {
                this.uiThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            CodelessMatcher.access$000(CodelessMatcher.this);
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private void matchViews() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            for (Activity activity : this.activitiesSet) {
                if (null == activity) continue;
                View rootView = AppEventUtility.getRootView(activity);
                String activityName = activity.getClass().getSimpleName();
                ViewMatcher matcher = new ViewMatcher(rootView, this.uiThreadHandler, this.listenerSet, activityName);
                this.viewMatchers.add(matcher);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    static /* synthetic */ void access$000(CodelessMatcher codelessMatcher) {
        if (CrashShieldHandler.isObjectCrashing(CodelessMatcher.class)) {
            return;
        }
        try {
            CodelessMatcher x0;
            x0.matchViews();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessMatcher.class);
            return;
        }
    }

    static /* synthetic */ String access$100() {
        if (CrashShieldHandler.isObjectCrashing(CodelessMatcher.class)) {
            return null;
        }
        try {
            return TAG;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, CodelessMatcher.class);
            return null;
        }
    }

    protected static class ViewMatcher
    implements ViewTreeObserver.OnGlobalLayoutListener,
    ViewTreeObserver.OnScrollChangedListener,
    Runnable {
        private WeakReference<View> rootView;
        @Nullable
        private List<EventBinding> eventBindings;
        private final Handler handler;
        private HashSet<String> listenerSet;
        private final String activityName;

        /*
         * WARNING - void declaration
         */
        public ViewMatcher(View view, Handler handler, HashSet<String> hashSet, String string) {
            void activityName;
            void listenerSet;
            void handler2;
            void rootView;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "<init>", "(Landroid/view/View;Landroid/os/Handler;Ljava/util/HashSet;Ljava/lang/String;)V");
            }
            this.rootView = new WeakReference<void>(rootView);
            this.handler = handler2;
            this.listenerSet = listenerSet;
            this.activityName = activityName;
            this.handler.postDelayed((Runnable)this, 200L);
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                String appId;
                FetchedAppSettings appSettings;
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "run", "()V");
                }
                if ((appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId = FacebookSdk.getApplicationId())) == null || !appSettings.getCodelessEventsEnabled()) {
                    return;
                }
                this.eventBindings = EventBinding.parseArray(appSettings.getEventBindings());
                if (this.eventBindings != null) {
                    View rootView = (View)this.rootView.get();
                    if (rootView == null) {
                        return;
                    }
                    ViewTreeObserver observer = rootView.getViewTreeObserver();
                    if (observer.isAlive()) {
                        observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        observer.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    }
                    this.startMatch();
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }

        public void onGlobalLayout() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "onGlobalLayout", "()V");
            }
            this.startMatch();
        }

        public void onScrollChanged() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "onScrollChanged", "()V");
            }
            this.startMatch();
        }

        private void startMatch() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "startMatch", "()V");
            }
            if (this.eventBindings != null && this.rootView.get() != null) {
                for (int i = 0; i < this.eventBindings.size(); ++i) {
                    EventBinding binding = this.eventBindings.get(i);
                    this.findView(binding, (View)this.rootView.get());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void findView(EventBinding eventBinding, View view) {
            void rootView;
            void mapping;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "findView", "(Lcom/facebook/appevents/codeless/internal/EventBinding;Landroid/view/View;)V");
            }
            if (mapping == null || rootView == null) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)mapping.getActivityName()) && !mapping.getActivityName().equals(this.activityName)) {
                return;
            }
            List<PathComponent> path = mapping.getViewPath();
            if (path.size() > 25) {
                return;
            }
            List<MatchedView> matchedViews = ViewMatcher.findViewByPath((EventBinding)mapping, (View)rootView, path, 0, -1, this.activityName);
            for (MatchedView view2 : matchedViews) {
                this.attachListener(view2, (View)rootView, (EventBinding)mapping);
            }
        }

        /*
         * WARNING - void declaration
         */
        public static List<MatchedView> findViewByPath(EventBinding eventBinding, View view, List<PathComponent> list, int n, int n2, String string) {
            EventBinding mapping;
            void path;
            void level;
            void view2;
            void index;
            String mapKey;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "findViewByPath", "(Lcom/facebook/appevents/codeless/internal/EventBinding;Landroid/view/View;Ljava/util/List;IILjava/lang/String;)Ljava/util/List;");
            }
            mapKey = mapKey + CodelessMatcher.CURRENT_CLASS_NAME + String.valueOf((int)index);
            ArrayList<MatchedView> result = new ArrayList<MatchedView>();
            if (null == view2) {
                return result;
            }
            if (level >= path.size()) {
                result.add(new MatchedView((View)view2, mapKey));
            } else {
                PathComponent pathElement = (PathComponent)path.get((int)level);
                if (pathElement.className.equals(CodelessMatcher.PARENT_CLASS_NAME)) {
                    ViewParent parent = view2.getParent();
                    if (parent instanceof ViewGroup) {
                        ViewGroup viewGroup = (ViewGroup)parent;
                        List<View> visibleViews = ViewMatcher.findVisibleChildren(viewGroup);
                        int childCount = visibleViews.size();
                        for (int i = 0; i < childCount; ++i) {
                            View child = visibleViews.get(i);
                            List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, child, (List<PathComponent>)path, (int)(level + true), i, mapKey);
                            result.addAll(matchedViews);
                        }
                    }
                    return result;
                }
                if (pathElement.className.equals(CodelessMatcher.CURRENT_CLASS_NAME)) {
                    result.add(new MatchedView((View)view2, mapKey));
                    return result;
                }
                if (!ViewMatcher.isTheSameView((View)view2, pathElement, (int)index)) {
                    return result;
                }
                if (level == path.size() - 1) {
                    result.add(new MatchedView((View)view2, mapKey));
                }
            }
            if (view2 instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view2;
                List<View> visibleViews = ViewMatcher.findVisibleChildren(viewGroup);
                int childCount = visibleViews.size();
                for (int i = 0; i < childCount; ++i) {
                    View child = visibleViews.get(i);
                    List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, child, (List<PathComponent>)path, (int)(level + true), i, mapKey);
                    result.addAll(matchedViews);
                }
            }
            return result;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isTheSameView(View view, PathComponent pathComponent, int n) {
            View targetView;
            void index;
            void pathElement;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "isTheSameView", "(Landroid/view/View;Lcom/facebook/appevents/codeless/internal/PathComponent;I)Z");
            }
            if (pathElement.index != -1 && index != pathElement.index) {
                return false;
            }
            if (!targetView.getClass().getCanonicalName().equals(pathElement.className)) {
                if (!pathElement.className.matches(".*android\\..*")) return false;
                String[] names = pathElement.className.split("\\.");
                if (names.length <= 0) return false;
                String SimpleName = names[names.length - 1];
                if (!targetView.getClass().getSimpleName().equals(SimpleName)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.ID.getValue()) > 0 && pathElement.id != targetView.getId()) {
                return false;
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.TEXT.getValue()) > 0) {
                String pathText = pathElement.text;
                String text = ViewHierarchy.getTextOfView(targetView);
                String hashedText = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(text), "");
                if (!pathText.equals(text) && !pathText.equals(hashedText)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.DESCRIPTION.getValue()) > 0) {
                String pathDesc = pathElement.description;
                String targetDesc = targetView.getContentDescription() == null ? "" : String.valueOf(targetView.getContentDescription());
                String hashedDesc = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetDesc), "");
                if (!pathDesc.equals(targetDesc) && !pathDesc.equals(hashedDesc)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.HINT.getValue()) > 0) {
                String pathHint = pathElement.hint;
                String targetHint = ViewHierarchy.getHintOfView(targetView);
                String hashedHint = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetHint), "");
                if (!pathHint.equals(targetHint) && !pathHint.equals(hashedHint)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.TAG.getValue()) <= 0) return true;
            String tag = pathElement.tag;
            String targetTag = targetView.getTag() == null ? "" : String.valueOf(targetView.getTag());
            String hashedTag = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetTag), "");
            if (tag.equals(targetTag) || tag.equals(hashedTag)) return true;
            return false;
        }

        private static List<View> findVisibleChildren(ViewGroup viewGroup) {
            ViewGroup viewGroup2;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "findVisibleChildren", "(Landroid/view/ViewGroup;)Ljava/util/List;");
            }
            ArrayList<View> visibleViews = new ArrayList<View>();
            int childCount = viewGroup2.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup2.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                visibleViews.add(child);
            }
            return visibleViews;
        }

        /*
         * WARNING - void declaration
         */
        private void attachListener(MatchedView matchedView, View view, EventBinding eventBinding) {
            void mapping;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "attachListener", "(Lcom/facebook/appevents/codeless/CodelessMatcher$MatchedView;Landroid/view/View;Lcom/facebook/appevents/codeless/internal/EventBinding;)V");
            }
            if (mapping == null) {
                return;
            }
            try {
                void rootView;
                void matchedView2;
                View view2 = matchedView2.getView();
                if (view2 == null) {
                    return;
                }
                View RCTRootView = ViewHierarchy.findRCTRootView(view2);
                if (null != RCTRootView && ViewHierarchy.isRCTButton(view2, RCTRootView)) {
                    this.attachRCTListener((MatchedView)matchedView2, (View)rootView, (EventBinding)mapping);
                    return;
                }
                if (view2.getClass().getName().startsWith("com.facebook.react")) {
                    return;
                }
                if (!(view2 instanceof AdapterView)) {
                    this.attachOnClickListener((MatchedView)matchedView2, (View)rootView, (EventBinding)mapping);
                } else if (view2 instanceof ListView) {
                    this.attachOnItemClickListener((MatchedView)matchedView2, (View)rootView, (EventBinding)mapping);
                }
            }
            catch (Exception e) {
                Utility.logd(CodelessMatcher.access$100(), e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void attachOnClickListener(MatchedView matchedView, View view, EventBinding eventBinding) {
            boolean listenerSupportCodelessLogging;
            void matchedView2;
            View view2;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "attachOnClickListener", "(Lcom/facebook/appevents/codeless/CodelessMatcher$MatchedView;Landroid/view/View;Lcom/facebook/appevents/codeless/internal/EventBinding;)V");
            }
            if ((view2 = matchedView2.getView()) == null) {
                return;
            }
            String mapKey = matchedView2.getViewMapKey();
            View.OnClickListener existingListener = ViewHierarchy.getExistingOnClickListener(view2);
            boolean isCodelessListener = existingListener instanceof CodelessLoggingEventListener.AutoLoggingOnClickListener;
            boolean bl = listenerSupportCodelessLogging = isCodelessListener && ((CodelessLoggingEventListener.AutoLoggingOnClickListener)existingListener).getSupportCodelessLogging();
            if (!this.listenerSet.contains(mapKey) && !listenerSupportCodelessLogging) {
                void rootView;
                void mapping;
                CodelessLoggingEventListener.AutoLoggingOnClickListener listener = CodelessLoggingEventListener.getOnClickListener((EventBinding)mapping, (View)rootView, view2);
                view2.setOnClickListener((View.OnClickListener)listener);
                this.listenerSet.add(mapKey);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void attachOnItemClickListener(MatchedView matchedView, View view, EventBinding eventBinding) {
            boolean listenerSupportCodelessLogging;
            void matchedView2;
            AdapterView view2;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "attachOnItemClickListener", "(Lcom/facebook/appevents/codeless/CodelessMatcher$MatchedView;Landroid/view/View;Lcom/facebook/appevents/codeless/internal/EventBinding;)V");
            }
            if ((view2 = (AdapterView)matchedView2.getView()) == null) {
                return;
            }
            String mapKey = matchedView2.getViewMapKey();
            AdapterView.OnItemClickListener existingListener = view2.getOnItemClickListener();
            boolean isCodelessListener = existingListener instanceof CodelessLoggingEventListener.AutoLoggingOnItemClickListener;
            boolean bl = listenerSupportCodelessLogging = isCodelessListener && ((CodelessLoggingEventListener.AutoLoggingOnItemClickListener)existingListener).getSupportCodelessLogging();
            if (!this.listenerSet.contains(mapKey) && !listenerSupportCodelessLogging) {
                void rootView;
                void mapping;
                CodelessLoggingEventListener.AutoLoggingOnItemClickListener listener = CodelessLoggingEventListener.getOnItemClickListener((EventBinding)mapping, (View)rootView, view2);
                view2.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
                this.listenerSet.add(mapKey);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void attachRCTListener(MatchedView matchedView, View view, EventBinding eventBinding) {
            boolean listenerSupportCodelessLogging;
            void matchedView2;
            View view2;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(ViewMatcher.class, "attachRCTListener", "(Lcom/facebook/appevents/codeless/CodelessMatcher$MatchedView;Landroid/view/View;Lcom/facebook/appevents/codeless/internal/EventBinding;)V");
            }
            if ((view2 = matchedView2.getView()) == null) {
                return;
            }
            String mapKey = matchedView2.getViewMapKey();
            View.OnTouchListener existingListener = ViewHierarchy.getExistingOnTouchListener(view2);
            boolean isRCTCodelessListener = existingListener instanceof RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener;
            boolean bl = listenerSupportCodelessLogging = isRCTCodelessListener && ((RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener)existingListener).getSupportCodelessLogging();
            if (!this.listenerSet.contains(mapKey) && !listenerSupportCodelessLogging) {
                void rootView;
                void mapping;
                RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener listener = RCTCodelessLoggingEventListener.getOnTouchListener((EventBinding)mapping, (View)rootView, view2);
                view2.setOnTouchListener((View.OnTouchListener)listener);
                this.listenerSet.add(mapKey);
            }
        }
    }

    public static class MatchedView {
        private WeakReference<View> view;
        private String viewMapKey;

        public MatchedView(View view, String viewMapKey) {
            this.view = new WeakReference<View>(view);
            this.viewMapKey = viewMapKey;
        }

        @Nullable
        public View getView() {
            return this.view == null ? null : (View)this.view.get();
        }

        public String getViewMapKey() {
            return this.viewMapKey;
        }
    }
}

