/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.aam.MetadataMatcher;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.instrument.threadcheck.ThreadCheckHandler;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

final class MetadataViewObserver
implements ViewTreeObserver.OnGlobalFocusChangeListener {
    private static final String TAG = MetadataViewObserver.class.getCanonicalName();
    private static final int MAX_TEXT_LENGTH = 100;
    private static final Map<Integer, MetadataViewObserver> observers = new HashMap<Integer, MetadataViewObserver>();
    private final Set<String> processedText = new HashSet<String>();
    private final Handler uiThreadHandler;
    private WeakReference<Activity> activityWeakReference;
    private AtomicBoolean isTracking;

    private MetadataViewObserver(Activity activity) {
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        this.isTracking = new AtomicBoolean(false);
    }

    static void startTrackingActivity(Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(MetadataViewObserver.class)) {
            return;
        }
        try {
            MetadataViewObserver observer;
            Activity activity2;
            int key;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(MetadataViewObserver.class, "startTrackingActivity", "(Landroid/app/Activity;)V");
            }
            if (!observers.containsKey(key = activity2.hashCode())) {
                observer = new MetadataViewObserver(activity2);
                observers.put(activity2.hashCode(), observer);
            } else {
                observer = observers.get(key);
            }
            observer.startTracking();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataViewObserver.class);
            return;
        }
    }

    static void stopTrackingActivity(Activity activity) {
        if (CrashShieldHandler.isObjectCrashing(MetadataViewObserver.class)) {
            return;
        }
        try {
            Activity activity2;
            int key;
            if (Looper.myLooper() != Looper.getMainLooper()) {
                ThreadCheckHandler.uiThreadViolationDetected(MetadataViewObserver.class, "stopTrackingActivity", "(Landroid/app/Activity;)V");
            }
            if (observers.containsKey(key = activity2.hashCode())) {
                MetadataViewObserver observer = observers.get(activity2.hashCode());
                observers.remove(key);
                observer.stopTracking();
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataViewObserver.class);
            return;
        }
    }

    private void startTracking() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (this.isTracking.getAndSet(true)) {
                return;
            }
            View rootView = AppEventUtility.getRootView((Activity)this.activityWeakReference.get());
            if (rootView == null) {
                return;
            }
            ViewTreeObserver observer = rootView.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private void stopTracking() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (!this.isTracking.getAndSet(false)) {
                return;
            }
            View rootView = AppEventUtility.getRootView((Activity)this.activityWeakReference.get());
            if (rootView == null) {
                return;
            }
            ViewTreeObserver observer = rootView.getViewTreeObserver();
            if (!observer.isAlive()) {
                return;
            }
            observer.removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onGlobalFocusChanged(@Nullable View view, @Nullable View view2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void newView;
            void oldView;
            if (oldView != null) {
                this.process((View)oldView);
            }
            if (newView != null) {
                this.process((View)newView);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process(View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void view2;
            Runnable runnable = new Runnable((View)view2){
                final /* synthetic */ View val$view;
                {
                    this.val$view = view;
                }

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        if (!(this.val$view instanceof EditText)) {
                            return;
                        }
                        MetadataViewObserver.access$000(MetadataViewObserver.this, this.val$view);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            };
            this.runOnUIThread(runnable);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processEditText(View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void view2;
            String text = ((EditText)view2).getText().toString().trim().toLowerCase();
            if (text.isEmpty() || this.processedText.contains(text) || text.length() > 100) {
                return;
            }
            this.processedText.add(text);
            HashMap<String, String> userData = new HashMap<String, String>();
            List<String> currentViewIndicators = MetadataMatcher.getCurrentViewIndicators((View)view2);
            List<String> aroundTextIndicators = null;
            for (MetadataRule rule : MetadataRule.getRules()) {
                String normalizedText = MetadataViewObserver.preNormalize(rule.getName(), text);
                if (!rule.getValRule().isEmpty() && !MetadataMatcher.matchValue(normalizedText, rule.getValRule())) continue;
                if (MetadataMatcher.matchIndicator(currentViewIndicators, rule.getKeyRules())) {
                    MetadataViewObserver.putUserData(userData, rule.getName(), normalizedText);
                    continue;
                }
                if (aroundTextIndicators == null) {
                    aroundTextIndicators = MetadataMatcher.getAroundViewIndicators((View)view2);
                }
                if (!MetadataMatcher.matchIndicator(aroundTextIndicators, rule.getKeyRules())) continue;
                MetadataViewObserver.putUserData(userData, rule.getName(), normalizedText);
            }
            InternalAppEventsLogger.setInternalUserData(userData);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String preNormalize(String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(MetadataViewObserver.class)) {
            return null;
        }
        try {
            void val;
            String key;
            if ("r2".equals(key)) {
                return val.replaceAll("[^\\d.]", "");
            }
            return val;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataViewObserver.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void putUserData(Map<String, String> map, String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(MetadataViewObserver.class)) {
            return;
        }
        try {
            Map<String, String> userData;
            String val;
            void key;
            switch (key) {
                case "r3": {
                    if (val.startsWith("m") || val.startsWith("b") || val.startsWith("ge")) {
                        val = "m";
                        break;
                    }
                    val = "f";
                    break;
                }
                case "r4": 
                case "r5": {
                    val = val.replaceAll("[^a-z]+", "");
                    break;
                }
                case "r6": {
                    if (!val.contains("-")) break;
                    String[] splitArray = val.split("-");
                    val = splitArray[0];
                }
            }
            userData.put((String)key, val);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataViewObserver.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runOnUIThread(Runnable runnable) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            void runnable2;
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                runnable2.run();
            } else {
                this.uiThreadHandler.post((Runnable)runnable2);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(MetadataViewObserver metadataViewObserver, View view) {
        if (CrashShieldHandler.isObjectCrashing(MetadataViewObserver.class)) {
            return;
        }
        try {
            void x1;
            MetadataViewObserver x0;
            x0.processEditText((View)x1);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataViewObserver.class);
            return;
        }
    }
}

