/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.support.annotation.RestrictTo;
import com.facebook.appevents.UserDataStore;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class MetadataRule {
    private static final String TAG = MetadataRule.class.getCanonicalName();
    private static List<MetadataRule> rules = new ArrayList<MetadataRule>();
    private static final String FIELD_K = "k";
    private static final String FIELD_V = "v";
    private static final String FIELD_K_DELIMITER = ",";
    private String name;
    private List<String> keyRules;
    private String valRule;

    private MetadataRule(String name, List<String> keyRules, String valRule) {
        this.name = name;
        this.keyRules = keyRules;
        this.valRule = valRule;
    }

    static List<MetadataRule> getRules() {
        if (CrashShieldHandler.isObjectCrashing(MetadataRule.class)) {
            return null;
        }
        try {
            return new ArrayList<MetadataRule>(rules);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataRule.class);
            return null;
        }
    }

    String getName() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            return this.name;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    List<String> getKeyRules() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            return new ArrayList<String>(this.keyRules);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    String getValRule() {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            return this.valRule;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    static void updateRules(String string) {
        if (CrashShieldHandler.isObjectCrashing(MetadataRule.class)) {
            return;
        }
        try {
            try {
                String rulesFromServer;
                rules.clear();
                JSONObject jsonObject = new JSONObject(rulesFromServer);
                MetadataRule.constructRules(jsonObject);
                MetadataRule.removeUnusedRules();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataRule.class);
            return;
        }
    }

    private static void constructRules(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(MetadataRule.class)) {
            return;
        }
        try {
            JSONObject jsonObject;
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONObject rule = jsonObject.optJSONObject(key);
                if (rule == null) continue;
                String k = rule.optString(FIELD_K);
                String v = rule.optString(FIELD_V);
                if (k.isEmpty()) continue;
                rules.add(new MetadataRule(key, Arrays.asList(k.split(FIELD_K_DELIMITER)), v));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataRule.class);
            return;
        }
    }

    private static void removeUnusedRules() {
        if (CrashShieldHandler.isObjectCrashing(MetadataRule.class)) {
            return;
        }
        try {
            Map<String, String> internalHashedUserData = UserDataStore.getInternalHashedUserData();
            if (internalHashedUserData.isEmpty()) {
                return;
            }
            HashSet<String> ruleNames = new HashSet<String>();
            for (MetadataRule r : rules) {
                ruleNames.add(r.getName());
            }
            ArrayList<String> rulesToRemove = new ArrayList<String>();
            for (String ruleKey : internalHashedUserData.keySet()) {
                if (ruleNames.contains(ruleKey)) continue;
                rulesToRemove.add(ruleKey);
            }
            if (!rulesToRemove.isEmpty()) {
                UserDataStore.removeRules(rulesToRemove);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataRule.class);
            return;
        }
    }
}

