/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.aam.MetadataRule;
import com.facebook.appevents.aam.MetadataViewObserver;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.instrument.threadcheck.ThreadCheckHandler;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MetadataIndexer {
    private static final String TAG = MetadataIndexer.class.getCanonicalName();
    private static Boolean enabled = false;

    public static void onActivityResumed(Activity activity) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            ThreadCheckHandler.uiThreadViolationDetected(MetadataIndexer.class, "onActivityResumed", "(Landroid/app/Activity;)V");
        }
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            try {
                Activity activity2;
                if (!enabled.booleanValue() || MetadataRule.getRules().isEmpty()) {
                    return;
                }
                MetadataViewObserver.startTrackingActivity(activity2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }

    private static void updateRules() {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
            if (settings == null) {
                return;
            }
            String rawRule = settings.getRawAamRules();
            if (rawRule == null) {
                return;
            }
            MetadataRule.updateRules(rawRule);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }

    public static void enable() {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            try {
                FacebookSdk.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            Context context = FacebookSdk.getApplicationContext();
                            if (!AttributionIdentifiers.isTrackingLimited(context)) {
                                MetadataIndexer.access$000();
                                MetadataIndexer.access$102(true);
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                });
            }
            catch (Exception e) {
                Utility.logd(TAG, e);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }

    static /* synthetic */ void access$000() {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return;
        }
        try {
            MetadataIndexer.updateRules();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return;
        }
    }

    static /* synthetic */ Boolean access$102(Boolean bl) {
        if (CrashShieldHandler.isObjectCrashing(MetadataIndexer.class)) {
            return null;
        }
        try {
            Boolean x0;
            enabled = x0;
            return enabled;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, MetadataIndexer.class);
            return null;
        }
    }
}

