/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class GraphResponse {
    private static final String TAG = GraphResponse.class.getSimpleName();
    private final HttpURLConnection connection;
    private final JSONObject graphObject;
    private final JSONArray graphObjectArray;
    private final FacebookRequestError error;
    private final String rawResponse;
    private final GraphRequest request;
    public static final String NON_JSON_RESPONSE_PROPERTY = "FACEBOOK_NON_JSON_RESULT";
    public static final String SUCCESS_KEY = "success";
    private static final String CODE_KEY = "code";
    private static final String BODY_KEY = "body";
    private static final String RESPONSE_LOG_TAG = "Response";

    public GraphResponse(GraphRequest request, HttpURLConnection connection, String rawResponse, JSONObject graphObject) {
        this(request, connection, rawResponse, graphObject, null, null);
    }

    public GraphResponse(GraphRequest request, HttpURLConnection connection, String rawResponse, JSONArray graphObjects) {
        this(request, connection, rawResponse, null, graphObjects, null);
    }

    public GraphResponse(GraphRequest request, HttpURLConnection connection, FacebookRequestError error) {
        this(request, connection, null, null, null, error);
    }

    GraphResponse(GraphRequest request, HttpURLConnection connection, String rawResponse, JSONObject graphObject, JSONArray graphObjects, FacebookRequestError error) {
        this.request = request;
        this.connection = connection;
        this.rawResponse = rawResponse;
        this.graphObject = graphObject;
        this.graphObjectArray = graphObjects;
        this.error = error;
    }

    public final FacebookRequestError getError() {
        return this.error;
    }

    public final JSONObject getJSONObject() {
        return this.graphObject;
    }

    public final JSONArray getJSONArray() {
        return this.graphObjectArray;
    }

    public final HttpURLConnection getConnection() {
        return this.connection;
    }

    public GraphRequest getRequest() {
        return this.request;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public GraphRequest getRequestForPagedResults(PagingDirection direction) {
        GraphRequest pagingRequest;
        JSONObject pagingInfo;
        String link = null;
        if (this.graphObject != null && (pagingInfo = this.graphObject.optJSONObject("paging")) != null) {
            link = direction == PagingDirection.NEXT ? pagingInfo.optString("next") : pagingInfo.optString("previous");
        }
        if (Utility.isNullOrEmpty(link)) {
            return null;
        }
        if (link != null && link.equals(this.request.getUrlForSingleRequest())) {
            return null;
        }
        try {
            pagingRequest = new GraphRequest(this.request.getAccessToken(), new URL(link));
        }
        catch (MalformedURLException e) {
            return null;
        }
        return pagingRequest;
    }

    public String toString() {
        String responseCode;
        try {
            responseCode = String.format(Locale.US, "%d", this.connection != null ? this.connection.getResponseCode() : 200);
        }
        catch (IOException e) {
            responseCode = "unknown";
        }
        return "{Response: " + " responseCode: " + responseCode + ", graphObject: " + this.graphObject + ", error: " + this.error + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static List<GraphResponse> fromHttpConnection(HttpURLConnection connection, GraphRequestBatch requests) {
        List<GraphResponse> msg2222222222;
        InputStream stream = null;
        try {
            if (!FacebookSdk.isFullyInitialized()) {
                String msg2222222222 = "GraphRequest can't be used when Facebook SDK isn't fully initialized";
                Log.e((String)TAG, (String)msg2222222222);
                throw new FacebookException(msg2222222222);
            }
            stream = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
            msg2222222222 = GraphResponse.createResponsesFromStream(stream, connection, requests);
        }
        catch (FacebookException facebookException) {
            Logger.log(LoggingBehavior.REQUESTS, RESPONSE_LOG_TAG, "Response <Error>: %s", facebookException);
            List<GraphResponse> list = GraphResponse.constructErrorResponses(requests, connection, facebookException);
            Utility.closeQuietly(stream);
            return list;
        }
        catch (Exception exception) {
            Logger.log(LoggingBehavior.REQUESTS, RESPONSE_LOG_TAG, "Response <Error>: %s", exception);
            List<GraphResponse> list = GraphResponse.constructErrorResponses(requests, connection, new FacebookException(exception));
            {
                catch (Throwable throwable) {
                    Utility.closeQuietly(stream);
                    throw throwable;
                }
            }
            Utility.closeQuietly(stream);
            return list;
        }
        Utility.closeQuietly(stream);
        return msg2222222222;
    }

    static List<GraphResponse> createResponsesFromStream(InputStream stream, HttpURLConnection connection, GraphRequestBatch requests) throws FacebookException, JSONException, IOException {
        String responseString = Utility.readStreamToString(stream);
        Logger.log(LoggingBehavior.INCLUDE_RAW_RESPONSES, RESPONSE_LOG_TAG, "Response (raw)\n  Size: %d\n  Response:\n%s\n", responseString.length(), responseString);
        return GraphResponse.createResponsesFromString(responseString, connection, requests);
    }

    static List<GraphResponse> createResponsesFromString(String responseString, HttpURLConnection connection, GraphRequestBatch requests) throws FacebookException, JSONException, IOException {
        JSONTokener tokener = new JSONTokener(responseString);
        Object resultObject = tokener.nextValue();
        List<GraphResponse> responses = GraphResponse.createResponsesFromObject(connection, requests, resultObject);
        Logger.log(LoggingBehavior.REQUESTS, RESPONSE_LOG_TAG, "Response\n  Id: %s\n  Size: %d\n  Responses:\n%s\n", requests.getId(), responseString.length(), responses);
        return responses;
    }

    private static List<GraphResponse> createResponsesFromObject(HttpURLConnection connection, List<GraphRequest> requests, Object object) throws FacebookException, JSONException {
        int numRequests = requests.size();
        ArrayList<GraphResponse> responses = new ArrayList<GraphResponse>(numRequests);
        Object originalResult = object;
        if (numRequests == 1) {
            GraphRequest request = requests.get(0);
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(BODY_KEY, object);
                int responseCode = connection != null ? connection.getResponseCode() : 200;
                jsonObject.put(CODE_KEY, responseCode);
                JSONArray jsonArray = new JSONArray();
                jsonArray.put((Object)jsonObject);
                object = jsonArray;
            }
            catch (JSONException e) {
                responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, (Exception)((Object)e))));
            }
            catch (IOException e) {
                responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, e)));
            }
        }
        if (!(object instanceof JSONArray) || ((JSONArray)object).length() != numRequests) {
            throw new FacebookException("Unexpected number of results");
        }
        JSONArray jsonArray = (JSONArray)object;
        for (int i = 0; i < jsonArray.length(); ++i) {
            GraphRequest request = requests.get(i);
            try {
                Object obj = jsonArray.get(i);
                responses.add(GraphResponse.createResponseFromObject(request, connection, obj, originalResult));
                continue;
            }
            catch (JSONException e) {
                responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, (Exception)((Object)e))));
                continue;
            }
            catch (FacebookException e) {
                responses.add(new GraphResponse(request, connection, new FacebookRequestError(connection, e)));
            }
        }
        return responses;
    }

    private static GraphResponse createResponseFromObject(GraphRequest request, HttpURLConnection connection, Object object, Object originalResult) throws JSONException {
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            FacebookRequestError error = FacebookRequestError.checkResponseAndCreateError(jsonObject, originalResult, connection);
            if (error != null) {
                Log.e((String)TAG, (String)error.toString());
                if (error.getErrorCode() == 190 && Utility.isCurrentAccessToken(request.getAccessToken())) {
                    if (error.getSubErrorCode() != 493) {
                        AccessToken.setCurrentAccessToken(null);
                    } else if (!AccessToken.getCurrentAccessToken().isExpired()) {
                        AccessToken.expireCurrentAccessToken();
                    }
                }
                return new GraphResponse(request, connection, error);
            }
            Object body = Utility.getStringPropertyAsJSON(jsonObject, BODY_KEY, NON_JSON_RESPONSE_PROPERTY);
            if (body instanceof JSONObject) {
                return new GraphResponse(request, connection, body.toString(), (JSONObject)body);
            }
            if (body instanceof JSONArray) {
                return new GraphResponse(request, connection, body.toString(), (JSONArray)body);
            }
            object = JSONObject.NULL;
        }
        if (object == JSONObject.NULL) {
            return new GraphResponse(request, connection, object.toString(), (JSONObject)null);
        }
        throw new FacebookException("Got unexpected object type in response, class: " + object.getClass().getSimpleName());
    }

    static List<GraphResponse> constructErrorResponses(List<GraphRequest> requests, HttpURLConnection connection, FacebookException error) {
        int count = requests.size();
        ArrayList<GraphResponse> responses = new ArrayList<GraphResponse>(count);
        for (int i = 0; i < count; ++i) {
            GraphResponse response = new GraphResponse(requests.get(i), connection, new FacebookRequestError(connection, error));
            responses.add(response);
        }
        return responses;
    }

    public static enum PagingDirection {
        NEXT,
        PREVIOUS;

    }
}

