/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.logging.monitor;

import android.os.Build;
import android.support.annotation.Nullable;
import com.facebook.FacebookSdk;
import com.facebook.internal.logging.ExternalLog;
import com.facebook.internal.logging.monitor.MonitorEvent;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitorLog
implements ExternalLog {
    private MonitorEvent event;
    private long timeStart;
    private int timeSpent;
    private String sampleAppInformation;
    private String deviceOSVersion = Build.VERSION.RELEASE;
    private String deviceModel = Build.MODEL;
    private int hashCode;
    private static final int INVALID_TIME = -1;
    private static final String SAMPLE_APP_FBLOGINSAMPLE = "com.facebook.fbloginsample";
    private static final String SAMPLE_APP_HELLOFACEBOOK = "com.example.hellofacebook";
    private static final String SAMPLE_APP_MESSENGERSENDSAMPLE = "com.facebook.samples.messenger.send";
    private static final String SAMPLE_APP_RPSSAMPLE = "com.example.rps";
    private static final String SAMPLE_APP_SHAREIT = "com.example.shareit";
    private static final String SAMPLE_APP_SWITCHUSERSAMPLE = "com.example.switchuser";
    private static Set<String> sampleAppSet = new HashSet<String>();

    public MonitorLog(LogBuilder logBuilder) {
        this.event = logBuilder.event;
        this.timeStart = logBuilder.timeStart;
        this.timeSpent = logBuilder.timeSpent;
        String packageName = FacebookSdk.getApplicationContext().getPackageName();
        if (packageName != null && MonitorLog.isSampleApp(packageName)) {
            this.sampleAppInformation = packageName;
        }
    }

    public String getDeviceOSVersion() {
        return this.deviceOSVersion;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public MonitorEvent getEvent() {
        return this.event;
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public int getTimeSpent() {
        return this.timeSpent;
    }

    public String getSampleAppInformation() {
        return this.sampleAppInformation;
    }

    private static boolean isSampleApp(String packageName) {
        return sampleAppSet.contains(packageName);
    }

    public String toString() {
        String format = ": %s";
        return String.format("device_os_version" + format + ", " + "device_model" + format + ", " + "event_name" + format + ", " + "sample_app_info" + format + ", " + "time_start" + format + ", " + "time_spent" + format, new Object[]{this.deviceOSVersion, this.deviceModel, this.event, this.sampleAppInformation, this.timeStart, this.timeSpent});
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (this.deviceOSVersion != null ? this.deviceOSVersion.hashCode() : 0);
            result = 31 * result + (this.deviceModel != null ? this.deviceModel.hashCode() : 0);
            result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
            result = 31 * result + (this.sampleAppInformation != null ? this.sampleAppInformation.hashCode() : 0);
            result = 31 * result + (int)(this.timeStart ^ this.timeStart >>> 32);
            this.hashCode = result = 31 * result + (this.timeSpent ^ this.timeSpent >>> 32);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MonitorLog other = (MonitorLog)obj;
        return this.deviceOSVersion.equals(other.deviceOSVersion) && this.deviceModel.equals(other.deviceModel) && this.event == other.event && this.timeStart == other.timeStart && this.timeSpent == other.timeSpent && (this.sampleAppInformation == null && other.sampleAppInformation == null || this.sampleAppInformation.equals(other.sampleAppInformation));
    }

    @Override
    public JSONObject convertToJSONObject() {
        JSONObject object = new JSONObject();
        try {
            object.put("device_os_version", (Object)this.deviceOSVersion);
            object.put("device_model", (Object)this.deviceModel);
            object.put("event_name", (Object)this.event.getName());
            if (this.timeStart != 0L) {
                object.put("time_start", this.timeStart);
            }
            if (this.timeSpent != 0) {
                object.put("time_spent", this.timeSpent);
            }
            if (this.sampleAppInformation != null) {
                object.put("sample_app_info", (Object)this.sampleAppInformation);
            }
            return object;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    static {
        sampleAppSet.add(SAMPLE_APP_FBLOGINSAMPLE);
        sampleAppSet.add(SAMPLE_APP_HELLOFACEBOOK);
        sampleAppSet.add(SAMPLE_APP_MESSENGERSENDSAMPLE);
        sampleAppSet.add(SAMPLE_APP_RPSSAMPLE);
        sampleAppSet.add(SAMPLE_APP_SHAREIT);
        sampleAppSet.add(SAMPLE_APP_SWITCHUSERSAMPLE);
    }

    public static class LogBuilder {
        private MonitorEvent event;
        private Long timeStart;
        private Integer timeSpent;

        public LogBuilder(MonitorEvent event) {
            this.event = event;
        }

        public LogBuilder timeStart(long timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public LogBuilder timeSpent(int timeSpent) {
            this.timeSpent = timeSpent;
            return this;
        }

        public MonitorLog build() {
            MonitorLog monitorLog = new MonitorLog(this);
            this.validateMonitorLog(monitorLog);
            return monitorLog;
        }

        private void validateMonitorLog(MonitorLog monitorLog) {
            if (this.timeSpent < 0) {
                monitorLog.timeSpent = -1;
            }
            if (this.timeStart < 0L) {
                monitorLog.timeStart = -1L;
            }
        }
    }
}

