/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.security;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CertificateUtil {
    private static final String DELIMITER = ":";

    private CertificateUtil() {
    }

    public static String getCertificateHash(Context ctx) {
        try {
            Signature[] signatures = ctx.getPackageManager().getPackageInfo((String)ctx.getPackageName(), (int)64).signatures;
            StringBuilder sb = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance("SHA1");
            for (Signature signature : signatures) {
                md.update(signature.toByteArray());
                sb.append(Base64.encodeToString((byte[])md.digest(), (int)0));
                sb.append(DELIMITER);
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return "";
    }
}

