/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.errorreport;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.facebook.internal.instrument.InstrumentUtility;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ErrorReportData {
    private static final String PRARAM_ERROR_MESSAGE = "error_message";
    private static final String PARAM_TIMESTAMP = "timestamp";
    private String filename;
    @Nullable
    private String errorMessage;
    @Nullable
    private Long timestamp;

    public ErrorReportData(String message) {
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.errorMessage = message;
        this.filename = new StringBuffer().append("error_log_").append(this.timestamp).append(".json").toString();
    }

    public ErrorReportData(File file) {
        this.filename = file.getName();
        JSONObject object = InstrumentUtility.readFile(this.filename, true);
        if (object != null) {
            this.timestamp = object.optLong(PARAM_TIMESTAMP, 0L);
            this.errorMessage = object.optString(PRARAM_ERROR_MESSAGE, null);
        }
    }

    public int compareTo(ErrorReportData data) {
        if (this.timestamp == null) {
            return -1;
        }
        if (data.timestamp == null) {
            return 1;
        }
        return data.timestamp.compareTo(this.timestamp);
    }

    public boolean isValid() {
        return this.errorMessage != null && this.timestamp != null;
    }

    public void save() {
        if (this.isValid()) {
            InstrumentUtility.writeFile(this.filename, this.toString());
        }
    }

    public void clear() {
        InstrumentUtility.deleteFile(this.filename);
    }

    @Nullable
    public String toString() {
        JSONObject params = this.getParameters();
        if (params == null) {
            return null;
        }
        return params.toString();
    }

    @Nullable
    public JSONObject getParameters() {
        JSONObject object = new JSONObject();
        try {
            if (this.timestamp != null) {
                object.put(PARAM_TIMESTAMP, (Object)this.timestamp);
            }
            object.put(PRARAM_ERROR_MESSAGE, (Object)this.errorMessage);
            return object;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }
}

