/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashshield;

import com.facebook.FacebookSdk;
import com.facebook.internal.instrument.ExceptionAnalyzer;
import com.facebook.internal.instrument.InstrumentData;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class CrashShieldHandler {
    private static final Set<Object> sCrashingObjects = Collections.newSetFromMap(new WeakHashMap());
    private static boolean enabled = false;

    public static void enable() {
        enabled = true;
    }

    public static void handleThrowable(Throwable e, Object o) {
        if (!enabled) {
            return;
        }
        sCrashingObjects.add(o);
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            ExceptionAnalyzer.execute(e);
            InstrumentData.Builder.build(e, InstrumentData.Type.CrashShield).save();
        }
    }

    public static boolean isObjectCrashing(Object o) {
        return sCrashingObjects.contains(o);
    }

    public static void methodFinished(Object o) {
    }

    public static void reset() {
        CrashShieldHandler.resetCrashingObjects();
    }

    public static void resetCrashingObjects() {
        sCrashingObjects.clear();
    }
}

