/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.facebook.FacebookSdk;

public class InstallReferrerUtil {
    private static final String IS_REFERRER_UPDATED = "is_referrer_updated";

    private InstallReferrerUtil() {
    }

    public static void tryUpdateReferrerInfo(Callback callback) {
        if (!InstallReferrerUtil.isUpdated()) {
            InstallReferrerUtil.tryConnectReferrerInfo(callback);
        }
    }

    private static void tryConnectReferrerInfo(final Callback callback) {
        final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)FacebookSdk.getApplicationContext()).build();
        InstallReferrerStateListener installReferrerStateListener = new InstallReferrerStateListener(){

            public void onInstallReferrerSetupFinished(int responseCode) {
                switch (responseCode) {
                    case 0: {
                        ReferrerDetails response;
                        try {
                            response = referrerClient.getInstallReferrer();
                        }
                        catch (RemoteException e) {
                            return;
                        }
                        String referrerUrl = response.getInstallReferrer();
                        if (referrerUrl != null && (referrerUrl.contains("fb") || referrerUrl.contains("facebook"))) {
                            callback.onReceiveReferrerUrl(referrerUrl);
                        }
                        InstallReferrerUtil.updateReferrer();
                        break;
                    }
                    case 2: {
                        InstallReferrerUtil.updateReferrer();
                        break;
                    }
                }
            }

            public void onInstallReferrerServiceDisconnected() {
            }
        };
        try {
            referrerClient.startConnection(installReferrerStateListener);
        }
        catch (Exception e) {
            return;
        }
    }

    private static void updateReferrer() {
        SharedPreferences preferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
        preferences.edit().putBoolean(IS_REFERRER_UPDATED, true).apply();
    }

    private static boolean isUpdated() {
        SharedPreferences preferences = FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
        return preferences.getBoolean(IS_REFERRER_UPDATED, false);
    }

    public static interface Callback {
        public void onReceiveReferrerUrl(String var1);
    }
}

