/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.view.View;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.suggestedevents.FeatureExtractor;
import com.facebook.appevents.suggestedevents.PredictionHistoryManager;
import com.facebook.appevents.suggestedevents.SuggestedEventViewHierarchy;
import com.facebook.appevents.suggestedevents.SuggestedEventsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ViewOnClickListener
implements View.OnClickListener {
    private static final String TAG = ViewOnClickListener.class.getCanonicalName();
    private static final String API_ENDPOINT = "%s/suggested_events";
    public static final String OTHER_EVENT = "other";
    @Nullable
    private View.OnClickListener baseListener;
    private static final Set<Integer> viewsAttachedListener = new HashSet<Integer>();
    private WeakReference<View> rootViewWeakReference;
    private WeakReference<View> hostViewWeakReference;
    private String activityName;

    static void attachListener(View hostView, View rootView, String activityName) {
        int key = hostView.hashCode();
        if (!viewsAttachedListener.contains(key)) {
            ViewHierarchy.setOnClickListener(hostView, new ViewOnClickListener(hostView, rootView, activityName));
            viewsAttachedListener.add(key);
        }
    }

    private ViewOnClickListener(View hostView, View rootView, String activityName) {
        this.baseListener = ViewHierarchy.getExistingOnClickListener(hostView);
        this.hostViewWeakReference = new WeakReference<View>(hostView);
        this.rootViewWeakReference = new WeakReference<View>(rootView);
        this.activityName = activityName.toLowerCase().replace("activity", "");
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(View view) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return;
        }
        try {
            if (this.baseListener != null) {
                void view2;
                this.baseListener.onClick((View)view2);
            }
            this.process();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return;
        }
    }

    private void process() {
        View rootView = (View)this.rootViewWeakReference.get();
        View hostView = (View)this.hostViewWeakReference.get();
        if (rootView == null || hostView == null) {
            return;
        }
        try {
            String pathID = PredictionHistoryManager.getPathID(hostView);
            if (pathID == null) {
                return;
            }
            String buttonText = ViewHierarchy.getTextOfView(hostView);
            if (ViewOnClickListener.queryHistoryAndProcess(pathID, buttonText)) {
                return;
            }
            JSONObject data = new JSONObject();
            data.put("view", (Object)SuggestedEventViewHierarchy.getDictionaryOfView(rootView, hostView));
            data.put("screenname", (Object)this.activityName);
            this.predictAndProcess(pathID, buttonText, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean queryHistoryAndProcess(String pathID, final String buttonText) {
        final String queriedEvent = PredictionHistoryManager.queryEvent(pathID);
        if (queriedEvent == null) {
            return false;
        }
        if (!queriedEvent.equals(OTHER_EVENT)) {
            Utility.runOnNonUiThread(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        ViewOnClickListener.processPredictedResult(queriedEvent, buttonText, new float[0]);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
        return true;
    }

    private void predictAndProcess(final String pathID, final String buttonText, final JSONObject viewData) {
        Utility.runOnNonUiThread(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    try {
                        String appName = Utility.getAppName(FacebookSdk.getApplicationContext()).toLowerCase();
                        float[] dense = FeatureExtractor.getDenseFeatures(viewData, appName);
                        String textFeature = FeatureExtractor.getTextFeature(buttonText, ViewOnClickListener.this.activityName, appName);
                        if (dense == null) {
                            return;
                        }
                        String predictedEvent = ModelManager.predict(ModelManager.Task.APP_EVENT_PREDICTION, dense, textFeature);
                        if (predictedEvent == null) {
                            return;
                        }
                        PredictionHistoryManager.addPrediction(pathID, predictedEvent);
                        if (!predictedEvent.equals(ViewOnClickListener.OTHER_EVENT)) {
                            ViewOnClickListener.processPredictedResult(predictedEvent, buttonText, dense);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        });
    }

    private static void processPredictedResult(String predictedEvent, String buttonText, float[] dense) {
        if (SuggestedEventsManager.isProductionEvents(predictedEvent)) {
            InternalAppEventsLogger logger = new InternalAppEventsLogger(FacebookSdk.getApplicationContext());
            logger.logEventFromSE(predictedEvent, buttonText);
        } else if (SuggestedEventsManager.isEligibleEvents(predictedEvent)) {
            ViewOnClickListener.sendPredictedResult(predictedEvent, buttonText, dense);
        }
    }

    private static void sendPredictedResult(String eventToPost, String buttonText, float[] dense) {
        Bundle publishParams = new Bundle();
        try {
            publishParams.putString("event_name", eventToPost);
            JSONObject metadata = new JSONObject();
            StringBuilder denseSB = new StringBuilder();
            for (float f : dense) {
                denseSB.append(f).append(",");
            }
            metadata.put("dense", (Object)denseSB.toString());
            metadata.put("button_text", (Object)buttonText);
            publishParams.putString("metadata", metadata.toString());
            GraphRequest postRequest = GraphRequest.newPostRequest(null, String.format(Locale.US, API_ENDPOINT, FacebookSdk.getApplicationId()), null, null);
            postRequest.setParameters(publishParams);
            postRequest.executeAndWait();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

