/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.app.Activity;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.suggestedevents.FeatureExtractor;
import com.facebook.appevents.suggestedevents.ViewObserver;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SuggestedEventsManager {
    private static final AtomicBoolean enabled = new AtomicBoolean(false);
    private static final Set<String> productionEvents = new HashSet<String>();
    private static final Set<String> eligibleEvents = new HashSet<String>();
    private static final String PRODUCTION_EVENTS_KEY = "production_events";
    private static final String ELIGIBLE_EVENTS_KEY = "eligible_for_prediction_events";

    public static synchronized void enable() {
        if (enabled.get()) {
            return;
        }
        enabled.set(true);
        SuggestedEventsManager.initialize();
    }

    private static void initialize() {
        try {
            int i;
            JSONArray jsonArray;
            FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
            if (settings == null) {
                return;
            }
            String rawSuggestedEventSetting = settings.getSuggestedEventsSetting();
            if (rawSuggestedEventSetting == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject(rawSuggestedEventSetting);
            if (jsonObject.has(PRODUCTION_EVENTS_KEY)) {
                jsonArray = jsonObject.getJSONArray(PRODUCTION_EVENTS_KEY);
                for (i = 0; i < jsonArray.length(); ++i) {
                    productionEvents.add(jsonArray.getString(i));
                }
            }
            if (jsonObject.has(ELIGIBLE_EVENTS_KEY)) {
                jsonArray = jsonObject.getJSONArray(ELIGIBLE_EVENTS_KEY);
                for (i = 0; i < jsonArray.length(); ++i) {
                    eligibleEvents.add(jsonArray.getString(i));
                }
            }
            if (!productionEvents.isEmpty() || !eligibleEvents.isEmpty()) {
                File ruleFile = ModelManager.getRuleFile(ModelManager.Task.APP_EVENT_PREDICTION);
                if (ruleFile == null) {
                    return;
                }
                FeatureExtractor.initialize(ruleFile);
                Activity currActivity = ActivityLifecycleTracker.getCurrentActivity();
                if (currActivity != null) {
                    SuggestedEventsManager.trackActivity(currActivity);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void trackActivity(Activity activity) {
        try {
            if (enabled.get() && FeatureExtractor.isInitialized() && (!productionEvents.isEmpty() || !eligibleEvents.isEmpty())) {
                ViewObserver.startTrackingActivity(activity);
            } else {
                ViewObserver.stopTrackingActivity(activity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isEnabled() {
        return enabled.get();
    }

    static boolean isProductionEvents(String event) {
        return productionEvents.contains(event);
    }

    static boolean isEligibleEvents(String event) {
        return eligibleEvents.contains(event);
    }
}

