/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import com.facebook.internal.instrument.crashshield.CrashShieldHandler;

final class Operator {
    Operator() {
    }

    /*
     * WARNING - void declaration
     */
    static float[] add(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            float[] a;
            void n4;
            void m;
            for (int i = 0; i < m * n4; ++i) {
                int p;
                for (int j = 0; j < p; ++j) {
                    void b;
                    int n5 = i * p + j;
                    a[n5] = a[n5] + b[j];
                }
            }
            return a;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static float[] mul(float[] fArray, float[] fArray2, int n, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int p;
            int m;
            float[] res = new float[m * p];
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < p; ++j) {
                    int n4;
                    res[i * p + j] = 0.0f;
                    for (int k = 0; k < n4; ++k) {
                        void b;
                        float[] a;
                        int n5 = i * p + j;
                        res[n5] = res[n5] + a[i * n4 + k] * b[k * p + j];
                    }
                }
            }
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static void relu(float[] fArray, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            int len;
            for (int i = 0; i < len; ++i) {
                float[] data;
                if (!(data[i] < 0.0f)) continue;
                data[i] = 0.0f;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static float[] concatenate(float[] fArray, float[] fArray2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            void b;
            float[] a;
            float[] res = new float[a.length + ((void)b).length];
            System.arraycopy(a, 0, res, 0, a.length);
            System.arraycopy(b, 0, res, a.length, ((void)b).length);
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static void softmax(float[] fArray, int n) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return;
        }
        try {
            float[] data;
            int n2;
            int i;
            boolean j = false;
            float max = Float.MIN_VALUE;
            float sum = 0.0f;
            for (i = 0; i < n2; ++i) {
                if (!(data[i] > max)) continue;
                max = data[i];
            }
            for (i = 0; i < n2; ++i) {
                data[i] = (float)Math.exp(data[i] - max);
            }
            for (i = 0; i < n2; ++i) {
                sum += data[i];
            }
            for (i = 0; i < n2; ++i) {
                data[i] = data[i] / sum;
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static float[] dense(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int out_vector_size;
            void in_vector_size;
            int n_examples;
            void b;
            float[] a;
            float[] m_res = Operator.mul(a, (float[])b, n_examples, (int)in_vector_size, out_vector_size);
            for (int i = 0; i < n_examples; ++i) {
                for (int j = 0; j < out_vector_size; ++j) {
                    void c;
                    int n4 = i * out_vector_size + j;
                    m_res[n4] = m_res[n4] + c[j];
                }
            }
            return m_res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static float[] embedding(int[] nArray, float[] fArray, int n, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int embedding_size;
            int seq_length;
            int n_examples;
            float[] res = new float[n_examples * seq_length * embedding_size];
            for (int i = 0; i < n_examples; ++i) {
                for (int j = 0; j < seq_length; ++j) {
                    int[] a;
                    int val = a[i * seq_length + j];
                    for (int k = 0; k < embedding_size; ++k) {
                        void b;
                        res[embedding_size * seq_length * i + embedding_size * j + k] = b[val * embedding_size + k];
                    }
                }
            }
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static float[] transpose2D(float[] fArray, int n, int n2) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int n3;
            int m;
            float[] transposed = new float[m * n3];
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n3; ++j) {
                    float[] input;
                    transposed[j * m + i] = input[i * n3 + j];
                }
            }
            return transposed;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    static float[] transpose3D(float[] fArray, int n, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int p;
            int n4;
            int m;
            float[] transposed = new float[m * n4 * p];
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < p; ++k) {
                        float[] input;
                        transposed[k * m * n4 + j * m + i] = input[i * n4 * p + j * p + k];
                    }
                }
            }
            return transposed;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static float[] conv1D(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4, int n5) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int output_size;
            int kernel_size;
            void seq_len;
            int n_examples;
            float[] res = new float[n_examples * (seq_len - kernel_size + true) * output_size];
            for (int n6 = 0; n6 < n_examples; ++n6) {
                for (int o = 0; o < output_size; ++o) {
                    for (int i = 0; i < seq_len - kernel_size + true; ++i) {
                        float sum = 0.0f;
                        for (int m = 0; m < kernel_size; ++m) {
                            int input_size;
                            for (int k = 0; k < input_size; ++k) {
                                void w;
                                float[] x;
                                sum += x[n6 * (seq_len * input_size) + (m + i) * input_size + k] * w[(m * input_size + k) * output_size + o];
                            }
                        }
                        res[n6 * (output_size * (seq_len - kernel_size + true)) + i * output_size + o] = sum;
                    }
                }
            }
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static float[] maxPool1D(float[] fArray, int n, int n2, int n3) {
        if (CrashShieldHandler.isObjectCrashing(Operator.class)) {
            return null;
        }
        try {
            int cols;
            void pool_size;
            void rows;
            int len = rows - pool_size + true;
            float[] res = new float[len * cols];
            for (int c = 0; c < cols; ++c) {
                for (int i = 0; i < len; ++i) {
                    for (int r = i; r < i + pool_size; ++r) {
                        float[] x;
                        res[i * cols + c] = Math.max(res[i * cols + c], x[r * cols + c]);
                    }
                }
            }
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Operator.class);
            return null;
        }
    }
}

