/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.appevents.internal.FileDownloadTask;
import com.facebook.appevents.ml.Model;
import com.facebook.appevents.ml.Utils;
import com.facebook.appevents.restrictivedatafilter.AddressFilterManager;
import com.facebook.appevents.suggestedevents.SuggestedEventsManager;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ModelManager {
    private static final Map<String, TaskHandler> mTaskHandlers = new ConcurrentHashMap<String, TaskHandler>();
    public static final String SHOULD_FILTER = "SHOULD_FILTER";
    private static final String SDK_MODEL_ASSET = "%s/model_asset";
    private static SharedPreferences shardPreferences;
    private static final String MODEL_ASSERT_STORE = "com.facebook.internal.MODEL_STORE";
    private static final String CACHE_KEY_MODELS = "models";
    private static final String MTML_USE_CASE = "MTML";
    private static final String USE_CASE_KEY = "use_case";
    private static final String VERSION_ID_KEY = "version_id";
    private static final String ASSET_URI_KEY = "asset_uri";
    private static final String RULES_URI_KEY = "rules_uri";
    private static final String THRESHOLD_KEY = "thresholds";
    private static final List<String> SUGGESTED_EVENTS_PREDICTION;

    public static void enable() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            shardPreferences = FacebookSdk.getApplicationContext().getSharedPreferences(MODEL_ASSERT_STORE, 0);
            Utility.runOnNonUiThread(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        try {
                            JSONObject models = ModelManager.access$000();
                            if (models != null) {
                                ModelManager.access$100().edit().putString(ModelManager.CACHE_KEY_MODELS, models.toString()).apply();
                            } else {
                                models = new JSONObject(ModelManager.access$100().getString(ModelManager.CACHE_KEY_MODELS, ""));
                            }
                            ModelManager.access$200(models);
                            if (FeatureManager.isEnabled(FeatureManager.Feature.MTML)) {
                                ModelManager.access$300();
                            } else {
                                ModelManager.access$400();
                                ModelManager.access$500();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    private static void addModels(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            JSONObject models;
            Iterator keys = models.keys();
            try {
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    TaskHandler handler = TaskHandler.build(models.getJSONObject(key));
                    if (handler == null) continue;
                    mTaskHandlers.put(handler.useCase, handler);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    private static JSONObject parseRawJsonObject(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            JSONObject resultJsonObject = new JSONObject();
            try {
                JSONObject jsonObject;
                JSONArray jsonArray = jsonObject.getJSONArray("data");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject curJsonObject = jsonArray.getJSONObject(i);
                    JSONObject tempJsonObject = new JSONObject();
                    tempJsonObject.put(VERSION_ID_KEY, (Object)curJsonObject.getString(VERSION_ID_KEY));
                    tempJsonObject.put(USE_CASE_KEY, (Object)curJsonObject.getString(USE_CASE_KEY));
                    tempJsonObject.put(THRESHOLD_KEY, (Object)curJsonObject.getJSONArray(THRESHOLD_KEY));
                    tempJsonObject.put(ASSET_URI_KEY, (Object)curJsonObject.getString(ASSET_URI_KEY));
                    if (curJsonObject.has(RULES_URI_KEY)) {
                        tempJsonObject.put(RULES_URI_KEY, (Object)curJsonObject.getString(RULES_URI_KEY));
                    }
                    resultJsonObject.put(curJsonObject.getString(USE_CASE_KEY), (Object)tempJsonObject);
                }
                return resultJsonObject;
            }
            catch (JSONException je) {
                return new JSONObject();
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    @Nullable
    private static JSONObject fetchModels() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            Object[] appSettingFields = new String[]{USE_CASE_KEY, VERSION_ID_KEY, ASSET_URI_KEY, RULES_URI_KEY, THRESHOLD_KEY};
            Bundle appSettingsParams = new Bundle();
            appSettingsParams.putString("fields", TextUtils.join((CharSequence)",", (Object[])appSettingFields));
            GraphRequest graphRequest = GraphRequest.newGraphPathRequest(null, String.format(SDK_MODEL_ASSET, FacebookSdk.getApplicationId()), null);
            graphRequest.setSkipClientToken(true);
            graphRequest.setParameters(appSettingsParams);
            JSONObject rawResponse = graphRequest.executeAndWait().getJSONObject();
            if (rawResponse == null) {
                return null;
            }
            return ModelManager.parseRawJsonObject(rawResponse);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    private static void enableMTML() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            mTaskHandlers.remove(Task.APP_EVENT_PREDICTION.toUseCase());
            mTaskHandlers.remove(Task.ADDRESS_DETECTION.toUseCase());
            ArrayList<TaskHandler> slaveTasks = new ArrayList<TaskHandler>();
            String mtmlAssetUri = null;
            int mtmlVersionId = 0;
            for (Map.Entry<String, TaskHandler> entry : mTaskHandlers.entrySet()) {
                TaskHandler handler;
                String useCase = entry.getKey();
                if (useCase.equals(Task.MTML_APP_EVENT_PREDICTION.toUseCase())) {
                    handler = entry.getValue();
                    mtmlAssetUri = handler.assetUri;
                    mtmlVersionId = handler.versionId;
                    if (FeatureManager.isEnabled(FeatureManager.Feature.SuggestedEvents) && ModelManager.isLocaleEnglish()) {
                        slaveTasks.add(handler.setOnPostExecute(new Runnable(){

                            @Override
                            public void run() {
                                if (CrashShieldHandler.isObjectCrashing(this)) {
                                    return;
                                }
                                try {
                                    SuggestedEventsManager.enable();
                                    return;
                                }
                                catch (Throwable throwable) {
                                    CrashShieldHandler.handleThrowable(throwable, this);
                                    return;
                                }
                            }
                        }));
                    }
                }
                if (!useCase.equals(Task.MTML_ADDRESS_DETECTION.toUseCase())) continue;
                handler = entry.getValue();
                mtmlAssetUri = handler.assetUri;
                mtmlVersionId = handler.versionId;
                if (!FeatureManager.isEnabled(FeatureManager.Feature.PIIFiltering)) continue;
                slaveTasks.add(handler.setOnPostExecute(new Runnable(){

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            AddressFilterManager.enable();
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                }));
            }
            if (mtmlAssetUri != null && mtmlVersionId > 0 && !slaveTasks.isEmpty()) {
                TaskHandler mtmlHandler = new TaskHandler(MTML_USE_CASE, mtmlAssetUri, null, mtmlVersionId, null);
                TaskHandler.execute(mtmlHandler, slaveTasks);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    private static void enableSuggestedEvents() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            mTaskHandlers.remove(Task.MTML_APP_EVENT_PREDICTION.toUseCase());
            TaskHandler handler = mTaskHandlers.get(Task.APP_EVENT_PREDICTION.toUseCase());
            if (handler == null) {
                return;
            }
            Locale locale = Utility.getResourceLocale();
            if (locale != null && !locale.getLanguage().contains("en")) {
                return;
            }
            if (FeatureManager.isEnabled(FeatureManager.Feature.SuggestedEvents)) {
                TaskHandler.execute(handler.setOnPostExecute(new Runnable(){

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            SuggestedEventsManager.enable();
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                }));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    private static void enablePIIFiltering() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            mTaskHandlers.remove(Task.MTML_ADDRESS_DETECTION.toUseCase());
            TaskHandler handler = mTaskHandlers.get(Task.ADDRESS_DETECTION.toUseCase());
            if (handler == null) {
                return;
            }
            if (FeatureManager.isEnabled(FeatureManager.Feature.PIIFiltering)) {
                TaskHandler.execute(handler.setOnPostExecute(new Runnable(){

                    @Override
                    public void run() {
                        if (CrashShieldHandler.isObjectCrashing(this)) {
                            return;
                        }
                        try {
                            AddressFilterManager.enable();
                            return;
                        }
                        catch (Throwable throwable) {
                            CrashShieldHandler.handleThrowable(throwable, this);
                            return;
                        }
                    }
                }));
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    private static boolean isLocaleEnglish() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return false;
        }
        try {
            Locale locale = Utility.getResourceLocale();
            return locale == null || locale.getLanguage().contains("en");
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return false;
        }
    }

    @Nullable
    private static float[] parseJsonArray(@Nullable JSONArray jSONArray) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            JSONArray jsonArray;
            if (jsonArray == null) {
                return null;
            }
            float[] thresholds = new float[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    thresholds[i] = Float.parseFloat(jsonArray.getString(i));
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return thresholds;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    @Nullable
    public static File getRuleFile(Task task) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            Task task2;
            task2 = ModelManager.switchMTML(task2);
            TaskHandler handler = mTaskHandlers.get(task2.toUseCase());
            if (handler == null) {
                return null;
            }
            return handler.ruleFile;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static String predict(Task task, float[] fArray, String string) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            void text;
            void dense;
            Task task2;
            task2 = ModelManager.switchMTML(task2);
            TaskHandler handler = mTaskHandlers.get(task2.toUseCase());
            if (handler == null || handler.model == null) {
                return null;
            }
            float[] res = handler.model.predict((float[])dense, (String)text, task2.toKey());
            float[] thresholds = handler.thresholds;
            if (res == null || res.length == 0 || thresholds == null || thresholds.length == 0) {
                return null;
            }
            switch (task2) {
                case APP_EVENT_PREDICTION: 
                case MTML_APP_EVENT_PREDICTION: {
                    return ModelManager.processSuggestedEventResult(res, thresholds);
                }
                case ADDRESS_DETECTION: 
                case MTML_ADDRESS_DETECTION: {
                    return ModelManager.processAddressDetectionResult(res, thresholds);
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static String processSuggestedEventResult(float[] fArray, float[] fArray2) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            float[] res;
            void thresholds;
            if (((void)thresholds).length != res.length) {
                return null;
            }
            for (int i = 0; i < ((void)thresholds).length; ++i) {
                if (!(res[i] >= thresholds[i])) continue;
                return SUGGESTED_EVENTS_PREDICTION.get(i);
            }
            return "other";
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static String processAddressDetectionResult(float[] fArray, float[] fArray2) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            void thresholds;
            float[] res;
            return res[1] >= thresholds[0] ? SHOULD_FILTER : null;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    private static Task switchMTML(Task task) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            Task task2;
            if (!mTaskHandlers.containsKey(task2.toUseCase())) {
                switch (task2) {
                    case APP_EVENT_PREDICTION: {
                        task2 = Task.MTML_APP_EVENT_PREDICTION;
                        break;
                    }
                    case ADDRESS_DETECTION: {
                        task2 = Task.MTML_ADDRESS_DETECTION;
                    }
                }
            }
            return task2;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    static /* synthetic */ JSONObject access$000() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            return ModelManager.fetchModels();
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    static /* synthetic */ SharedPreferences access$100() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            return shardPreferences;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    static /* synthetic */ void access$200(JSONObject jSONObject) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            JSONObject x0;
            ModelManager.addModels(x0);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    static /* synthetic */ void access$300() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            ModelManager.enableMTML();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    static /* synthetic */ void access$400() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            ModelManager.enableSuggestedEvents();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    static /* synthetic */ void access$500() {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return;
        }
        try {
            ModelManager.enablePIIFiltering();
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return;
        }
    }

    static /* synthetic */ float[] access$600(JSONArray jSONArray) {
        if (CrashShieldHandler.isObjectCrashing(ModelManager.class)) {
            return null;
        }
        try {
            JSONArray x0;
            return ModelManager.parseJsonArray(x0);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, ModelManager.class);
            return null;
        }
    }

    static {
        SUGGESTED_EVENTS_PREDICTION = Arrays.asList("fb_mobile_add_to_cart", "fb_mobile_complete_registration", "other", "fb_mobile_purchase");
    }

    private static class TaskHandler {
        String useCase;
        String assetUri;
        @Nullable
        String ruleUri;
        int versionId;
        @Nullable
        float[] thresholds;
        File ruleFile;
        @Nullable
        Model model;
        private Runnable onPostExecute;

        TaskHandler(String useCase, String assetUri, @Nullable String ruleUri, int versionId, @Nullable float[] thresholds) {
            this.useCase = useCase;
            this.assetUri = assetUri;
            this.ruleUri = ruleUri;
            this.versionId = versionId;
            this.thresholds = thresholds;
        }

        TaskHandler setOnPostExecute(Runnable onPostExecute) {
            this.onPostExecute = onPostExecute;
            return this;
        }

        @Nullable
        static TaskHandler build(@Nullable JSONObject json) {
            if (json == null) {
                return null;
            }
            try {
                String useCase = json.getString(ModelManager.USE_CASE_KEY);
                String assetUri = json.getString(ModelManager.ASSET_URI_KEY);
                String ruleUri = json.optString(ModelManager.RULES_URI_KEY, null);
                int versionId = json.getInt(ModelManager.VERSION_ID_KEY);
                float[] thresholds = ModelManager.access$600(json.getJSONArray(ModelManager.THRESHOLD_KEY));
                return new TaskHandler(useCase, assetUri, ruleUri, versionId, thresholds);
            }
            catch (Exception e) {
                return null;
            }
        }

        static void execute(TaskHandler handler) {
            TaskHandler.execute(handler, Collections.singletonList(handler));
        }

        static void execute(TaskHandler master, final List<TaskHandler> slaves) {
            TaskHandler.deleteOldFiles(master.useCase, master.versionId);
            String modelFileName = master.useCase + "_" + master.versionId;
            TaskHandler.download(master.assetUri, modelFileName, new FileDownloadTask.Callback(){

                @Override
                public void onComplete(File file) {
                    final Model model = Model.build(file);
                    if (model != null) {
                        for (final TaskHandler slave : slaves) {
                            String ruleFileName = slave.useCase + "_" + slave.versionId + "_rule";
                            TaskHandler.download(slave.ruleUri, ruleFileName, new FileDownloadTask.Callback(){

                                @Override
                                public void onComplete(File file) {
                                    slave.model = model;
                                    slave.ruleFile = file;
                                    if (slave.onPostExecute != null) {
                                        slave.onPostExecute.run();
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }

        private static void deleteOldFiles(String useCase, int versionId) {
            File dir = Utils.getMlDir();
            if (dir == null) {
                return;
            }
            File[] existingFiles = dir.listFiles();
            if (existingFiles == null || existingFiles.length == 0) {
                return;
            }
            String prefixWithVersion = useCase + "_" + versionId;
            for (File f : existingFiles) {
                String name = f.getName();
                if (!name.startsWith(useCase) || name.startsWith(prefixWithVersion)) continue;
                f.delete();
            }
        }

        private static void download(String uri, String name, FileDownloadTask.Callback onComplete) {
            File file = new File(Utils.getMlDir(), name);
            if (uri == null || file.exists()) {
                onComplete.onComplete(file);
                return;
            }
            new FileDownloadTask(uri, file, onComplete).execute(new String[0]);
        }
    }

    public static enum Task {
        ADDRESS_DETECTION,
        APP_EVENT_PREDICTION,
        MTML_ADDRESS_DETECTION,
        MTML_APP_EVENT_PREDICTION;


        public String toKey() {
            switch (this) {
                case ADDRESS_DETECTION: 
                case APP_EVENT_PREDICTION: {
                    return "fc3";
                }
                case MTML_ADDRESS_DETECTION: {
                    return "address_detect";
                }
                case MTML_APP_EVENT_PREDICTION: {
                    return "app_event_pred";
                }
            }
            return "Unknown";
        }

        @Nullable
        public String toUseCase() {
            switch (this) {
                case ADDRESS_DETECTION: {
                    return "DATA_DETECTION_ADDRESS";
                }
                case APP_EVENT_PREDICTION: {
                    return "SUGGEST_EVENT";
                }
                case MTML_ADDRESS_DETECTION: {
                    return "MTML_ADDRESS_DETECT";
                }
                case MTML_APP_EVENT_PREDICTION: {
                    return "MTML_APP_EVENT_PRED";
                }
            }
            return null;
        }
    }
}

