/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.appevents.ml.Operator;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Model {
    private Weight embedding;
    private Weight convs_1_weight;
    private Weight convs_2_weight;
    private Weight convs_3_weight;
    private Weight convs_1_bias;
    private Weight convs_2_bias;
    private Weight convs_3_bias;
    private Weight fc1_weight;
    private Weight fc2_weight;
    private Weight fc1_bias;
    private Weight fc2_bias;
    private final Map<String, Weight> final_weights = new HashMap<String, Weight>();
    private static final int SEQ_LEN = 128;
    private static final int EMBEDDING_SIZE = 64;

    private Model(Map<String, Weight> weights) {
        this.embedding = weights.get("embed.weight");
        this.convs_1_weight = weights.get("convs.0.weight");
        this.convs_2_weight = weights.get("convs.1.weight");
        this.convs_3_weight = weights.get("convs.2.weight");
        this.convs_1_weight.data = Operator.transpose3D(this.convs_1_weight.data, this.convs_1_weight.shape[0], this.convs_1_weight.shape[1], this.convs_1_weight.shape[2]);
        this.convs_2_weight.data = Operator.transpose3D(this.convs_2_weight.data, this.convs_2_weight.shape[0], this.convs_2_weight.shape[1], this.convs_2_weight.shape[2]);
        this.convs_3_weight.data = Operator.transpose3D(this.convs_3_weight.data, this.convs_3_weight.shape[0], this.convs_3_weight.shape[1], this.convs_3_weight.shape[2]);
        this.convs_1_bias = weights.get("convs.0.bias");
        this.convs_2_bias = weights.get("convs.1.bias");
        this.convs_3_bias = weights.get("convs.2.bias");
        this.fc1_weight = weights.get("fc1.weight");
        this.fc2_weight = weights.get("fc2.weight");
        this.fc1_weight.data = Operator.transpose2D(this.fc1_weight.data, this.fc1_weight.shape[0], this.fc1_weight.shape[1]);
        this.fc2_weight.data = Operator.transpose2D(this.fc2_weight.data, this.fc2_weight.shape[0], this.fc2_weight.shape[1]);
        this.fc1_bias = weights.get("fc1.bias");
        this.fc2_bias = weights.get("fc2.bias");
        HashSet<String> tasks = new HashSet<String>(){
            {
                this.add(ModelManager.Task.ADDRESS_DETECTION.toKey());
                this.add(ModelManager.Task.APP_EVENT_PREDICTION.toKey());
                this.add(ModelManager.Task.MTML_ADDRESS_DETECTION.toKey());
                this.add(ModelManager.Task.MTML_APP_EVENT_PREDICTION.toKey());
            }
        };
        for (String task : tasks) {
            String weightKey = task + ".weight";
            String biasKey = task + ".bias";
            Weight weight = weights.get(weightKey);
            Weight bias = weights.get(biasKey);
            if (weight != null) {
                weight.data = Operator.transpose2D(weight.data, weight.shape[0], weight.shape[1]);
                this.final_weights.put(weightKey, weight);
            }
            if (bias == null) continue;
            this.final_weights.put(biasKey, bias);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public float[] predict(float[] fArray, String string, String string2) {
        if (CrashShieldHandler.isObjectCrashing(this)) {
            return null;
        }
        try {
            void task;
            void dense;
            void text;
            int[] x = Utils.vectorize((String)text, 128);
            float[] embed_x = Operator.embedding(x, this.embedding.data, 1, 128, 64);
            float[] c1 = Operator.conv1D(embed_x, this.convs_1_weight.data, 1, 128, 64, this.convs_1_weight.shape[2], this.convs_1_weight.shape[0]);
            float[] c2 = Operator.conv1D(embed_x, this.convs_2_weight.data, 1, 128, 64, this.convs_2_weight.shape[2], this.convs_2_weight.shape[0]);
            float[] c3 = Operator.conv1D(embed_x, this.convs_3_weight.data, 1, 128, 64, this.convs_3_weight.shape[2], this.convs_3_weight.shape[0]);
            Operator.add(c1, this.convs_1_bias.data, 1, 128 - this.convs_1_weight.shape[2] + 1, this.convs_1_weight.shape[0]);
            Operator.add(c2, this.convs_2_bias.data, 1, 128 - this.convs_2_weight.shape[2] + 1, this.convs_2_weight.shape[0]);
            Operator.add(c3, this.convs_3_bias.data, 1, 128 - this.convs_3_weight.shape[2] + 1, this.convs_3_weight.shape[0]);
            Operator.relu(c1, (128 - this.convs_1_weight.shape[2] + 1) * this.convs_1_weight.shape[0]);
            Operator.relu(c2, (128 - this.convs_2_weight.shape[2] + 1) * this.convs_2_weight.shape[0]);
            Operator.relu(c3, (128 - this.convs_3_weight.shape[2] + 1) * this.convs_3_weight.shape[0]);
            float[] ca = Operator.maxPool1D(c1, 128 - this.convs_1_weight.shape[2] + 1, this.convs_1_weight.shape[0], 128 - this.convs_1_weight.shape[2] + 1);
            float[] cb = Operator.maxPool1D(c2, 128 - this.convs_2_weight.shape[2] + 1, this.convs_2_weight.shape[0], 128 - this.convs_2_weight.shape[2] + 1);
            float[] cc = Operator.maxPool1D(c3, 128 - this.convs_3_weight.shape[2] + 1, this.convs_3_weight.shape[0], 128 - this.convs_3_weight.shape[2] + 1);
            float[] concat = Operator.concatenate(Operator.concatenate(Operator.concatenate(ca, cb), cc), (float[])dense);
            float[] dense1_x = Operator.dense(concat, this.fc1_weight.data, this.fc1_bias.data, 1, this.fc1_weight.shape[1], this.fc1_weight.shape[0]);
            Operator.relu(dense1_x, this.fc1_bias.shape[0]);
            float[] dense2_x = Operator.dense(dense1_x, this.fc2_weight.data, this.fc2_bias.data, 1, this.fc2_weight.shape[1], this.fc2_weight.shape[0]);
            Operator.relu(dense2_x, this.fc2_bias.shape[0]);
            Weight fc3_weight = this.final_weights.get((String)task + ".weight");
            Weight fc3_bias = this.final_weights.get((String)task + ".bias");
            if (fc3_weight == null || fc3_bias == null) {
                return null;
            }
            float[] res = Operator.dense(dense2_x, fc3_weight.data, fc3_bias.data, 1, fc3_weight.shape[1], fc3_weight.shape[0]);
            Operator.softmax(res, fc3_bias.shape[0]);
            return res;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, this);
            return null;
        }
    }

    @Nullable
    public static Model build(File file) {
        if (CrashShieldHandler.isObjectCrashing(Model.class)) {
            return null;
        }
        try {
            File file2;
            Map<String, Weight> weights = Model.parse(file2);
            try {
                return new Model(weights);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Model.class);
            return null;
        }
    }

    @Nullable
    private static Map<String, Weight> parse(File file) {
        if (CrashShieldHandler.isObjectCrashing(Model.class)) {
            return null;
        }
        try {
            try {
                File file2;
                FileInputStream inputStream = new FileInputStream(file2);
                int length = ((InputStream)inputStream).available();
                DataInputStream dataIs = new DataInputStream(inputStream);
                byte[] allData = new byte[length];
                dataIs.readFully(allData);
                dataIs.close();
                if (length < 4) {
                    return null;
                }
                ByteBuffer bb = ByteBuffer.wrap(allData, 0, 4);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                int jsonLen = bb.getInt();
                if (length < jsonLen + 4) {
                    return null;
                }
                String jsonStr = new String(allData, 4, jsonLen);
                JSONObject info = new JSONObject(jsonStr);
                JSONArray names = info.names();
                Object[] keys = new String[names.length()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = names.getString(i);
                }
                Arrays.sort(keys);
                int offset = 4 + jsonLen;
                HashMap<String, Weight> weights = new HashMap<String, Weight>();
                Map<String, String> mapping = Model.getMapping();
                for (Object key : keys) {
                    int count = 1;
                    JSONArray shapes = info.getJSONArray((String)key);
                    int[] shape = new int[shapes.length()];
                    for (int i = 0; i < shape.length; ++i) {
                        shape[i] = shapes.getInt(i);
                        count *= shape[i];
                    }
                    if (offset + count * 4 > length) {
                        return null;
                    }
                    bb = ByteBuffer.wrap(allData, offset, count * 4);
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    float[] data = new float[count];
                    bb.asFloatBuffer().get(data, 0, count);
                    Object finalKey = key;
                    if (mapping.containsKey(key)) {
                        finalKey = mapping.get(key);
                    }
                    weights.put((String)finalKey, new Weight(shape, data));
                    offset += count * 4;
                }
                return weights;
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Model.class);
            return null;
        }
    }

    private static Map<String, String> getMapping() {
        if (CrashShieldHandler.isObjectCrashing(Model.class)) {
            return null;
        }
        try {
            return new HashMap<String, String>(){
                {
                    this.put("embedding.weight", "embed.weight");
                    this.put("dense1.weight", "fc1.weight");
                    this.put("dense2.weight", "fc2.weight");
                    this.put("dense3.weight", "fc3.weight");
                    this.put("dense1.bias", "fc1.bias");
                    this.put("dense2.bias", "fc2.bias");
                    this.put("dense3.bias", "fc3.bias");
                }
            };
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable(throwable, Model.class);
            return null;
        }
    }

    private static class Weight {
        public int[] shape;
        public float[] data;

        Weight(int[] shape, float[] data) {
            this.shape = shape;
            this.data = data;
        }
    }
}

