/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import org.json.JSONException;
import org.json.JSONObject;

public final class PathComponent {
    private static final String PATH_CLASS_NAME_KEY = "class_name";
    private static final String PATH_INDEX_KEY = "index";
    private static final String PATH_ID_KEY = "id";
    private static final String PATH_TEXT_KEY = "text";
    private static final String PATH_TAG_KEY = "tag";
    private static final String PATH_DESCRIPTION_KEY = "description";
    private static final String PATH_HINT_KEY = "hint";
    private static final String PATH_MATCH_BITMASK_KEY = "match_bitmask";
    public final String className;
    public final int index;
    public final int id;
    public final String text;
    public final String tag;
    public final String description;
    public final String hint;
    public final int matchBitmask;

    PathComponent(JSONObject component) throws JSONException {
        this.className = component.getString(PATH_CLASS_NAME_KEY);
        this.index = component.optInt(PATH_INDEX_KEY, -1);
        this.id = component.optInt(PATH_ID_KEY);
        this.text = component.optString(PATH_TEXT_KEY);
        this.tag = component.optString(PATH_TAG_KEY);
        this.description = component.optString(PATH_DESCRIPTION_KEY);
        this.hint = component.optString(PATH_HINT_KEY);
        this.matchBitmask = component.optInt(PATH_MATCH_BITMASK_KEY);
    }

    public static enum MatchBitmaskType {
        ID(1),
        TEXT(2),
        TAG(4),
        DESCRIPTION(8),
        HINT(16);

        private final int value;

        private MatchBitmaskType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

