/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.eventdeactivation;

import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class EventDeactivationManager {
    private static boolean enabled = false;
    private static final List<DeprecatedParamFilter> deprecatedParamFilters = new ArrayList<DeprecatedParamFilter>();
    private static final Set<String> deprecatedEvents = new HashSet<String>();

    public static void enable() {
        enabled = true;
        EventDeactivationManager.initialize();
    }

    private static synchronized void initialize() {
        try {
            FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
            if (settings == null) {
                return;
            }
            String eventFilterResponse = settings.getRestrictiveDataSetting();
            if (!eventFilterResponse.isEmpty()) {
                JSONObject jsonObject = new JSONObject(eventFilterResponse);
                deprecatedParamFilters.clear();
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject json = jsonObject.getJSONObject(key);
                    if (json == null) continue;
                    if (json.optBoolean("is_deprecated_event")) {
                        deprecatedEvents.add(key);
                        continue;
                    }
                    JSONArray deprecatedParamJsonArray = json.optJSONArray("deprecated_param");
                    DeprecatedParamFilter deprecatedParamFilter = new DeprecatedParamFilter(key, new ArrayList<String>());
                    if (deprecatedParamJsonArray != null) {
                        deprecatedParamFilter.deprecateParams = Utility.convertJSONArrayToList(deprecatedParamJsonArray);
                    }
                    deprecatedParamFilters.add(deprecatedParamFilter);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processEvents(List<AppEvent> events) {
        if (!enabled) {
            return;
        }
        Iterator<AppEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            AppEvent event = iterator.next();
            if (!deprecatedEvents.contains(event.getName())) continue;
            iterator.remove();
        }
    }

    public static void processDeprecatedParameters(Map<String, String> parameters, String eventName) {
        if (!enabled) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        ArrayList<DeprecatedParamFilter> deprecatedParamFiltersCopy = new ArrayList<DeprecatedParamFilter>(deprecatedParamFilters);
        for (DeprecatedParamFilter filter : deprecatedParamFiltersCopy) {
            if (!filter.eventName.equals(eventName)) continue;
            for (String key : keys) {
                if (!filter.deprecateParams.contains(key)) continue;
                parameters.remove(key);
            }
        }
    }

    static class DeprecatedParamFilter {
        String eventName;
        List<String> deprecateParams;

        DeprecatedParamFilter(String eventName, List<String> deprecateParams) {
            this.eventName = eventName;
            this.deprecateParams = deprecateParams;
        }
    }
}

