/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppGateKeepersManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class FeatureManager {
    public static void checkFeature(final Feature feature, final Callback callback) {
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync(new FetchedAppGateKeepersManager.Callback(){

            @Override
            public void onCompleted() {
                callback.onCompleted(FeatureManager.isEnabled(feature));
            }
        });
    }

    public static boolean isEnabled(Feature feature) {
        if (Feature.Unknown == feature) {
            return false;
        }
        if (Feature.Core == feature) {
            return true;
        }
        Feature parent = feature.getParent();
        if (parent == feature) {
            return FeatureManager.getGKStatus(feature);
        }
        return FeatureManager.isEnabled(parent) && FeatureManager.getGKStatus(feature);
    }

    private static boolean getGKStatus(Feature feature) {
        String key = "FBSDKFeature" + feature.toString();
        boolean defaultStatus = FeatureManager.defaultStatus(feature);
        return FetchedAppGateKeepersManager.getGateKeeperForKey(key, FacebookSdk.getApplicationId(), defaultStatus);
    }

    private static boolean defaultStatus(Feature feature) {
        switch (feature) {
            case RestrictiveDataFiltering: 
            case Instrument: 
            case CrashReport: 
            case ErrorReport: 
            case AAM: 
            case PrivacyProtection: 
            case SuggestedEvents: 
            case PIIFiltering: 
            case EventDeactivation: {
                return false;
            }
        }
        return true;
    }

    public static interface Callback {
        public void onCompleted(boolean var1);
    }

    public static enum Feature {
        Unknown(-1),
        Core(0),
        AppEvents(65536),
        CodelessEvents(65792),
        RestrictiveDataFiltering(66048),
        AAM(66304),
        PrivacyProtection(66560),
        SuggestedEvents(66561),
        PIIFiltering(66562),
        EventDeactivation(66816),
        Instrument(131072),
        CrashReport(131328),
        ErrorReport(131584),
        Login(0x1000000),
        Share(0x2000000),
        Places(0x3000000);

        private final int code;

        private Feature(int code) {
            this.code = code;
        }

        public String toString() {
            String name = "unknown";
            switch (this) {
                case Core: {
                    name = "CoreKit";
                    break;
                }
                case AppEvents: {
                    name = "AppEvents";
                    break;
                }
                case CodelessEvents: {
                    name = "CodelessEvents";
                    break;
                }
                case RestrictiveDataFiltering: {
                    name = "RestrictiveDataFiltering";
                    break;
                }
                case Instrument: {
                    name = "Instrument";
                    break;
                }
                case CrashReport: {
                    name = "CrashReport";
                    break;
                }
                case ErrorReport: {
                    name = "ErrorReport";
                    break;
                }
                case AAM: {
                    name = "AAM";
                    break;
                }
                case PrivacyProtection: {
                    name = "PrivacyProtection";
                    break;
                }
                case SuggestedEvents: {
                    name = "SuggestedEvents";
                    break;
                }
                case PIIFiltering: {
                    name = "PIIFiltering";
                    break;
                }
                case EventDeactivation: {
                    name = "EventDeactivation";
                    break;
                }
                case Login: {
                    name = "LoginKit";
                    break;
                }
                case Share: {
                    name = "ShareKit";
                    break;
                }
                case Places: {
                    name = "PlacesKit";
                }
            }
            return name;
        }

        static Feature fromInt(int code) {
            for (Feature feature : Feature.values()) {
                if (feature.code != code) continue;
                return feature;
            }
            return Unknown;
        }

        public Feature getParent() {
            if ((this.code & 0xFF) > 0) {
                return Feature.fromInt(this.code & 0xFFFFFF00);
            }
            if ((this.code & 0xFF00) > 0) {
                return Feature.fromInt(this.code & 0xFFFF0000);
            }
            if ((this.code & 0xFF0000) > 0) {
                return Feature.fromInt(this.code & 0xFF000000);
            }
            return Feature.fromInt(0);
        }
    }
}

