/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument.crashreport;

import android.os.Process;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.internal.instrument.InstrumentUtility;
import com.facebook.internal.instrument.crashreport.CrashReportData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.json.JSONArray;
import org.json.JSONException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = CrashHandler.class.getCanonicalName();
    private static final int MAX_CRASH_REPORT_NUM = 5;
    @Nullable
    private static CrashHandler instance;
    @Nullable
    private final Thread.UncaughtExceptionHandler mPreviousHandler;
    private boolean mEndApplication;

    private CrashHandler(@Nullable Thread.UncaughtExceptionHandler oldHandler) {
        this.mPreviousHandler = oldHandler;
        this.mEndApplication = false;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (InstrumentUtility.isSDKRelatedException(e)) {
            CrashReportData crashData = new CrashReportData(e);
            crashData.save();
        }
        if (this.mPreviousHandler != null) {
            this.mPreviousHandler.uncaughtException(t, e);
        }
        if (this.mEndApplication) {
            CrashHandler.killProcess();
        }
    }

    public static synchronized void enable() {
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            CrashHandler.sendCrashReports();
        }
        if (instance != null) {
            Log.w((String)TAG, (String)"Already enabled!");
            return;
        }
        Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        instance = new CrashHandler(oldHandler);
        Thread.setDefaultUncaughtExceptionHandler(instance);
    }

    public void endApplication() {
        this.mEndApplication = true;
    }

    private static void killProcess() {
        try {
            Process.killProcess((int)Process.myPid());
            System.exit(10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void sendCrashReports() {
        File[] reports = InstrumentUtility.listCrashReportFiles();
        final ArrayList<CrashReportData> validReports = new ArrayList<CrashReportData>();
        for (File report : reports) {
            CrashReportData crashData = new CrashReportData(report);
            if (!crashData.isValid()) continue;
            validReports.add(crashData);
        }
        Collections.sort(validReports, new Comparator<CrashReportData>(){

            @Override
            public int compare(CrashReportData o1, CrashReportData o2) {
                return o1.compareTo(o2);
            }
        });
        JSONArray crashLogs = new JSONArray();
        for (int i = 0; i < validReports.size() && i < 5; ++i) {
            crashLogs.put(validReports.get(i));
        }
        InstrumentUtility.sendReports("crash_reports", crashLogs, new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                try {
                    if (response.getError() == null && response.getJSONObject().getBoolean("success")) {
                        for (int i = 0; validReports.size() > i; ++i) {
                            ((CrashReportData)validReports.get(i)).clear();
                        }
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        });
    }
}

