/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.view.View;
import android.widget.AdapterView;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.internal.EventBinding;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CodelessLoggingEventListener {
    private static final String TAG = CodelessLoggingEventListener.class.getCanonicalName();

    public static AutoLoggingOnClickListener getOnClickListener(EventBinding mapping, View rootView, View hostView) {
        return new AutoLoggingOnClickListener(mapping, rootView, hostView);
    }

    public static AutoLoggingOnItemClickListener getOnItemClickListener(EventBinding mapping, View rootView, AdapterView hostView) {
        return new AutoLoggingOnItemClickListener(mapping, rootView, hostView);
    }

    private static void logEvent(EventBinding mapping, View rootView, View hostView) {
        final String eventName = mapping.getEventName();
        final Bundle parameters = CodelessMatcher.getParameters(mapping, rootView, hostView);
        if (parameters.containsKey("_valueToSum")) {
            String value = parameters.getString("_valueToSum");
            parameters.putDouble("_valueToSum", AppEventUtility.normalizePrice(value));
        }
        parameters.putString("_is_fb_codeless", "1");
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Context context = FacebookSdk.getApplicationContext();
                AppEventsLogger appEventsLogger = AppEventsLogger.newLogger(context);
                appEventsLogger.logEvent(eventName, parameters);
            }
        });
    }

    public static class AutoLoggingOnItemClickListener
    implements AdapterView.OnItemClickListener {
        private EventBinding mapping;
        private WeakReference<AdapterView> hostView;
        private WeakReference<View> rootView;
        @Nullable
        private AdapterView.OnItemClickListener existingOnItemClickListener;
        private boolean supportCodelessLogging = false;

        private AutoLoggingOnItemClickListener(EventBinding mapping, View rootView, AdapterView hostView) {
            if (null == mapping || null == rootView || null == hostView) {
                return;
            }
            this.existingOnItemClickListener = hostView.getOnItemClickListener();
            this.mapping = mapping;
            this.hostView = new WeakReference<AdapterView>(hostView);
            this.rootView = new WeakReference<View>(rootView);
            this.supportCodelessLogging = true;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
            if (this.existingOnItemClickListener != null) {
                this.existingOnItemClickListener.onItemClick(parent, view, position, id);
            }
            if (this.rootView.get() != null && this.hostView.get() != null) {
                CodelessLoggingEventListener.logEvent(this.mapping, (View)this.rootView.get(), (View)this.hostView.get());
            }
        }

        public boolean getSupportCodelessLogging() {
            return this.supportCodelessLogging;
        }
    }

    public static class AutoLoggingOnClickListener
    implements View.OnClickListener {
        private EventBinding mapping;
        private WeakReference<View> hostView;
        private WeakReference<View> rootView;
        @Nullable
        private View.OnClickListener existingOnClickListener;
        private boolean supportCodelessLogging = false;

        private AutoLoggingOnClickListener(EventBinding mapping, View rootView, View hostView) {
            if (null == mapping || null == rootView || null == hostView) {
                return;
            }
            this.existingOnClickListener = ViewHierarchy.getExistingOnClickListener(hostView);
            this.mapping = mapping;
            this.hostView = new WeakReference<View>(hostView);
            this.rootView = new WeakReference<View>(rootView);
            this.supportCodelessLogging = true;
        }

        public void onClick(View view) {
            if (this.existingOnClickListener != null) {
                this.existingOnClickListener.onClick(view);
            }
            if (this.rootView.get() != null && this.hostView.get() != null) {
                CodelessLoggingEventListener.logEvent(this.mapping, (View)this.rootView.get(), (View)this.hostView.get());
            }
        }

        public boolean getSupportCodelessLogging() {
            return this.supportCodelessLogging;
        }
    }
}

