/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.aam;

import android.support.annotation.RestrictTo;
import com.facebook.appevents.UserDataStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class MetadataRule {
    private static final String TAG = MetadataRule.class.getCanonicalName();
    private static List<MetadataRule> rules = new ArrayList<MetadataRule>();
    private static final String FIELD_K = "k";
    private static final String FIELD_V = "v";
    private static final String FILED_K_DELIMITER = ",";
    private String name;
    private List<String> keyRules;
    private String valRule;

    private MetadataRule(String name, List<String> keyRules, String valRule) {
        this.name = name;
        this.keyRules = keyRules;
        this.valRule = valRule;
    }

    static List<MetadataRule> getRules() {
        return new ArrayList<MetadataRule>(rules);
    }

    String getName() {
        return this.name;
    }

    List<String> getKeyRules() {
        return new ArrayList<String>(this.keyRules);
    }

    String getValRule() {
        return this.valRule;
    }

    static void updateRules(String rulesFromServer) {
        try {
            rules.clear();
            JSONObject jsonObject = new JSONObject(rulesFromServer);
            MetadataRule.constructRules(jsonObject);
            MetadataRule.removeUnusedRules();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static void constructRules(JSONObject jsonObject) {
        try {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                JSONObject ruleJson;
                String key = (String)keys.next();
                if (!(jsonObject.get(key) instanceof JSONObject) || !(ruleJson = jsonObject.getJSONObject(key)).has(FIELD_K) || !ruleJson.has(FIELD_V) || ruleJson.getString(FIELD_K).isEmpty() || ruleJson.getString(FIELD_V).isEmpty()) continue;
                rules.add(new MetadataRule(key, Arrays.asList(ruleJson.getString(FIELD_K).split(FILED_K_DELIMITER)), ruleJson.getString(FIELD_V)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static void removeUnusedRules() {
        Map<String, String> internalHashedUserData = UserDataStore.getInternalHashedUserData();
        if (internalHashedUserData.isEmpty()) {
            return;
        }
        HashSet<String> ruleNames = new HashSet<String>();
        for (MetadataRule r : rules) {
            ruleNames.add(r.getName());
        }
        ArrayList<String> rulesToRemove = new ArrayList<String>();
        for (String ruleKey : internalHashedUserData.keySet()) {
            if (ruleNames.contains(ruleKey)) continue;
            rulesToRemove.add(ruleKey);
        }
        if (!rulesToRemove.isEmpty()) {
            UserDataStore.removeRules(rulesToRemove);
        }
    }
}

