/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.webkit.WebView;
import com.facebook.AccessToken;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AnalyticsUserIDStore;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.AppEventQueue;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.FacebookSDKJSInterface;
import com.facebook.appevents.FlushReason;
import com.facebook.appevents.UserDataStore;
import com.facebook.appevents.internal.ActivityLifecycleTracker;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.FetchedAppGateKeepersManager;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AppEventsLoggerImpl {
    private static final String TAG = AppEventsLoggerImpl.class.getCanonicalName();
    private static final int APP_SUPPORTS_ATTRIBUTION_ID_RECHECK_PERIOD_IN_SECONDS = 86400;
    private static final String PUSH_PAYLOAD_KEY = "fb_push_payload";
    private static final String PUSH_PAYLOAD_CAMPAIGN_KEY = "campaign";
    private static final String APP_EVENT_NAME_PUSH_OPENED = "fb_mobile_push_opened";
    private static final String APP_EVENT_PUSH_PARAMETER_CAMPAIGN = "fb_push_campaign";
    private static final String APP_EVENT_PUSH_PARAMETER_ACTION = "fb_push_action";
    private static final String ACCOUNT_KIT_EVENT_NAME_PREFIX = "fb_ak";
    private final String contextName;
    private final AccessTokenAppIdPair accessTokenAppId;
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    private static AppEventsLogger.FlushBehavior flushBehavior;
    private static final Object staticLock;
    private static String anonymousAppDeviceGUID;
    private static boolean isActivateAppEventRequested;
    private static String pushNotificationsRegistrationId;
    private static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    private static final String APP_EVENTS_KILLSWITCH = "app_events_killswitch";

    static void activateApp(Application application, String applicationId) {
        if (!FacebookSdk.isInitialized()) {
            throw new FacebookException("The Facebook sdk must be initialized before calling activateApp");
        }
        AnalyticsUserIDStore.initStore();
        UserDataStore.initStore();
        if (applicationId == null) {
            applicationId = FacebookSdk.getApplicationId();
        }
        FacebookSdk.publishInstallAsync((Context)application, applicationId);
        ActivityLifecycleTracker.startTracking(application, applicationId);
    }

    static void functionDEPRECATED(String extraMsg) {
        Log.w((String)TAG, (String)("This function is deprecated. " + extraMsg));
    }

    static void initializeLib(final Context context, String applicationId) {
        if (!FacebookSdk.getAutoLogAppEventsEnabled()) {
            return;
        }
        final AppEventsLoggerImpl logger = new AppEventsLoggerImpl(context, applicationId, null);
        backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Bundle params = new Bundle();
                String[] classes = new String[]{"com.facebook.core.Core", "com.facebook.login.Login", "com.facebook.share.Share", "com.facebook.places.Places", "com.facebook.messenger.Messenger", "com.facebook.applinks.AppLinks", "com.facebook.marketing.Marketing", "com.facebook.all.All", "com.android.billingclient.api.BillingClient", "com.android.vending.billing.IInAppBillingService"};
                String[] keys = new String[]{"core_lib_included", "login_lib_included", "share_lib_included", "places_lib_included", "messenger_lib_included", "applinks_lib_included", "marketing_lib_included", "all_lib_included", "billing_client_lib_included", "billing_service_lib_included"};
                if (classes.length != keys.length) {
                    throw new FacebookException("Number of class names and key names should match");
                }
                int bitmask = 0;
                for (int i = 0; i < classes.length; ++i) {
                    String className = classes[i];
                    String keyName = keys[i];
                    try {
                        Class.forName(className);
                        params.putInt(keyName, 1);
                        bitmask |= 1 << i;
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                SharedPreferences preferences = context.getSharedPreferences(AppEventsLoggerImpl.APP_EVENT_PREFERENCES, 0);
                int previousBitmask = preferences.getInt("kitsBitmask", 0);
                if (previousBitmask != bitmask) {
                    preferences.edit().putInt("kitsBitmask", bitmask).apply();
                    logger.logEventImplicitly("fb_sdk_initialize", null, params);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AppEventsLogger.FlushBehavior getFlushBehavior() {
        Object object = staticLock;
        synchronized (object) {
            return flushBehavior;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setFlushBehavior(AppEventsLogger.FlushBehavior flushBehavior) {
        Object object = staticLock;
        synchronized (object) {
            AppEventsLoggerImpl.flushBehavior = flushBehavior;
        }
    }

    void logEvent(String eventName) {
        this.logEvent(eventName, null);
    }

    void logEvent(String eventName, double valueToSum) {
        this.logEvent(eventName, valueToSum, null);
    }

    void logEvent(String eventName, Bundle parameters) {
        this.logEvent(eventName, null, parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    void logEvent(String eventName, double valueToSum, Bundle parameters) {
        this.logEvent(eventName, valueToSum, parameters, false, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    void logEventFromSE(String eventName) {
        Bundle parameters = new Bundle();
        parameters.putString("_is_suggested_event", "1");
        this.logEvent(eventName, parameters);
    }

    void logPurchase(BigDecimal purchaseAmount, Currency currency) {
        this.logPurchase(purchaseAmount, currency, null);
    }

    void logPurchase(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        if (AutomaticAnalyticsLogger.isImplicitPurchaseLoggingEnabled()) {
            Log.w((String)TAG, (String)"You are logging purchase events while auto-logging of in-app purchase is enabled in the SDK. Make sure you don't log duplicate events");
        }
        this.logPurchase(purchaseAmount, currency, parameters, false);
    }

    void logPurchaseImplicitly(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        this.logPurchase(purchaseAmount, currency, parameters, true);
    }

    void logPurchase(BigDecimal purchaseAmount, Currency currency, Bundle parameters, boolean isImplicitlyLogged) {
        if (purchaseAmount == null) {
            AppEventsLoggerImpl.notifyDeveloperError("purchaseAmount cannot be null");
            return;
        }
        if (currency == null) {
            AppEventsLoggerImpl.notifyDeveloperError("currency cannot be null");
            return;
        }
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString("fb_currency", currency.getCurrencyCode());
        this.logEvent("fb_mobile_purchase", purchaseAmount.doubleValue(), parameters, isImplicitlyLogged, ActivityLifecycleTracker.getCurrentSessionGuid());
        AppEventsLoggerImpl.eagerFlush();
    }

    void logPushNotificationOpen(Bundle payload, String action) {
        String campaignId = null;
        try {
            String payloadString = payload.getString(PUSH_PAYLOAD_KEY);
            if (Utility.isNullOrEmpty(payloadString)) {
                return;
            }
            JSONObject facebookPayload = new JSONObject(payloadString);
            campaignId = facebookPayload.getString(PUSH_PAYLOAD_CAMPAIGN_KEY);
        }
        catch (JSONException payloadString) {
            // empty catch block
        }
        if (campaignId == null) {
            Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "Malformed payload specified for logging a push notification open.");
            return;
        }
        Bundle parameters = new Bundle();
        parameters.putString(APP_EVENT_PUSH_PARAMETER_CAMPAIGN, campaignId);
        if (action != null) {
            parameters.putString(APP_EVENT_PUSH_PARAMETER_ACTION, action);
        }
        this.logEvent(APP_EVENT_NAME_PUSH_OPENED, parameters);
    }

    void logProductItem(String itemID, AppEventsLogger.ProductAvailability availability, AppEventsLogger.ProductCondition condition, String description, String imageLink, String link, String title, BigDecimal priceAmount, Currency currency, String gtin, String mpn, String brand, Bundle parameters) {
        if (itemID == null) {
            AppEventsLoggerImpl.notifyDeveloperError("itemID cannot be null");
            return;
        }
        if (availability == null) {
            AppEventsLoggerImpl.notifyDeveloperError("availability cannot be null");
            return;
        }
        if (condition == null) {
            AppEventsLoggerImpl.notifyDeveloperError("condition cannot be null");
            return;
        }
        if (description == null) {
            AppEventsLoggerImpl.notifyDeveloperError("description cannot be null");
            return;
        }
        if (imageLink == null) {
            AppEventsLoggerImpl.notifyDeveloperError("imageLink cannot be null");
            return;
        }
        if (link == null) {
            AppEventsLoggerImpl.notifyDeveloperError("link cannot be null");
            return;
        }
        if (title == null) {
            AppEventsLoggerImpl.notifyDeveloperError("title cannot be null");
            return;
        }
        if (priceAmount == null) {
            AppEventsLoggerImpl.notifyDeveloperError("priceAmount cannot be null");
            return;
        }
        if (currency == null) {
            AppEventsLoggerImpl.notifyDeveloperError("currency cannot be null");
            return;
        }
        if (gtin == null && mpn == null && brand == null) {
            AppEventsLoggerImpl.notifyDeveloperError("Either gtin, mpn or brand is required");
            return;
        }
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString("fb_product_item_id", itemID);
        parameters.putString("fb_product_availability", availability.name());
        parameters.putString("fb_product_condition", condition.name());
        parameters.putString("fb_product_description", description);
        parameters.putString("fb_product_image_link", imageLink);
        parameters.putString("fb_product_link", link);
        parameters.putString("fb_product_title", title);
        parameters.putString("fb_product_price_amount", priceAmount.setScale(3, 4).toString());
        parameters.putString("fb_product_price_currency", currency.getCurrencyCode());
        if (gtin != null) {
            parameters.putString("fb_product_gtin", gtin);
        }
        if (mpn != null) {
            parameters.putString("fb_product_mpn", mpn);
        }
        if (brand != null) {
            parameters.putString("fb_product_brand", brand);
        }
        this.logEvent("fb_mobile_catalog_update", parameters);
        AppEventsLoggerImpl.eagerFlush();
    }

    void flush() {
        AppEventQueue.flush(FlushReason.EXPLICIT);
    }

    static void onContextStop() {
        AppEventQueue.persistToDisk();
    }

    boolean isValidForAccessToken(AccessToken accessToken) {
        AccessTokenAppIdPair other = new AccessTokenAppIdPair(accessToken);
        return this.accessTokenAppId.equals(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPushNotificationsRegistrationId(String registrationId) {
        Object object = staticLock;
        synchronized (object) {
            if (!Utility.stringsEqualOrEmpty(pushNotificationsRegistrationId, registrationId)) {
                pushNotificationsRegistrationId = registrationId;
                AppEventsLoggerImpl logger = new AppEventsLoggerImpl(FacebookSdk.getApplicationContext(), null, null);
                logger.logEvent("fb_mobile_obtain_push_token");
                if (AppEventsLoggerImpl.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
                    logger.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPushNotificationsRegistrationId() {
        Object object = staticLock;
        synchronized (object) {
            return pushNotificationsRegistrationId;
        }
    }

    static void setInstallReferrer(String referrer) {
        Context ctx = FacebookSdk.getApplicationContext();
        SharedPreferences preferences = ctx.getSharedPreferences(APP_EVENT_PREFERENCES, 0);
        if (referrer != null) {
            preferences.edit().putString("install_referrer", referrer).apply();
        }
    }

    @Nullable
    static String getInstallReferrer() {
        Context ctx = FacebookSdk.getApplicationContext();
        SharedPreferences preferences = ctx.getSharedPreferences(APP_EVENT_PREFERENCES, 0);
        return preferences.getString("install_referrer", null);
    }

    static void augmentWebView(WebView webView, Context context) {
        int minorRelease;
        String[] parts = Build.VERSION.RELEASE.split("\\.");
        int majorRelease = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
        int n = minorRelease = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        if (Build.VERSION.SDK_INT < 17 || majorRelease < 4 || majorRelease == 4 && minorRelease <= 1) {
            Logger.log(LoggingBehavior.DEVELOPER_ERRORS, TAG, "augmentWebView is only available for Android SDK version >= 17 on devices running Android >= 4.2");
            return;
        }
        webView.addJavascriptInterface((Object)new FacebookSDKJSInterface(context), "fbmq_" + FacebookSdk.getApplicationId());
    }

    static void updateUserProperties(final Bundle parameters, final String applicationID, final GraphRequest.Callback callback) {
        AppEventsLoggerImpl.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String userID = AnalyticsUserIDStore.getUserID();
                if (userID == null || userID.isEmpty()) {
                    Logger.log(LoggingBehavior.APP_EVENTS, TAG, "AppEventsLogger userID cannot be null or empty");
                    return;
                }
                Bundle userPropertiesParams = new Bundle();
                userPropertiesParams.putString("user_unique_id", userID);
                userPropertiesParams.putBundle("custom_data", parameters);
                AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(FacebookSdk.getApplicationContext());
                if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                    userPropertiesParams.putString("advertiser_id", identifiers.getAndroidAdvertiserId());
                }
                Bundle data = new Bundle();
                try {
                    JSONObject userData = BundleJSONConverter.convertToJSON(userPropertiesParams);
                    JSONArray dataArray = new JSONArray();
                    dataArray.put((Object)userData);
                    data.putString("data", dataArray.toString());
                }
                catch (JSONException ex) {
                    throw new FacebookException("Failed to construct request", ex);
                }
                GraphRequest request = new GraphRequest(AccessToken.getCurrentAccessToken(), String.format(Locale.US, "%s/user_properties", applicationID), data, HttpMethod.POST, callback);
                request.setSkipClientToken(true);
                request.executeAsync();
            }
        });
    }

    void logSdkEvent(String eventName, Double valueToSum, Bundle parameters) {
        if (!eventName.startsWith(ACCOUNT_KIT_EVENT_NAME_PREFIX)) {
            Log.e((String)TAG, (String)"logSdkEvent is deprecated and only supports account kit for legacy, please use logEvent instead");
            return;
        }
        if (FacebookSdk.getAutoLogAppEventsEnabled()) {
            this.logEvent(eventName, valueToSum, parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
        }
    }

    public String getApplicationId() {
        return this.accessTokenAppId.getApplicationId();
    }

    AppEventsLoggerImpl(Context context, String applicationId, AccessToken accessToken) {
        this(Utility.getActivityName(context), applicationId, accessToken);
    }

    AppEventsLoggerImpl(String activityName, String applicationId, AccessToken accessToken) {
        Validate.sdkInitialized();
        this.contextName = activityName;
        if (accessToken == null) {
            accessToken = AccessToken.getCurrentAccessToken();
        }
        if (AccessToken.isCurrentAccessTokenActive() && (applicationId == null || applicationId.equals(accessToken.getApplicationId()))) {
            this.accessTokenAppId = new AccessTokenAppIdPair(accessToken);
        } else {
            if (applicationId == null) {
                applicationId = Utility.getMetadataApplicationId(FacebookSdk.getApplicationContext());
            }
            this.accessTokenAppId = new AccessTokenAppIdPair(null, applicationId);
        }
        AppEventsLoggerImpl.initializeTimersIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeTimersIfNeeded() {
        Object object = staticLock;
        synchronized (object) {
            if (backgroundExecutor != null) {
                return;
            }
            backgroundExecutor = new ScheduledThreadPoolExecutor(1);
        }
        Runnable attributionRecheckRunnable = new Runnable(){

            @Override
            public void run() {
                HashSet<String> applicationIds = new HashSet<String>();
                for (AccessTokenAppIdPair accessTokenAppId : AppEventQueue.getKeySet()) {
                    applicationIds.add(accessTokenAppId.getApplicationId());
                }
                for (String applicationId : applicationIds) {
                    FetchedAppSettingsManager.queryAppSettings(applicationId, true);
                }
            }
        };
        backgroundExecutor.scheduleAtFixedRate(attributionRecheckRunnable, 0L, 86400L, TimeUnit.SECONDS);
    }

    void logEventImplicitly(String eventName, Double valueToSum, Bundle parameters) {
        this.logEvent(eventName, valueToSum, parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    void logEventImplicitly(String eventName, BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        if (purchaseAmount == null || currency == null) {
            Utility.logd(TAG, "purchaseAmount and currency cannot be null");
            return;
        }
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString("fb_currency", currency.getCurrencyCode());
        this.logEvent(eventName, purchaseAmount.doubleValue(), parameters, true, ActivityLifecycleTracker.getCurrentSessionGuid());
    }

    void logEvent(String eventName, Double valueToSum, Bundle parameters, boolean isImplicitlyLogged, @Nullable UUID currentSessionId) {
        if (eventName == null || eventName.isEmpty()) {
            return;
        }
        if (FetchedAppGateKeepersManager.getGateKeeperForKey(APP_EVENTS_KILLSWITCH, FacebookSdk.getApplicationId(), false)) {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "KillSwitch is enabled and fail to log app event: %s", eventName);
            return;
        }
        try {
            AppEvent event = new AppEvent(this.contextName, eventName, valueToSum, parameters, isImplicitlyLogged, ActivityLifecycleTracker.isInBackground(), currentSessionId);
            AppEventsLoggerImpl.logEvent(event, this.accessTokenAppId);
        }
        catch (JSONException jsonException) {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "JSON encoding for app event failed: '%s'", jsonException.toString());
        }
        catch (FacebookException e) {
            Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Invalid app event: %s", e.toString());
        }
    }

    private static void logEvent(AppEvent event, AccessTokenAppIdPair accessTokenAppId) {
        AppEventQueue.add(accessTokenAppId, event);
        if (!event.getIsImplicit() && !isActivateAppEventRequested) {
            if (event.getName().equals("fb_mobile_activate_app")) {
                isActivateAppEventRequested = true;
            } else {
                Logger.log(LoggingBehavior.APP_EVENTS, "AppEvents", "Warning: Please call AppEventsLogger.activateApp(...)from the long-lived activity's onResume() methodbefore logging other app events.");
            }
        }
    }

    static void eagerFlush() {
        if (AppEventsLoggerImpl.getFlushBehavior() != AppEventsLogger.FlushBehavior.EXPLICIT_ONLY) {
            AppEventQueue.flush(FlushReason.EAGER_FLUSHING_EVENT);
        }
    }

    private static void notifyDeveloperError(String message) {
        Logger.log(LoggingBehavior.DEVELOPER_ERRORS, "AppEvents", message);
    }

    static Executor getAnalyticsExecutor() {
        if (backgroundExecutor == null) {
            AppEventsLoggerImpl.initializeTimersIfNeeded();
        }
        return backgroundExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getAnonymousAppDeviceGUID(Context context) {
        if (anonymousAppDeviceGUID == null) {
            Object object = staticLock;
            synchronized (object) {
                SharedPreferences preferences;
                if (anonymousAppDeviceGUID == null && (anonymousAppDeviceGUID = (preferences = context.getSharedPreferences(APP_EVENT_PREFERENCES, 0)).getString("anonymousAppDeviceGUID", null)) == null) {
                    anonymousAppDeviceGUID = "XZ" + UUID.randomUUID().toString();
                    context.getSharedPreferences(APP_EVENT_PREFERENCES, 0).edit().putString("anonymousAppDeviceGUID", anonymousAppDeviceGUID).apply();
                }
            }
        }
        return anonymousAppDeviceGUID;
    }

    static {
        flushBehavior = AppEventsLogger.FlushBehavior.AUTO;
        staticLock = new Object();
    }
}

