/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Log;
import com.facebook.appevents.AppEvent;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RestrictiveDataManager {
    private static boolean enabled = false;
    private static final String TAG = RestrictiveDataManager.class.getCanonicalName();
    private static List<RestrictiveParam> restrictiveParams = new ArrayList<RestrictiveParam>();
    private static Set<String> restrictiveEvents = new HashSet<String>();

    public static void enable() {
        enabled = true;
    }

    public static synchronized void updateFromSetting(String eventFilterResponse) {
        if (!enabled) {
            return;
        }
        try {
            if (!eventFilterResponse.isEmpty()) {
                JSONObject jsonObject = new JSONObject(eventFilterResponse);
                restrictiveParams.clear();
                restrictiveEvents.clear();
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject json = jsonObject.getJSONObject(key);
                    if (json == null) continue;
                    if (json.optBoolean("is_deprecated_event")) {
                        restrictiveEvents.add(key);
                        continue;
                    }
                    JSONObject paramJson = jsonObject.getJSONObject(key).optJSONObject("restrictive_param");
                    if (paramJson == null) continue;
                    restrictiveParams.add(new RestrictiveParam(key, Utility.convertJSONObjectToStringMap(paramJson)));
                }
            }
        }
        catch (JSONException je) {
            Log.w((String)TAG, (String)"updateRulesFromSetting failed", (Throwable)je);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"updateFromSetting failed", (Throwable)e);
        }
    }

    public static void processEvents(List<AppEvent> events) {
        if (!enabled) {
            return;
        }
        Iterator<AppEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            AppEvent event = iterator.next();
            if (!RestrictiveDataManager.isDeprecatedEvent(event.getName())) continue;
            iterator.remove();
        }
    }

    public static void processParameters(Map<String, String> parameters, String eventName) {
        if (!enabled) {
            return;
        }
        HashMap<String, String> restrictedParams = new HashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        for (String key : keys) {
            String type = RestrictiveDataManager.getMatchedRuleType(eventName, key);
            if (type == null) continue;
            restrictedParams.put(key, type);
            parameters.remove(key);
        }
        if (restrictedParams.size() > 0) {
            try {
                JSONObject restrictedJSON = new JSONObject();
                for (Map.Entry entry : restrictedParams.entrySet()) {
                    restrictedJSON.put((String)entry.getKey(), entry.getValue());
                }
                parameters.put("_restrictedParams", restrictedJSON.toString());
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"processParameters failed", (Throwable)e);
            }
        }
    }

    private static boolean isDeprecatedEvent(String eventName) {
        return restrictiveEvents.contains(eventName);
    }

    @Nullable
    private static String getMatchedRuleType(String eventName, String paramKey) {
        try {
            ArrayList<RestrictiveParam> restrictiveParamsCopy = new ArrayList<RestrictiveParam>(restrictiveParams);
            for (RestrictiveParam filter : restrictiveParamsCopy) {
                if (filter == null || !eventName.equals(filter.eventName)) continue;
                for (String param : filter.params.keySet()) {
                    if (!paramKey.equals(param)) continue;
                    return filter.params.get(param);
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"getMatchedRuleType failed", (Throwable)e);
        }
        return null;
    }

    static class RestrictiveParam {
        String eventName;
        Map<String, String> params;

        RestrictiveParam(String eventName, Map<String, String> params) {
            this.eventName = eventName;
            this.params = params;
        }
    }
}

