/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RestrictTo;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.codeless.CodelessManager;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SessionLogger;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ActivityLifecycleTracker {
    private static final String TAG = ActivityLifecycleTracker.class.getCanonicalName();
    private static final String INCORRECT_IMPL_WARNING = "Unexpected activity pause without a matching activity resume. Logging data may be incorrect. Make sure you call activateApp from your Application's onCreate method";
    private static final long INTERRUPTION_THRESHOLD_MILLISECONDS = 1000L;
    private static final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
    private static volatile ScheduledFuture currentFuture;
    private static final Object currentFutureLock;
    private static AtomicInteger foregroundActivityCount;
    private static volatile SessionInfo currentSession;
    private static AtomicBoolean tracking;
    private static String appId;
    private static long currentActivityAppearTime;
    private static int activityReferences;

    public static void startTracking(Application application, String appId) {
        if (!tracking.compareAndSet(false, true)) {
            return;
        }
        FeatureManager.checkFeature(FeatureManager.Feature.CodelessEvents, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (enabled) {
                    CodelessManager.enable();
                } else {
                    CodelessManager.disable();
                }
            }
        });
        ActivityLifecycleTracker.appId = appId;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityCreated");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityCreated(activity);
            }

            public void onActivityStarted(Activity activity) {
                activityReferences++;
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityStarted");
            }

            public void onActivityResumed(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityResumed");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityResumed(activity);
            }

            public void onActivityPaused(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityPaused");
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityPaused(activity);
            }

            public void onActivityStopped(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityStopped");
                AppEventsLogger.onContextStop();
                activityReferences--;
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivitySaveInstanceState");
            }

            public void onActivityDestroyed(Activity activity) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "onActivityDestroyed");
                ActivityLifecycleTracker.onActivityDestroyed(activity);
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isInBackground() {
        return 0 == activityReferences;
    }

    public static boolean isTracking() {
        return tracking.get();
    }

    public static UUID getCurrentSessionGuid() {
        return currentSession != null ? currentSession.getSessionId() : null;
    }

    public static void onActivityCreated(Activity activity) {
        singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (currentSession == null) {
                    currentSession = SessionInfo.getStoredSessionInfo();
                }
            }
        });
    }

    public static void onActivityResumed(Activity activity) {
        long currentTime;
        foregroundActivityCount.incrementAndGet();
        ActivityLifecycleTracker.cancelCurrentTask();
        currentActivityAppearTime = currentTime = System.currentTimeMillis();
        final String activityName = Utility.getActivityName((Context)activity);
        CodelessManager.onActivityResumed(activity);
        Runnable handleActivityResume = new Runnable(){

            @Override
            public void run() {
                if (currentSession == null) {
                    currentSession = new SessionInfo(currentTime, null);
                    SessionLogger.logActivateApp(activityName, null, appId);
                } else if (currentSession.getSessionLastEventTime() != null) {
                    long suspendTime = currentTime - currentSession.getSessionLastEventTime();
                    if (suspendTime > (long)(ActivityLifecycleTracker.getSessionTimeoutInSeconds() * 1000)) {
                        SessionLogger.logDeactivateApp(activityName, currentSession, appId);
                        SessionLogger.logActivateApp(activityName, null, appId);
                        currentSession = new SessionInfo(currentTime, null);
                    } else if (suspendTime > 1000L) {
                        currentSession.incrementInterruptionCount();
                    }
                }
                currentSession.setSessionLastEventTime(currentTime);
                currentSession.writeSessionToDisk();
            }
        };
        singleThreadExecutor.execute(handleActivityResume);
    }

    private static void onActivityPaused(Activity activity) {
        int count = foregroundActivityCount.decrementAndGet();
        if (count < 0) {
            foregroundActivityCount.set(0);
            Log.w((String)TAG, (String)INCORRECT_IMPL_WARNING);
        }
        ActivityLifecycleTracker.cancelCurrentTask();
        final long currentTime = System.currentTimeMillis();
        final String activityName = Utility.getActivityName((Context)activity);
        CodelessManager.onActivityPaused(activity);
        Runnable handleActivityPaused = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long appearTime;
                if (currentSession == null) {
                    currentSession = new SessionInfo(currentTime, null);
                }
                currentSession.setSessionLastEventTime(currentTime);
                if (foregroundActivityCount.get() <= 0) {
                    Runnable task = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (foregroundActivityCount.get() <= 0) {
                                SessionLogger.logDeactivateApp(activityName, currentSession, appId);
                                SessionInfo.clearSavedSessionFromDisk();
                                currentSession = null;
                            }
                            Object object = currentFutureLock;
                            synchronized (object) {
                                currentFuture = null;
                            }
                        }
                    };
                    Object object = currentFutureLock;
                    synchronized (object) {
                        currentFuture = singleThreadExecutor.schedule(task, (long)ActivityLifecycleTracker.getSessionTimeoutInSeconds(), TimeUnit.SECONDS);
                    }
                }
                long timeSpentOnActivityInSeconds = (appearTime = currentActivityAppearTime) > 0L ? (currentTime - appearTime) / 1000L : 0L;
                AutomaticAnalyticsLogger.logActivityTimeSpentEvent(activityName, timeSpentOnActivityInSeconds);
                currentSession.writeSessionToDisk();
            }
        };
        singleThreadExecutor.execute(handleActivityPaused);
    }

    private static void onActivityDestroyed(Activity activity) {
        CodelessManager.onActivityDestroyed(activity);
    }

    private static int getSessionTimeoutInSeconds() {
        FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(FacebookSdk.getApplicationId());
        if (settings == null) {
            return Constants.getDefaultAppEventsSessionTimeoutInSeconds();
        }
        return settings.getSessionTimeoutInSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelCurrentTask() {
        Object object = currentFutureLock;
        synchronized (object) {
            if (currentFuture != null) {
                currentFuture.cancel(false);
            }
            currentFuture = null;
        }
    }

    static {
        currentFutureLock = new Object();
        foregroundActivityCount = new AtomicInteger(0);
        tracking = new AtomicBoolean(false);
        activityReferences = 0;
    }
}

