/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal.instrument;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.internal.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InstrumentUtility {
    public static final String CRASH_REPORT_PREFIX = "crash_log_";
    public static final String ERROR_REPORT_PREFIX = "error_log_";
    private static final String FBSDK_PREFIX = "com.facebook";
    private static final String INSTRUMENT_DIR = "instrument";

    @Nullable
    public static String getCause(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e.getCause() == null) {
            return e.toString();
        }
        return e.getCause().toString();
    }

    @Nullable
    public static String getStackTrace(Throwable e) {
        if (e == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        Throwable previous = null;
        for (Throwable t = e; t != null && t != previous; t = t.getCause()) {
            for (StackTraceElement element : t.getStackTrace()) {
                array.put((Object)element.toString());
            }
            previous = t;
        }
        return array.toString();
    }

    public static boolean isSDKRelatedException(@Nullable Throwable e) {
        if (e == null) {
            return false;
        }
        Throwable previous = null;
        for (Throwable t = e; t != null && t != previous; t = t.getCause()) {
            for (StackTraceElement element : t.getStackTrace()) {
                if (!element.getClassName().startsWith(FBSDK_PREFIX)) continue;
                return true;
            }
            previous = t;
        }
        return false;
    }

    public static File[] listCrashReportFiles() {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null) {
            return new File[0];
        }
        return reportDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(String.format("^%s[0-9]+.json$", InstrumentUtility.CRASH_REPORT_PREFIX));
            }
        });
    }

    @Nullable
    public static JSONObject readFile(@Nullable String filename, boolean deleteOnException) {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null || filename == null) {
            return null;
        }
        File file = new File(reportDir, filename);
        try {
            FileInputStream inputStream = new FileInputStream(file);
            String content = Utility.readStreamToString(inputStream);
            return new JSONObject(content);
        }
        catch (Exception e) {
            if (deleteOnException) {
                InstrumentUtility.deleteFile(filename);
            }
            return null;
        }
    }

    public static void writeFile(@Nullable String filename, @Nullable String content) {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null || filename == null || content == null) {
            return;
        }
        File file = new File(reportDir, filename);
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            outputStream.write(content.getBytes());
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean deleteFile(@Nullable String filename) {
        File reportDir = InstrumentUtility.getInstrumentReportDir();
        if (reportDir == null || filename == null) {
            return false;
        }
        File file = new File(reportDir, filename);
        return file.delete();
    }

    public static void sendReports(String key, JSONArray reports, GraphRequest.Callback callback) {
        if (reports.length() == 0) {
            return;
        }
        JSONObject params = new JSONObject();
        try {
            params.put(key, (Object)reports.toString());
        }
        catch (JSONException e) {
            return;
        }
        GraphRequest request = GraphRequest.newPostRequest(null, String.format("%s/instruments", FacebookSdk.getApplicationId()), params, callback);
        request.executeAsync();
    }

    @Nullable
    public static File getInstrumentReportDir() {
        File cacheDir = FacebookSdk.getApplicationContext().getCacheDir();
        File dir = new File(cacheDir, INSTRUMENT_DIR);
        if (dir.exists() || dir.mkdirs()) {
            return dir;
        }
        return null;
    }
}

