/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppGateKeepersManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class FeatureManager {
    public static void checkFeature(final Feature feature, final Callback callback) {
        FetchedAppGateKeepersManager.loadAppGateKeepersAsync(new FetchedAppGateKeepersManager.Callback(){

            @Override
            public void onCompleted() {
                callback.onCompleted(FeatureManager.isEnabled(feature));
            }
        });
    }

    public static boolean isEnabled(Feature feature) {
        if (Feature.Unknown == feature) {
            return false;
        }
        if (Feature.Core == feature) {
            return true;
        }
        Feature parent = feature.getParent();
        if (parent == feature) {
            return FeatureManager.getGKStatus(feature);
        }
        return FeatureManager.isEnabled(parent) && FeatureManager.getGKStatus(feature);
    }

    private static boolean getGKStatus(Feature feature) {
        String key = "FBSDKFeature" + feature.toString();
        boolean defaultStatus = FeatureManager.defaultStatus(feature);
        return FetchedAppGateKeepersManager.getGateKeeperForKey(key, FacebookSdk.getApplicationId(), defaultStatus);
    }

    private static boolean defaultStatus(Feature feature) {
        switch (feature) {
            case RestrictiveDataFiltering: 
            case Instrument: 
            case CrashReport: 
            case ErrorReport: {
                return false;
            }
        }
        return true;
    }

    public static interface Callback {
        public void onCompleted(boolean var1);
    }

    public static enum Feature {
        Unknown(-1),
        Core(0),
        AppEvents(256),
        CodelessEvents(257),
        RestrictiveDataFiltering(258),
        Instrument(512),
        CrashReport(513),
        ErrorReport(514),
        Login(65536),
        Share(131072),
        Places(196608);

        private final int code;

        private Feature(int code) {
            this.code = code;
        }

        public String toString() {
            String name = "unknown";
            switch (this) {
                case Core: {
                    name = "CoreKit";
                    break;
                }
                case AppEvents: {
                    name = "AppEvents";
                    break;
                }
                case CodelessEvents: {
                    name = "CodelessEvents";
                    break;
                }
                case RestrictiveDataFiltering: {
                    name = "RestrictiveDataFiltering";
                    break;
                }
                case Instrument: {
                    name = "Instrument";
                    break;
                }
                case CrashReport: {
                    name = "CrashReport";
                    break;
                }
                case ErrorReport: {
                    name = "ErrorReport";
                    break;
                }
                case Login: {
                    name = "LoginKit";
                    break;
                }
                case Share: {
                    name = "ShareKit";
                    break;
                }
                case Places: {
                    name = "PlacesKit";
                }
            }
            return name;
        }

        static Feature fromInt(int code) {
            for (Feature feature : Feature.values()) {
                if (feature.code != code) continue;
                return feature;
            }
            return Unknown;
        }

        public Feature getParent() {
            if ((this.code & 0xFF) > 0) {
                return Feature.fromInt(this.code & 0xFFFF00);
            }
            if ((this.code & 0xFF00) > 0) {
                return Feature.fromInt(this.code & 0xFF0000);
            }
            return Feature.fromInt(0);
        }
    }
}

