/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import com.facebook.AccessToken;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.codeless.CodelessManager;
import com.facebook.appevents.codeless.internal.UnityReflection;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ViewIndexer {
    private static final String TAG = ViewIndexer.class.getCanonicalName();
    private static final String SUCCESS = "success";
    private static final String TREE_PARAM = "tree";
    private static final String APP_VERSION_PARAM = "app_version";
    private static final String PLATFORM_PARAM = "platform";
    private static final String REQUEST_TYPE = "request_type";
    private final Handler uiThreadHandler;
    private WeakReference<Activity> activityReference;
    private Timer indexingTimer;
    private String previousDigest;
    private static ViewIndexer instance;

    public ViewIndexer(Activity activity) {
        this.activityReference = new WeakReference<Activity>(activity);
        this.previousDigest = null;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        instance = this;
    }

    public void schedule() {
        final TimerTask indexingTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    Activity activity = (Activity)ViewIndexer.this.activityReference.get();
                    if (null == activity) {
                        return;
                    }
                    String activityName = activity.getClass().getSimpleName();
                    View rootView = activity.getWindow().getDecorView().getRootView();
                    if (!CodelessManager.getIsAppIndexingEnabled()) {
                        return;
                    }
                    if (InternalSettings.isUnityApp()) {
                        UnityReflection.captureViewHierarchy();
                        return;
                    }
                    FutureTask<String> screenshotFuture = new FutureTask<String>(new ScreenshotTaker(rootView));
                    ViewIndexer.this.uiThreadHandler.post(screenshotFuture);
                    String screenshot = "";
                    try {
                        screenshot = screenshotFuture.get(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Failed to take screenshot.", (Throwable)e);
                    }
                    JSONObject viewTree = new JSONObject();
                    try {
                        viewTree.put("screenname", (Object)activityName);
                        viewTree.put("screenshot", (Object)screenshot);
                        JSONArray viewArray = new JSONArray();
                        JSONObject rootViewInfo = ViewHierarchy.getDictionaryOfView(rootView);
                        viewArray.put((Object)rootViewInfo);
                        viewTree.put("view", (Object)viewArray);
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)"Failed to create JSONObject");
                    }
                    String tree = viewTree.toString();
                    ViewIndexer.this.sendToServer(tree);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"UI Component tree indexing failure!", (Throwable)e);
                }
            }
        };
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ViewIndexer.this.indexingTimer != null) {
                        ViewIndexer.this.indexingTimer.cancel();
                    }
                    ViewIndexer.this.previousDigest = null;
                    ViewIndexer.this.indexingTimer = new Timer();
                    ViewIndexer.this.indexingTimer.scheduleAtFixedRate(indexingTask, 0L, 1000L);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error scheduling indexing job", (Throwable)e);
                }
            }
        });
    }

    public void unschedule() {
        Activity activity = (Activity)this.activityReference.get();
        if (null == activity) {
            return;
        }
        if (this.indexingTimer != null) {
            try {
                this.indexingTimer.cancel();
                this.indexingTimer = null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error unscheduling indexing job", (Throwable)e);
            }
        }
    }

    public static void sendToServerUnityInstance(String tree) {
        if (null == instance) {
            return;
        }
        instance.sendToServerUnity(tree);
    }

    @Deprecated
    public void sendToServerUnity(String tree) {
        instance.sendToServer(tree);
    }

    private void sendToServer(final String tree) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String currentDigest = Utility.md5hash(tree);
                AccessToken accessToken = AccessToken.getCurrentAccessToken();
                if (currentDigest != null && currentDigest.equals(ViewIndexer.this.previousDigest)) {
                    return;
                }
                GraphRequest request = ViewIndexer.buildAppIndexingRequest(tree, accessToken, FacebookSdk.getApplicationId(), "app_indexing");
                if (request != null) {
                    GraphResponse res = request.executeAndWait();
                    try {
                        JSONObject jsonRes = res.getJSONObject();
                        if (jsonRes != null) {
                            if ("true".equals(jsonRes.optString(ViewIndexer.SUCCESS))) {
                                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Successfully send UI component tree to server");
                                ViewIndexer.this.previousDigest = currentDigest;
                            }
                            if (jsonRes.has("is_app_indexing_enabled")) {
                                Boolean appIndexingEnabled = jsonRes.getBoolean("is_app_indexing_enabled");
                                CodelessManager.updateAppIndexing(appIndexingEnabled);
                            }
                        } else {
                            Log.e((String)TAG, (String)("Error sending UI component tree to Facebook: " + res.getError()));
                        }
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)"Error decoding server response.", (Throwable)e);
                    }
                }
            }
        });
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static GraphRequest buildAppIndexingRequest(String appIndex, AccessToken accessToken, String appId, String requestType) {
        if (appIndex == null) {
            return null;
        }
        GraphRequest postRequest = GraphRequest.newPostRequest(accessToken, String.format(Locale.US, "%s/app_indexing", appId), null, null);
        Bundle requestParameters = postRequest.getParameters();
        if (requestParameters == null) {
            requestParameters = new Bundle();
        }
        requestParameters.putString(TREE_PARAM, appIndex);
        requestParameters.putString(APP_VERSION_PARAM, AppEventUtility.getAppVersion());
        requestParameters.putString(PLATFORM_PARAM, "android");
        requestParameters.putString(REQUEST_TYPE, requestType);
        if (requestType.equals("app_indexing")) {
            requestParameters.putString("device_session_id", CodelessManager.getCurrentDeviceSessionID());
        }
        postRequest.setParameters(requestParameters);
        postRequest.setCallback(new GraphRequest.Callback(){

            @Override
            public void onCompleted(GraphResponse response) {
                Logger.log(LoggingBehavior.APP_EVENTS, TAG, "App index sent to FB!");
            }
        });
        return postRequest;
    }

    private static class ScreenshotTaker
    implements Callable<String> {
        private WeakReference<View> rootView;

        ScreenshotTaker(View rootView) {
            this.rootView = new WeakReference<View>(rootView);
        }

        @Override
        public String call() {
            View view = (View)this.rootView.get();
            if (view == null || view.getWidth() == 0 || view.getHeight() == 0) {
                return "";
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.draw(canvas);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 10, (OutputStream)outputStream);
            return Base64.encodeToString((byte[])outputStream.toByteArray(), (int)2);
        }
    }
}

