/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.ViewIndexer;
import com.facebook.appevents.codeless.ViewIndexingTrigger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FeatureManager;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CodelessManager {
    private static CodelessMatcher matcher;
    private static final ViewIndexingTrigger viewIndexingTrigger;
    private static SensorManager sensorManager;
    private static ViewIndexer viewIndexer;
    @Nullable
    private static String deviceSessionID;
    private static Boolean isAppIndexingEnabled;
    private static volatile Boolean isCheckingSession;

    public static void onActivityResumed(final Activity activity) {
        FeatureManager.checkFeature(FeatureManager.Feature.CodelessEvents, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (!enabled) {
                    return;
                }
                CodelessManager.getMatcher().add(activity);
                Context applicationContext = activity.getApplicationContext();
                final String appId = FacebookSdk.getApplicationId();
                final FetchedAppSettings appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
                if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                    sensorManager = (SensorManager)applicationContext.getSystemService("sensor");
                    if (sensorManager == null) {
                        return;
                    }
                    Sensor accelerometer = sensorManager.getDefaultSensor(1);
                    viewIndexer = new ViewIndexer(activity);
                    viewIndexingTrigger.setOnShakeListener(new ViewIndexingTrigger.OnShakeListener(){

                        @Override
                        public void onShake() {
                            boolean codelessSetupEnabled;
                            boolean codelessEventsEnabled;
                            boolean bl = codelessEventsEnabled = appSettings != null && appSettings.getCodelessEventsEnabled();
                            boolean bl2 = FacebookSdk.getCodelessSetupEnabled() ? true : (codelessSetupEnabled = false);
                            if (codelessEventsEnabled && codelessSetupEnabled) {
                                CodelessManager.checkCodelessSession(appId);
                            }
                        }
                    });
                    sensorManager.registerListener((SensorEventListener)viewIndexingTrigger, accelerometer, 2);
                    if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                        viewIndexer.schedule();
                    }
                }
            }
        });
    }

    public static void onActivityPaused(final Activity activity) {
        FeatureManager.checkFeature(FeatureManager.Feature.CodelessEvents, new FeatureManager.Callback(){

            @Override
            public void onCompleted(boolean enabled) {
                if (!enabled) {
                    return;
                }
                CodelessManager.getMatcher().remove(activity);
                if (null != viewIndexer) {
                    viewIndexer.unschedule();
                }
                if (null != sensorManager) {
                    sensorManager.unregisterListener((SensorEventListener)viewIndexingTrigger);
                }
            }
        });
    }

    private static synchronized CodelessMatcher getMatcher() {
        if (matcher == null) {
            matcher = new CodelessMatcher();
        }
        return matcher;
    }

    public static void checkCodelessSession(final String applicationId) {
        if (isCheckingSession.booleanValue()) {
            return;
        }
        isCheckingSession = true;
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                GraphRequest request = GraphRequest.newPostRequest(null, String.format(Locale.US, "%s/app_indexing_session", applicationId), null, null);
                Bundle requestParameters = request.getParameters();
                if (requestParameters == null) {
                    requestParameters = new Bundle();
                }
                Context context = FacebookSdk.getApplicationContext();
                AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
                JSONArray extInfoArray = new JSONArray();
                extInfoArray.put((Object)(Build.MODEL != null ? Build.MODEL : ""));
                if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                    extInfoArray.put((Object)identifiers.getAndroidAdvertiserId());
                } else {
                    extInfoArray.put((Object)"");
                }
                extInfoArray.put((Object)"0");
                extInfoArray.put((Object)(AppEventUtility.isEmulator() ? "1" : "0"));
                Locale locale = Utility.getCurrentLocale();
                extInfoArray.put((Object)(locale.getLanguage() + "_" + locale.getCountry()));
                String extInfo = extInfoArray.toString();
                requestParameters.putString("device_session_id", CodelessManager.getCurrentDeviceSessionID());
                requestParameters.putString("extinfo", extInfo);
                request.setParameters(requestParameters);
                if (request != null) {
                    GraphResponse res = request.executeAndWait();
                    JSONObject jsonRes = res.getJSONObject();
                    isAppIndexingEnabled = jsonRes != null && jsonRes.optBoolean("is_app_indexing_enabled", false);
                    if (!isAppIndexingEnabled.booleanValue()) {
                        deviceSessionID = null;
                    } else {
                        viewIndexer.schedule();
                    }
                }
                isCheckingSession = false;
            }
        });
    }

    public static String getCurrentDeviceSessionID() {
        if (null == deviceSessionID) {
            deviceSessionID = UUID.randomUUID().toString();
        }
        return deviceSessionID;
    }

    public static boolean getIsAppIndexingEnabled() {
        return isAppIndexingEnabled;
    }

    public static void updateAppIndexing(Boolean appIndexingEnalbed) {
        isAppIndexingEnabled = appIndexingEnalbed;
    }

    static {
        viewIndexingTrigger = new ViewIndexingTrigger();
        deviceSessionID = null;
        isAppIndexingEnabled = false;
        isCheckingSession = false;
    }
}

