/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.Patterns;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.Utility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class UserDataStore {
    private static final String TAG = UserDataStore.class.getSimpleName();
    private static final String USER_DATA_KEY = "com.facebook.appevents.UserDataStore.userData";
    private static ConcurrentHashMap<String, String> hashedUserData;
    private static SharedPreferences sharedPreferences;
    private static AtomicBoolean initialized;
    public static final String EMAIL = "em";
    public static final String FIRST_NAME = "fn";
    public static final String LAST_NAME = "ln";
    public static final String PHONE = "ph";
    public static final String DATE_OF_BIRTH = "db";
    public static final String GENDER = "ge";
    public static final String CITY = "ct";
    public static final String STATE = "st";
    public static final String ZIP = "zp";
    public static final String COUNTRY = "country";

    static void initStore() {
        if (initialized.get()) {
            return;
        }
        UserDataStore.initAndWait();
    }

    static void setUserDataAndHash(final Bundle ud) {
        InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!initialized.get()) {
                    Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
                    UserDataStore.initAndWait();
                }
                UserDataStore.updateHashUserData(ud);
                sharedPreferences.edit().putString(UserDataStore.USER_DATA_KEY, UserDataStore.mapToJsonStr(hashedUserData)).apply();
            }
        });
    }

    static void setUserDataAndHash(@Nullable String email, @Nullable String firstName, @Nullable String lastName, @Nullable String phone, @Nullable String dateOfBirth, @Nullable String gender, @Nullable String city, @Nullable String state, @Nullable String zip, @Nullable String country) {
        Bundle ud = new Bundle();
        if (email != null) {
            ud.putString(EMAIL, email);
        }
        if (firstName != null) {
            ud.putString(FIRST_NAME, firstName);
        }
        if (lastName != null) {
            ud.putString(LAST_NAME, lastName);
        }
        if (phone != null) {
            ud.putString(PHONE, phone);
        }
        if (dateOfBirth != null) {
            ud.putString(DATE_OF_BIRTH, dateOfBirth);
        }
        if (gender != null) {
            ud.putString(GENDER, gender);
        }
        if (city != null) {
            ud.putString(CITY, city);
        }
        if (state != null) {
            ud.putString(STATE, state);
        }
        if (zip != null) {
            ud.putString(ZIP, zip);
        }
        if (country != null) {
            ud.putString(COUNTRY, country);
        }
        UserDataStore.setUserDataAndHash(ud);
    }

    static void clear() {
        InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!initialized.get()) {
                    Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
                    UserDataStore.initAndWait();
                }
                hashedUserData.clear();
                sharedPreferences.edit().putString(UserDataStore.USER_DATA_KEY, null).apply();
            }
        });
    }

    static String getHashedUserData() {
        if (!initialized.get()) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            UserDataStore.initAndWait();
        }
        return UserDataStore.mapToJsonStr(hashedUserData);
    }

    private static synchronized void initAndWait() {
        if (initialized.get()) {
            return;
        }
        sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
        String udRaw = sharedPreferences.getString(USER_DATA_KEY, "");
        hashedUserData = new ConcurrentHashMap<String, String>(UserDataStore.JsonStrToMap(udRaw));
        initialized.set(true);
    }

    private static void updateHashUserData(Bundle ud) {
        if (ud == null) {
            return;
        }
        for (String key : ud.keySet()) {
            Object rawVal = ud.get(key);
            if (rawVal == null) continue;
            String value = rawVal.toString();
            if (UserDataStore.maybeSHA256Hashed(value)) {
                hashedUserData.put(key, value.toLowerCase());
                continue;
            }
            String encryptedValue = Utility.sha256hash(UserDataStore.normalizeData(key, value));
            if (encryptedValue == null) continue;
            hashedUserData.put(key, encryptedValue);
        }
    }

    private static String normalizeData(String type, String data) {
        data = data.trim().toLowerCase();
        if (EMAIL.equals(type)) {
            if (Patterns.EMAIL_ADDRESS.matcher(data).matches()) {
                return data;
            }
            Log.e((String)TAG, (String)"Setting email failure: this is not a valid email address");
            return "";
        }
        if (PHONE.equals(type)) {
            return data.replaceAll("[^0-9]", "");
        }
        if (GENDER.equals(type)) {
            String string = data = data.length() > 0 ? data.substring(0, 1) : "";
            if ("f".equals(data) || "m".equals(data)) {
                return data;
            }
            Log.e((String)TAG, (String)"Setting gender failure: the supported value for gender is f or m");
            return "";
        }
        return data;
    }

    private static boolean maybeSHA256Hashed(String data) {
        return data.matches("[A-Fa-f0-9]{64}");
    }

    private static String mapToJsonStr(Map<String, String> map) {
        if (map.isEmpty()) {
            return "";
        }
        try {
            JSONObject jsonObject = new JSONObject();
            for (String key : map.keySet()) {
                jsonObject.put(key, (Object)map.get(key));
            }
            return jsonObject.toString();
        }
        catch (JSONException _e) {
            return "";
        }
    }

    private static Map<String, String> JsonStrToMap(String str) {
        if (str.isEmpty()) {
            return new HashMap<String, String>();
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            JSONObject jsonObject = new JSONObject(str);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                map.put(key, jsonObject.getString(key));
            }
            return map;
        }
        catch (JSONException _e) {
            return new HashMap<String, String>();
        }
    }

    static {
        initialized = new AtomicBoolean(false);
    }
}

