/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless.internal;

import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.Patterns;
import android.view.View;
import android.widget.TextView;
import com.facebook.appevents.codeless.internal.ViewHierarchy;

public class SensitiveUserDataUtils {
    public static boolean isSensitiveUserData(View view) {
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            return SensitiveUserDataUtils.isPassword(textView) || SensitiveUserDataUtils.isCreditCard(textView) || SensitiveUserDataUtils.isPersonName(textView) || SensitiveUserDataUtils.isPostalAddress(textView) || SensitiveUserDataUtils.isPhoneNumber(textView) || SensitiveUserDataUtils.isEmail(textView);
        }
        return false;
    }

    private static boolean isPassword(TextView view) {
        int inputType = view.getInputType();
        if (inputType == 128) {
            return true;
        }
        TransformationMethod method = view.getTransformationMethod();
        return method instanceof PasswordTransformationMethod;
    }

    private static boolean isEmail(TextView view) {
        int inputType = view.getInputType();
        if (inputType == 32) {
            return true;
        }
        String text = ViewHierarchy.getTextOfView((View)view);
        if (text == null || text.length() == 0) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(text).matches();
    }

    private static boolean isPersonName(TextView view) {
        int inputType = view.getInputType();
        return inputType == 96;
    }

    private static boolean isPostalAddress(TextView view) {
        int inputType = view.getInputType();
        return inputType == 112;
    }

    private static boolean isPhoneNumber(TextView view) {
        int inputType = view.getInputType();
        return inputType == 3;
    }

    private static boolean isCreditCard(TextView view) {
        String ccNumber = ViewHierarchy.getTextOfView((View)view).replaceAll("\\s", "");
        int length = ccNumber.length();
        if (length < 12 || length > 19) {
            return false;
        }
        int sum = 0;
        boolean alternate = false;
        for (int i = length - 1; i >= 0; --i) {
            char digit = ccNumber.charAt(i);
            if (digit < '0' || digit > '9') {
                return false;
            }
            int n = digit - 48;
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }
}

