/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RestrictiveDataManager {
    private static final String TAG = RestrictiveDataManager.class.getCanonicalName();
    private static List<RestrictiveRule> restrictiveRules = new ArrayList<RestrictiveRule>();
    private static List<RestrictiveParam> restrictiveParams = new ArrayList<RestrictiveParam>();
    private static Set<String> restrictiveEvents = new HashSet<String>();

    public static void updateFromSetting(@NonNull String ruleResponse, @NonNull String eventFilterResponse) {
        try {
            if (!ruleResponse.isEmpty()) {
                JSONArray jsonArray = new JSONArray(ruleResponse);
                restrictiveRules.clear();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject object = jsonArray.getJSONObject(i);
                    String keyRegex = object.optString("key_regex");
                    String valRagex = object.optString("value_regex");
                    String valNegRagex = object.optString("value_negative_regex");
                    String type = object.optString("type");
                    if (Utility.isNullOrEmpty(keyRegex) && Utility.isNullOrEmpty(valRagex) && Utility.isNullOrEmpty(valNegRagex)) continue;
                    restrictiveRules.add(new RestrictiveRule(keyRegex, valRagex, valNegRagex, type));
                }
            }
            if (!eventFilterResponse.isEmpty()) {
                JSONObject jsonObject = new JSONObject(eventFilterResponse);
                restrictiveParams.clear();
                restrictiveEvents.clear();
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject json = jsonObject.getJSONObject(key);
                    if (json == null) continue;
                    if (json.optBoolean("is_deprecated_event")) {
                        restrictiveEvents.add(key);
                        continue;
                    }
                    JSONObject paramJson = jsonObject.getJSONObject(key).optJSONObject("restrictive_param");
                    if (paramJson == null) continue;
                    restrictiveParams.add(new RestrictiveParam(key, Utility.convertJSONObjectToStringMap(paramJson)));
                }
            }
        }
        catch (JSONException je) {
            Log.w((String)TAG, (String)"updateRulesFromSetting failed", (Throwable)je);
        }
    }

    static boolean isDeprecatedEvent(String eventName) {
        return restrictiveEvents.contains(eventName);
    }

    @Nullable
    static String getMatchedRuleType(@NonNull String eventName, @NonNull String paramKey, @NonNull String paramVal) {
        ArrayList<RestrictiveParam> restrictiveParamsCopy = new ArrayList<RestrictiveParam>(restrictiveParams);
        for (RestrictiveParam filter : restrictiveParamsCopy) {
            if (filter == null || !eventName.equals(filter.eventName)) continue;
            for (String param : filter.params.keySet()) {
                if (!paramKey.equals(param)) continue;
                return filter.params.get(param);
            }
        }
        ArrayList<RestrictiveRule> restrictiveRulesCopy = new ArrayList<RestrictiveRule>(restrictiveRules);
        for (RestrictiveRule rule : restrictiveRulesCopy) {
            if (rule == null || !Utility.isNullOrEmpty(rule.keyRegex) && !paramKey.matches(rule.keyRegex) || !Utility.isNullOrEmpty(rule.valNegRegex) && paramVal.matches(rule.valNegRegex) || !Utility.isNullOrEmpty(rule.valRegex) && !paramVal.matches(rule.valRegex)) continue;
            return rule.type;
        }
        return null;
    }

    static class RestrictiveParam {
        String eventName;
        Map<String, String> params;

        RestrictiveParam(String eventName, Map<String, String> params) {
            this.eventName = eventName;
            this.params = params;
        }
    }

    static class RestrictiveRule {
        String keyRegex;
        String valRegex;
        String valNegRegex;
        String type;

        RestrictiveRule(String keyRegex, String valRegex, String valNegRegex, String type) {
            this.keyRegex = keyRegex;
            this.valRegex = valRegex;
            this.valNegRegex = valNegRegex;
            this.type = type;
        }
    }
}

