/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.facebook.AccessTokenManager;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.LegacyTokenHelper;
import com.facebook.LoggingBehavior;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AccessToken
implements Parcelable {
    public static final String ACCESS_TOKEN_KEY = "access_token";
    public static final String EXPIRES_IN_KEY = "expires_in";
    public static final String USER_ID_KEY = "user_id";
    public static final String DATA_ACCESS_EXPIRATION_TIME = "data_access_expiration_time";
    private static final Date MAX_DATE;
    private static final Date DEFAULT_EXPIRATION_TIME;
    private static final Date DEFAULT_LAST_REFRESH_TIME;
    private static final AccessTokenSource DEFAULT_ACCESS_TOKEN_SOURCE;
    private static final int CURRENT_JSON_FORMAT = 1;
    private static final String VERSION_KEY = "version";
    private static final String EXPIRES_AT_KEY = "expires_at";
    private static final String PERMISSIONS_KEY = "permissions";
    private static final String DECLINED_PERMISSIONS_KEY = "declined_permissions";
    private static final String EXPIRED_PERMISSIONS_KEY = "expired_permissions";
    private static final String TOKEN_KEY = "token";
    private static final String SOURCE_KEY = "source";
    private static final String LAST_REFRESH_KEY = "last_refresh";
    private static final String APPLICATION_ID_KEY = "application_id";
    private final Date expires;
    private final Set<String> permissions;
    private final Set<String> declinedPermissions;
    private final Set<String> expiredPermissions;
    private final String token;
    private final AccessTokenSource source;
    private final Date lastRefresh;
    private final String applicationId;
    private final String userId;
    private final Date dataAccessExpirationTime;
    public static final Parcelable.Creator<AccessToken> CREATOR;

    public AccessToken(String accessToken, String applicationId, String userId, @Nullable Collection<String> permissions, @Nullable Collection<String> declinedPermissions, @Nullable Collection<String> expiredPermissions, @Nullable AccessTokenSource accessTokenSource, @Nullable Date expirationTime, @Nullable Date lastRefreshTime, @Nullable Date dataAccessExpirationTime) {
        Validate.notNullOrEmpty(accessToken, "accessToken");
        Validate.notNullOrEmpty(applicationId, "applicationId");
        Validate.notNullOrEmpty(userId, "userId");
        this.expires = expirationTime != null ? expirationTime : DEFAULT_EXPIRATION_TIME;
        this.permissions = Collections.unmodifiableSet(permissions != null ? new HashSet<String>(permissions) : new HashSet());
        this.declinedPermissions = Collections.unmodifiableSet(declinedPermissions != null ? new HashSet<String>(declinedPermissions) : new HashSet());
        this.expiredPermissions = Collections.unmodifiableSet(expiredPermissions != null ? new HashSet<String>(expiredPermissions) : new HashSet());
        this.token = accessToken;
        this.source = accessTokenSource != null ? accessTokenSource : DEFAULT_ACCESS_TOKEN_SOURCE;
        this.lastRefresh = lastRefreshTime != null ? lastRefreshTime : DEFAULT_LAST_REFRESH_TIME;
        this.applicationId = applicationId;
        this.userId = userId;
        this.dataAccessExpirationTime = dataAccessExpirationTime != null && dataAccessExpirationTime.getTime() != 0L ? dataAccessExpirationTime : DEFAULT_EXPIRATION_TIME;
    }

    public static AccessToken getCurrentAccessToken() {
        return AccessTokenManager.getInstance().getCurrentAccessToken();
    }

    public static boolean isCurrentAccessTokenActive() {
        AccessToken accessToken = AccessTokenManager.getInstance().getCurrentAccessToken();
        return accessToken != null && !accessToken.isExpired();
    }

    public static boolean isDataAccessActive() {
        AccessToken accessToken = AccessTokenManager.getInstance().getCurrentAccessToken();
        return accessToken != null && !accessToken.isDataAccessExpired();
    }

    static void expireCurrentAccessToken() {
        AccessToken accessToken = AccessTokenManager.getInstance().getCurrentAccessToken();
        if (accessToken != null) {
            AccessToken.setCurrentAccessToken(AccessToken.createExpired(accessToken));
        }
    }

    public static void setCurrentAccessToken(AccessToken accessToken) {
        AccessTokenManager.getInstance().setCurrentAccessToken(accessToken);
    }

    public static void refreshCurrentAccessTokenAsync() {
        AccessTokenManager.getInstance().refreshCurrentAccessToken(null);
    }

    public static void refreshCurrentAccessTokenAsync(AccessTokenRefreshCallback callback) {
        AccessTokenManager.getInstance().refreshCurrentAccessToken(callback);
    }

    public String getToken() {
        return this.token;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Date getDataAccessExpirationTime() {
        return this.dataAccessExpirationTime;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public Set<String> getDeclinedPermissions() {
        return this.declinedPermissions;
    }

    public Set<String> getExpiredPermissions() {
        return this.expiredPermissions;
    }

    public AccessTokenSource getSource() {
        return this.source;
    }

    public Date getLastRefresh() {
        return this.lastRefresh;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getUserId() {
        return this.userId;
    }

    public static void createFromNativeLinkingIntent(Intent intent, final String applicationId, final AccessTokenCreationCallback accessTokenCallback) {
        Validate.notNull(intent, "intent");
        if (intent.getExtras() == null) {
            accessTokenCallback.onError(new FacebookException("No extras found on intent"));
            return;
        }
        final Bundle extras = new Bundle(intent.getExtras());
        String accessToken = extras.getString(ACCESS_TOKEN_KEY);
        if (accessToken == null || accessToken.isEmpty()) {
            accessTokenCallback.onError(new FacebookException("No access token found on intent"));
            return;
        }
        String userId = extras.getString(USER_ID_KEY);
        if (userId == null || userId.isEmpty()) {
            Utility.getGraphMeRequestWithCacheAsync(accessToken, new Utility.GraphMeRequestWithCacheCallback(){

                @Override
                public void onSuccess(JSONObject userInfo) {
                    try {
                        String userId = userInfo.getString("id");
                        extras.putString(AccessToken.USER_ID_KEY, userId);
                        accessTokenCallback.onSuccess(AccessToken.createFromBundle(null, extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB, new Date(), applicationId));
                    }
                    catch (JSONException ex) {
                        accessTokenCallback.onError(new FacebookException("Unable to generate access token due to missing user id"));
                    }
                }

                @Override
                public void onFailure(FacebookException error) {
                    accessTokenCallback.onError(error);
                }
            });
        } else {
            accessTokenCallback.onSuccess(AccessToken.createFromBundle(null, extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB, new Date(), applicationId));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{AccessToken");
        builder.append(" token:").append(this.tokenToString());
        this.appendPermissions(builder);
        builder.append("}");
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AccessToken)) {
            return false;
        }
        AccessToken o = (AccessToken)other;
        return this.expires.equals(o.expires) && this.permissions.equals(o.permissions) && this.declinedPermissions.equals(o.declinedPermissions) && this.expiredPermissions.equals(o.expiredPermissions) && this.token.equals(o.token) && this.source == o.source && this.lastRefresh.equals(o.lastRefresh) && (this.applicationId == null ? o.applicationId == null : this.applicationId.equals(o.applicationId)) && this.userId.equals(o.userId) && this.dataAccessExpirationTime.equals(o.dataAccessExpirationTime);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.expires.hashCode();
        result = result * 31 + this.permissions.hashCode();
        result = result * 31 + this.declinedPermissions.hashCode();
        result = result * 31 + this.expiredPermissions.hashCode();
        result = result * 31 + this.token.hashCode();
        result = result * 31 + this.source.hashCode();
        result = result * 31 + this.lastRefresh.hashCode();
        result = result * 31 + (this.applicationId == null ? 0 : this.applicationId.hashCode());
        result = result * 31 + this.userId.hashCode();
        result = result * 31 + this.dataAccessExpirationTime.hashCode();
        return result;
    }

    @SuppressLint(value={"FieldGetter"})
    static AccessToken createFromRefresh(AccessToken current, Bundle bundle) {
        if (current.source != AccessTokenSource.FACEBOOK_APPLICATION_WEB && current.source != AccessTokenSource.FACEBOOK_APPLICATION_NATIVE && current.source != AccessTokenSource.FACEBOOK_APPLICATION_SERVICE) {
            throw new FacebookException("Invalid token source: " + (Object)((Object)current.source));
        }
        Date expires = Utility.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, new Date(0L));
        String token = bundle.getString(ACCESS_TOKEN_KEY);
        Date dataAccessExpirationTime = Utility.getBundleLongAsDate(bundle, DATA_ACCESS_EXPIRATION_TIME, new Date(0L));
        if (Utility.isNullOrEmpty(token)) {
            return null;
        }
        return new AccessToken(token, current.applicationId, current.getUserId(), current.getPermissions(), current.getDeclinedPermissions(), current.getExpiredPermissions(), current.source, expires, new Date(), dataAccessExpirationTime);
    }

    static AccessToken createExpired(AccessToken current) {
        return new AccessToken(current.token, current.applicationId, current.getUserId(), current.getPermissions(), current.getDeclinedPermissions(), current.getExpiredPermissions(), current.source, new Date(), new Date(), current.dataAccessExpirationTime);
    }

    static AccessToken createFromLegacyCache(Bundle bundle) {
        String userId;
        List<String> permissions = AccessToken.getPermissionsFromBundle(bundle, "com.facebook.TokenCachingStrategy.Permissions");
        List<String> declinedPermissions = AccessToken.getPermissionsFromBundle(bundle, "com.facebook.TokenCachingStrategy.DeclinedPermissions");
        List<String> expiredPermissions = AccessToken.getPermissionsFromBundle(bundle, "com.facebook.TokenCachingStrategy.ExpiredPermissions");
        String applicationId = LegacyTokenHelper.getApplicationId(bundle);
        if (Utility.isNullOrEmpty(applicationId)) {
            applicationId = FacebookSdk.getApplicationId();
        }
        String tokenString = LegacyTokenHelper.getToken(bundle);
        JSONObject userInfo = Utility.awaitGetGraphMeRequestWithCache(tokenString);
        try {
            userId = userInfo.getString("id");
        }
        catch (JSONException ex) {
            return null;
        }
        return new AccessToken(tokenString, applicationId, userId, permissions, declinedPermissions, expiredPermissions, LegacyTokenHelper.getSource(bundle), LegacyTokenHelper.getDate(bundle, "com.facebook.TokenCachingStrategy.ExpirationDate"), LegacyTokenHelper.getDate(bundle, "com.facebook.TokenCachingStrategy.LastRefreshDate"), null);
    }

    static List<String> getPermissionsFromBundle(Bundle bundle, String key) {
        ArrayList originalPermissions = bundle.getStringArrayList(key);
        List<String> permissions = originalPermissions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(originalPermissions));
        return permissions;
    }

    public boolean isExpired() {
        return new Date().after(this.expires);
    }

    public boolean isDataAccessExpired() {
        return new Date().after(this.dataAccessExpirationTime);
    }

    JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(VERSION_KEY, 1);
        jsonObject.put(TOKEN_KEY, (Object)this.token);
        jsonObject.put(EXPIRES_AT_KEY, this.expires.getTime());
        JSONArray permissionsArray = new JSONArray(this.permissions);
        jsonObject.put(PERMISSIONS_KEY, (Object)permissionsArray);
        JSONArray declinedPermissionsArray = new JSONArray(this.declinedPermissions);
        jsonObject.put(DECLINED_PERMISSIONS_KEY, (Object)declinedPermissionsArray);
        JSONArray expiredPermissionsArray = new JSONArray(this.expiredPermissions);
        jsonObject.put(EXPIRED_PERMISSIONS_KEY, (Object)expiredPermissionsArray);
        jsonObject.put(LAST_REFRESH_KEY, this.lastRefresh.getTime());
        jsonObject.put(SOURCE_KEY, (Object)this.source.name());
        jsonObject.put(APPLICATION_ID_KEY, (Object)this.applicationId);
        jsonObject.put(USER_ID_KEY, (Object)this.userId);
        jsonObject.put(DATA_ACCESS_EXPIRATION_TIME, this.dataAccessExpirationTime.getTime());
        return jsonObject;
    }

    static AccessToken createFromJSONObject(JSONObject jsonObject) throws JSONException {
        int version = jsonObject.getInt(VERSION_KEY);
        if (version > 1) {
            throw new FacebookException("Unknown AccessToken serialization format.");
        }
        String token = jsonObject.getString(TOKEN_KEY);
        Date expiresAt = new Date(jsonObject.getLong(EXPIRES_AT_KEY));
        JSONArray permissionsArray = jsonObject.getJSONArray(PERMISSIONS_KEY);
        JSONArray declinedPermissionsArray = jsonObject.getJSONArray(DECLINED_PERMISSIONS_KEY);
        JSONArray expiredPermissionsArray = jsonObject.optJSONArray(EXPIRED_PERMISSIONS_KEY);
        Date lastRefresh = new Date(jsonObject.getLong(LAST_REFRESH_KEY));
        AccessTokenSource source = AccessTokenSource.valueOf(jsonObject.getString(SOURCE_KEY));
        String applicationId = jsonObject.getString(APPLICATION_ID_KEY);
        String userId = jsonObject.getString(USER_ID_KEY);
        Date dataAccessExpirationTime = new Date(jsonObject.optLong(DATA_ACCESS_EXPIRATION_TIME, 0L));
        return new AccessToken(token, applicationId, userId, Utility.jsonArrayToStringList(permissionsArray), Utility.jsonArrayToStringList(declinedPermissionsArray), expiredPermissionsArray == null ? new ArrayList() : Utility.jsonArrayToStringList(expiredPermissionsArray), source, expiresAt, lastRefresh, dataAccessExpirationTime);
    }

    private static AccessToken createFromBundle(List<String> requestedPermissions, Bundle bundle, AccessTokenSource source, Date expirationBase, String applicationId) {
        String token = bundle.getString(ACCESS_TOKEN_KEY);
        Date expires = Utility.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, expirationBase);
        String userId = bundle.getString(USER_ID_KEY);
        Date dataAccessExpirationTime = Utility.getBundleLongAsDate(bundle, DATA_ACCESS_EXPIRATION_TIME, new Date(0L));
        if (Utility.isNullOrEmpty(token) || expires == null) {
            return null;
        }
        return new AccessToken(token, applicationId, userId, requestedPermissions, null, null, source, expires, new Date(), dataAccessExpirationTime);
    }

    private String tokenToString() {
        if (this.token == null) {
            return "null";
        }
        if (FacebookSdk.isLoggingBehaviorEnabled(LoggingBehavior.INCLUDE_ACCESS_TOKENS)) {
            return this.token;
        }
        return "ACCESS_TOKEN_REMOVED";
    }

    private void appendPermissions(StringBuilder builder) {
        builder.append(" permissions:");
        if (this.permissions == null) {
            builder.append("null");
        } else {
            builder.append("[");
            builder.append(TextUtils.join((CharSequence)", ", this.permissions));
            builder.append("]");
        }
    }

    AccessToken(Parcel parcel) {
        this.expires = new Date(parcel.readLong());
        ArrayList permissionsList = new ArrayList();
        parcel.readStringList(permissionsList);
        this.permissions = Collections.unmodifiableSet(new HashSet(permissionsList));
        permissionsList.clear();
        parcel.readStringList(permissionsList);
        this.declinedPermissions = Collections.unmodifiableSet(new HashSet(permissionsList));
        permissionsList.clear();
        parcel.readStringList(permissionsList);
        this.expiredPermissions = Collections.unmodifiableSet(new HashSet(permissionsList));
        this.token = parcel.readString();
        this.source = AccessTokenSource.valueOf(parcel.readString());
        this.lastRefresh = new Date(parcel.readLong());
        this.applicationId = parcel.readString();
        this.userId = parcel.readString();
        this.dataAccessExpirationTime = new Date(parcel.readLong());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.expires.getTime());
        dest.writeStringList(new ArrayList<String>(this.permissions));
        dest.writeStringList(new ArrayList<String>(this.declinedPermissions));
        dest.writeStringList(new ArrayList<String>(this.expiredPermissions));
        dest.writeString(this.token);
        dest.writeString(this.source.name());
        dest.writeLong(this.lastRefresh.getTime());
        dest.writeString(this.applicationId);
        dest.writeString(this.userId);
        dest.writeLong(this.dataAccessExpirationTime.getTime());
    }

    static {
        DEFAULT_EXPIRATION_TIME = MAX_DATE = new Date(Long.MAX_VALUE);
        DEFAULT_LAST_REFRESH_TIME = new Date();
        DEFAULT_ACCESS_TOKEN_SOURCE = AccessTokenSource.FACEBOOK_APPLICATION_WEB;
        CREATOR = new Parcelable.Creator(){

            public AccessToken createFromParcel(Parcel source) {
                return new AccessToken(source);
            }

            public AccessToken[] newArray(int size) {
                return new AccessToken[size];
            }
        };
    }

    public static interface AccessTokenCreationCallback {
        public void onSuccess(AccessToken var1);

        public void onError(FacebookException var1);
    }

    public static interface AccessTokenRefreshCallback {
        public void OnTokenRefreshed(AccessToken var1);

        public void OnTokenRefreshFailed(FacebookException var1);
    }
}

