/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.restrictivedatafilter;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RestrictiveDataManager {
    private static boolean enabled = false;
    private static final String TAG = RestrictiveDataManager.class.getCanonicalName();
    private static final List<RestrictiveParamFilter> restrictiveParamFilters = new ArrayList<RestrictiveParamFilter>();

    public static void enable() {
        enabled = true;
        RestrictiveDataManager.initialize();
    }

    private static void initialize() {
        try {
            FetchedAppSettings settings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
            if (settings == null) {
                return;
            }
            String eventFilterResponse = settings.getRestrictiveDataSetting();
            if (eventFilterResponse == null) {
                return;
            }
            if (!eventFilterResponse.isEmpty()) {
                JSONObject jsonObject = new JSONObject(eventFilterResponse);
                restrictiveParamFilters.clear();
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONObject json = jsonObject.getJSONObject(key);
                    if (json == null) continue;
                    JSONObject restrictiveParamJson = json.optJSONObject("restrictive_param");
                    RestrictiveParamFilter restrictiveParamFilter = new RestrictiveParamFilter(key, new HashMap<String, String>());
                    if (restrictiveParamJson == null) continue;
                    restrictiveParamFilter.restrictiveParams = Utility.convertJSONObjectToStringMap(restrictiveParamJson);
                    restrictiveParamFilters.add(restrictiveParamFilter);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processParameters(Map<String, String> parameters, String eventName) {
        if (!enabled) {
            return;
        }
        HashMap<String, String> restrictedParams = new HashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        for (String key : keys) {
            String type = RestrictiveDataManager.getMatchedRuleType(eventName, key);
            if (type == null) continue;
            restrictedParams.put(key, type);
            parameters.remove(key);
        }
        if (restrictedParams.size() > 0) {
            try {
                JSONObject restrictedJSON = new JSONObject();
                for (Map.Entry entry : restrictedParams.entrySet()) {
                    restrictedJSON.put((String)entry.getKey(), entry.getValue());
                }
                parameters.put("_restrictedParams", restrictedJSON.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Nullable
    private static String getMatchedRuleType(String eventName, String paramKey) {
        try {
            ArrayList<RestrictiveParamFilter> restrictiveParamFiltersCopy = new ArrayList<RestrictiveParamFilter>(restrictiveParamFilters);
            for (RestrictiveParamFilter filter : restrictiveParamFiltersCopy) {
                if (filter == null || !eventName.equals(filter.eventName)) continue;
                for (String param : filter.restrictiveParams.keySet()) {
                    if (!paramKey.equals(param)) continue;
                    return filter.restrictiveParams.get(param);
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"getMatchedRuleType failed", (Throwable)e);
        }
        return null;
    }

    static class RestrictiveParamFilter {
        String eventName;
        Map<String, String> restrictiveParams;

        RestrictiveParamFilter(String eventName, Map<String, String> restrictiveParams) {
            this.eventName = eventName;
            this.restrictiveParams = restrictiveParams;
        }
    }
}

