/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.restrictivedatafilter;

import com.facebook.FacebookSdk;
import com.facebook.appevents.ml.ModelManager;
import com.facebook.internal.FetchedAppGateKeepersManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.json.JSONObject;

public final class AddressFilterManager {
    private static boolean enabled = false;
    private static boolean isSampleEnabled = false;

    public static void enable() {
        enabled = true;
        isSampleEnabled = FetchedAppGateKeepersManager.getGateKeeperForKey("FBSDKFeatureAddressDetectionSample", FacebookSdk.getApplicationId(), false);
    }

    public static void processParameters(Map<String, String> parameters) {
        if (!enabled || parameters.size() == 0) {
            return;
        }
        try {
            ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
            JSONObject addressParamsJson = new JSONObject();
            for (String key : keys) {
                String address = parameters.get(key);
                if (!AddressFilterManager.shouldFilterKey(address)) continue;
                parameters.remove(key);
                addressParamsJson.put(key, (Object)(isSampleEnabled ? address : ""));
            }
            if (addressParamsJson.length() != 0) {
                parameters.put("_onDeviceParams", addressParamsJson.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean shouldFilterKey(String textFeature) {
        float[] dense = new float[30];
        Arrays.fill(dense, 0.0f);
        String shouldFilter = ModelManager.predict("DATA_DETECTION_ADDRESS", dense, textFeature);
        return shouldFilter != null && shouldFilter.equals("SHOULD_FILTER");
    }
}

