/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

final class Operator {
    Operator() {
    }

    static float[] add(float[] a, float[] b, int m, int n, int p) {
        for (int i = 0; i < m * n; ++i) {
            for (int j = 0; j < p; ++j) {
                int n2 = i * p + j;
                a[n2] = a[n2] + b[j];
            }
        }
        return a;
    }

    static float[] mul(float[] a, float[] b, int m, int n, int p) {
        float[] res = new float[m * p];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < p; ++j) {
                res[i * p + j] = 0.0f;
                for (int k = 0; k < n; ++k) {
                    int n2 = i * p + j;
                    res[n2] = res[n2] + a[i * n + k] * b[k * p + j];
                }
            }
        }
        return res;
    }

    static void relu(float[] data, int len) {
        for (int i = 0; i < len; ++i) {
            if (!(data[i] < 0.0f)) continue;
            data[i] = 0.0f;
        }
    }

    static float[] concatenate(float[] a, float[] b) {
        float[] res = new float[a.length + b.length];
        System.arraycopy(a, 0, res, 0, a.length);
        System.arraycopy(b, 0, res, a.length, b.length);
        return res;
    }

    static void softmax(float[] data, int n) {
        int i;
        boolean j = false;
        float max = Float.MIN_VALUE;
        float sum = 0.0f;
        for (i = 0; i < n; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        for (i = 0; i < n; ++i) {
            data[i] = (float)Math.exp(data[i] - max);
        }
        for (i = 0; i < n; ++i) {
            sum += data[i];
        }
        for (i = 0; i < n; ++i) {
            data[i] = data[i] / sum;
        }
    }

    static float[] dense(float[] a, float[] b, float[] c, int n_examples, int in_vector_size, int out_vector_size) {
        float[] m_res = Operator.mul(a, b, n_examples, in_vector_size, out_vector_size);
        for (int i = 0; i < n_examples; ++i) {
            for (int j = 0; j < out_vector_size; ++j) {
                int n = i * out_vector_size + j;
                m_res[n] = m_res[n] + c[j];
            }
        }
        return m_res;
    }

    static float[] embedding(int[] a, float[] b, int n_examples, int seq_length, int embedding_size) {
        float[] res = new float[n_examples * seq_length * embedding_size];
        for (int i = 0; i < n_examples; ++i) {
            for (int j = 0; j < seq_length; ++j) {
                int val = a[i * seq_length + j];
                for (int k = 0; k < embedding_size; ++k) {
                    res[embedding_size * seq_length * i + embedding_size * j + k] = b[val * embedding_size + k];
                }
            }
        }
        return res;
    }

    static float[] transpose2D(float[] input, int m, int n) {
        float[] transposed = new float[m * n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                transposed[j * m + i] = input[i * n + j];
            }
        }
        return transposed;
    }

    static float[] transpose3D(float[] input, int m, int n, int p) {
        float[] transposed = new float[m * n * p];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < p; ++k) {
                    transposed[k * m * n + j * m + i] = input[i * n * p + j * p + k];
                }
            }
        }
        return transposed;
    }

    static float[] conv1D(float[] x, float[] w, int n_examples, int seq_len, int input_size, int kernel_size, int output_size) {
        float[] res = new float[n_examples * (seq_len - kernel_size + 1) * output_size];
        for (int n = 0; n < n_examples; ++n) {
            for (int o = 0; o < output_size; ++o) {
                for (int i = 0; i < seq_len - kernel_size + 1; ++i) {
                    float sum = 0.0f;
                    for (int m = 0; m < kernel_size; ++m) {
                        for (int k = 0; k < input_size; ++k) {
                            sum += x[n * (seq_len * input_size) + (m + i) * input_size + k] * w[(m * input_size + k) * output_size + o];
                        }
                    }
                    res[n * (output_size * (seq_len - kernel_size + 1)) + i * output_size + o] = sum;
                }
            }
        }
        return res;
    }

    static float[] maxPool1D(float[] x, int rows, int cols, int pool_size) {
        int len = rows - pool_size + 1;
        float[] res = new float[len * cols];
        for (int c = 0; c < cols; ++c) {
            for (int i = 0; i < len; ++i) {
                for (int r = i; r < i + pool_size; ++r) {
                    res[i * cols + c] = Math.max(res[i * cols + c], x[r * cols + c]);
                }
            }
        }
        return res;
    }
}

