/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.util.Log;
import android.util.Patterns;
import com.facebook.FacebookSdk;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.Utility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class UserDataStore {
    private static final String TAG = UserDataStore.class.getSimpleName();
    private static final String USER_DATA_KEY = "com.facebook.appevents.UserDataStore.userData";
    private static final String INTERNAL_USER_DATA_KEY = "com.facebook.appevents.UserDataStore.internalUserData";
    private static SharedPreferences sharedPreferences;
    private static AtomicBoolean initialized;
    private static final int MAX_NUM = 5;
    private static final String DATA_SEPARATOR = ",";
    private static final ConcurrentHashMap<String, String> externalHashedUserData;
    private static final ConcurrentHashMap<String, String> internalHashedUserData;
    public static final String EMAIL = "em";
    public static final String FIRST_NAME = "fn";
    public static final String LAST_NAME = "ln";
    public static final String PHONE = "ph";
    public static final String DATE_OF_BIRTH = "db";
    public static final String GENDER = "ge";
    public static final String CITY = "ct";
    public static final String STATE = "st";
    public static final String ZIP = "zp";
    public static final String COUNTRY = "country";

    static void initStore() {
        if (initialized.get()) {
            return;
        }
        UserDataStore.initAndWait();
    }

    private static void writeDataIntoCache(final String key, final String value) {
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!initialized.get()) {
                    UserDataStore.initAndWait();
                }
                sharedPreferences.edit().putString(key, value).apply();
            }
        });
    }

    static void setUserDataAndHash(final Bundle ud) {
        InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!initialized.get()) {
                    Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
                    UserDataStore.initAndWait();
                }
                UserDataStore.updateHashUserData(ud);
                UserDataStore.writeDataIntoCache(UserDataStore.USER_DATA_KEY, Utility.mapToJsonStr(externalHashedUserData));
                UserDataStore.writeDataIntoCache(UserDataStore.INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr(internalHashedUserData));
            }
        });
    }

    static void setUserDataAndHash(@Nullable String email, @Nullable String firstName, @Nullable String lastName, @Nullable String phone, @Nullable String dateOfBirth, @Nullable String gender, @Nullable String city, @Nullable String state, @Nullable String zip, @Nullable String country) {
        Bundle ud = new Bundle();
        if (email != null) {
            ud.putString(EMAIL, email);
        }
        if (firstName != null) {
            ud.putString(FIRST_NAME, firstName);
        }
        if (lastName != null) {
            ud.putString(LAST_NAME, lastName);
        }
        if (phone != null) {
            ud.putString(PHONE, phone);
        }
        if (dateOfBirth != null) {
            ud.putString(DATE_OF_BIRTH, dateOfBirth);
        }
        if (gender != null) {
            ud.putString(GENDER, gender);
        }
        if (city != null) {
            ud.putString(CITY, city);
        }
        if (state != null) {
            ud.putString(STATE, state);
        }
        if (zip != null) {
            ud.putString(ZIP, zip);
        }
        if (country != null) {
            ud.putString(COUNTRY, country);
        }
        UserDataStore.setUserDataAndHash(ud);
    }

    static void clear() {
        InternalAppEventsLogger.getAnalyticsExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!initialized.get()) {
                    Log.w((String)TAG, (String)"initStore should have been called before calling setUserData");
                    UserDataStore.initAndWait();
                }
                externalHashedUserData.clear();
                sharedPreferences.edit().putString(UserDataStore.USER_DATA_KEY, null).apply();
            }
        });
    }

    public static void removeRules(List<String> rules) {
        if (!initialized.get()) {
            UserDataStore.initAndWait();
        }
        for (String rule : rules) {
            if (!internalHashedUserData.containsKey(rule)) continue;
            internalHashedUserData.remove(rule);
        }
        UserDataStore.writeDataIntoCache(INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr(internalHashedUserData));
    }

    static String getHashedUserData() {
        if (!initialized.get()) {
            Log.w((String)TAG, (String)"initStore should have been called before calling setUserID");
            UserDataStore.initAndWait();
        }
        return Utility.mapToJsonStr(externalHashedUserData);
    }

    public static String getAllHashedUserData() {
        if (!initialized.get()) {
            UserDataStore.initAndWait();
        }
        HashMap<String, String> allHashedUserData = new HashMap<String, String>();
        allHashedUserData.putAll(externalHashedUserData);
        allHashedUserData.putAll(internalHashedUserData);
        return Utility.mapToJsonStr(allHashedUserData);
    }

    private static synchronized void initAndWait() {
        if (initialized.get()) {
            return;
        }
        sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)FacebookSdk.getApplicationContext());
        String externalUdRaw = sharedPreferences.getString(USER_DATA_KEY, "");
        String internalUdRaw = sharedPreferences.getString(INTERNAL_USER_DATA_KEY, "");
        externalHashedUserData.putAll(Utility.JsonStrToMap(externalUdRaw));
        internalHashedUserData.putAll(Utility.JsonStrToMap(internalUdRaw));
        initialized.set(true);
    }

    public static Map<String, String> getInternalHashedUserData() {
        if (!initialized.get()) {
            UserDataStore.initAndWait();
        }
        return new HashMap<String, String>(internalHashedUserData);
    }

    private static void updateHashUserData(Bundle ud) {
        if (ud == null) {
            return;
        }
        for (String key : ud.keySet()) {
            Object rawVal = ud.get(key);
            if (rawVal == null) continue;
            String value = rawVal.toString();
            if (UserDataStore.maybeSHA256Hashed(value)) {
                externalHashedUserData.put(key, value.toLowerCase());
                continue;
            }
            String encryptedValue = Utility.sha256hash(UserDataStore.normalizeData(key, value));
            if (encryptedValue == null) continue;
            externalHashedUserData.put(key, encryptedValue);
        }
    }

    static void setInternalUd(Map<String, String> ud) {
        if (!initialized.get()) {
            UserDataStore.initAndWait();
        }
        for (Map.Entry<String, String> entry : ud.entrySet()) {
            String key = entry.getKey();
            String rawVal = ud.get(key);
            String value = Utility.sha256hash(UserDataStore.normalizeData(key, rawVal.trim()));
            if (internalHashedUserData.containsKey(key)) {
                String originalVal = internalHashedUserData.get(key);
                String[] previousData = originalVal != null ? originalVal.split(DATA_SEPARATOR) : new String[]{};
                HashSet<String> set = new HashSet<String>(Arrays.asList(previousData));
                if (set.contains(value)) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                if (previousData.length == 0) {
                    sb.append(value);
                } else if (previousData.length < 5) {
                    sb.append(originalVal).append(DATA_SEPARATOR).append(value);
                } else {
                    for (int i = 1; i < 5; ++i) {
                        sb.append(previousData[i]).append(DATA_SEPARATOR);
                    }
                    sb.append(value);
                    set.remove(previousData[0]);
                }
                internalHashedUserData.put(key, sb.toString());
                continue;
            }
            internalHashedUserData.put(key, value);
        }
        UserDataStore.writeDataIntoCache(INTERNAL_USER_DATA_KEY, Utility.mapToJsonStr(internalHashedUserData));
    }

    private static String normalizeData(String type, String data) {
        data = data.trim().toLowerCase();
        if (EMAIL.equals(type)) {
            if (Patterns.EMAIL_ADDRESS.matcher(data).matches()) {
                return data;
            }
            Log.e((String)TAG, (String)"Setting email failure: this is not a valid email address");
            return "";
        }
        if (PHONE.equals(type)) {
            return data.replaceAll("[^0-9]", "");
        }
        if (GENDER.equals(type)) {
            String string = data = data.length() > 0 ? data.substring(0, 1) : "";
            if ("f".equals(data) || "m".equals(data)) {
                return data;
            }
            Log.e((String)TAG, (String)"Setting gender failure: the supported value for gender is f or m");
            return "";
        }
        return data;
    }

    private static boolean maybeSHA256Hashed(String data) {
        return data.matches("[A-Fa-f0-9]{64}");
    }

    static {
        initialized = new AtomicBoolean(false);
        externalHashedUserData = new ConcurrentHashMap();
        internalHashedUserData = new ConcurrentHashMap();
    }
}

