/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.facebook.FacebookException;
import com.facebook.internal.ImageRequest;
import com.facebook.internal.ImageResponse;
import com.facebook.internal.ImageResponseCache;
import com.facebook.internal.UrlRedirectCache;
import com.facebook.internal.Utility;
import com.facebook.internal.WorkQueue;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ImageDownloader {
    private static final int DOWNLOAD_QUEUE_MAX_CONCURRENT = 8;
    private static final int CACHE_READ_QUEUE_MAX_CONCURRENT = 2;
    private static Handler handler;
    private static WorkQueue downloadQueue;
    private static WorkQueue cacheReadQueue;
    private static final Map<RequestKey, DownloaderContext> pendingRequests;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadAsync(ImageRequest request) {
        if (request == null) {
            return;
        }
        RequestKey key = new RequestKey(request.getImageUri(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                downloaderContext.request = request;
                downloaderContext.isCancelled = false;
                downloaderContext.workItem.moveToFront();
            } else {
                ImageDownloader.enqueueCacheRead(request, key, request.isCachedRedirectAllowed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelRequest(ImageRequest request) {
        boolean cancelled = false;
        RequestKey key = new RequestKey(request.getImageUri(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                cancelled = true;
                if (downloaderContext.workItem.cancel()) {
                    pendingRequests.remove(key);
                } else {
                    downloaderContext.isCancelled = true;
                }
            }
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prioritizeRequest(ImageRequest request) {
        RequestKey key = new RequestKey(request.getImageUri(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                downloaderContext.workItem.moveToFront();
            }
        }
    }

    public static void clearCache(Context context) {
        ImageResponseCache.clearCache(context);
        UrlRedirectCache.clearCache();
    }

    private static void enqueueCacheRead(ImageRequest request, RequestKey key, boolean allowCachedRedirects) {
        ImageDownloader.enqueueRequest(request, key, cacheReadQueue, new CacheReadWorkItem(request.getContext(), key, allowCachedRedirects));
    }

    private static void enqueueDownload(ImageRequest request, RequestKey key) {
        ImageDownloader.enqueueRequest(request, key, downloadQueue, new DownloadImageWorkItem(request.getContext(), key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueueRequest(ImageRequest request, RequestKey key, WorkQueue workQueue, Runnable workItem) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = new DownloaderContext();
            downloaderContext.request = request;
            pendingRequests.put(key, downloaderContext);
            downloaderContext.workItem = workQueue.addActiveWorkItem(workItem);
        }
    }

    private static void issueResponse(RequestKey key, final Exception error, final Bitmap bitmap, final boolean isCachedRedirect) {
        ImageRequest request;
        ImageRequest.Callback callback;
        DownloaderContext completedRequestContext = ImageDownloader.removePendingRequest(key);
        if (completedRequestContext != null && !completedRequestContext.isCancelled && (callback = (request = completedRequestContext.request).getCallback()) != null) {
            ImageDownloader.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        ImageResponse response = new ImageResponse(request, error, isCachedRedirect, bitmap);
                        callback.onCompleted(response);
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
    }

    private static void readFromCache(RequestKey key, Context context, boolean allowCachedRedirects) {
        Uri redirectUri;
        InputStream cachedStream = null;
        boolean isCachedRedirect = false;
        if (allowCachedRedirects && (redirectUri = UrlRedirectCache.getRedirectedUri(key.uri)) != null) {
            cachedStream = ImageResponseCache.getCachedImageStream(redirectUri, context);
            boolean bl = isCachedRedirect = cachedStream != null;
        }
        if (!isCachedRedirect) {
            cachedStream = ImageResponseCache.getCachedImageStream(key.uri, context);
        }
        if (cachedStream != null) {
            Bitmap bitmap = BitmapFactory.decodeStream(cachedStream);
            Utility.closeQuietly(cachedStream);
            ImageDownloader.issueResponse(key, null, bitmap, isCachedRedirect);
        } else {
            DownloaderContext downloaderContext = ImageDownloader.removePendingRequest(key);
            if (downloaderContext != null && !downloaderContext.isCancelled) {
                ImageDownloader.enqueueDownload(downloaderContext.request, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(RequestKey key, Context context) {
        boolean issueResponse;
        Bitmap bitmap;
        Exception error;
        block13: {
            HttpURLConnection connection = null;
            InputStream stream = null;
            error = null;
            bitmap = null;
            issueResponse = true;
            try {
                URL url = new URL(key.uri.toString());
                connection = (HttpURLConnection)url.openConnection();
                connection.setInstanceFollowRedirects(false);
                switch (connection.getResponseCode()) {
                    case 301: 
                    case 302: {
                        issueResponse = false;
                        String redirectLocation = connection.getHeaderField("location");
                        if (Utility.isNullOrEmpty(redirectLocation)) break;
                        Uri redirectUri = Uri.parse((String)redirectLocation);
                        UrlRedirectCache.cacheUriRedirect(key.uri, redirectUri);
                        DownloaderContext downloaderContext = ImageDownloader.removePendingRequest(key);
                        if (downloaderContext == null || downloaderContext.isCancelled) break;
                        ImageDownloader.enqueueCacheRead(downloaderContext.request, new RequestKey(redirectUri, key.tag), false);
                        break;
                    }
                    case 200: {
                        stream = ImageResponseCache.interceptAndCacheImageStream(context, connection);
                        bitmap = BitmapFactory.decodeStream((InputStream)stream);
                        break;
                    }
                    default: {
                        stream = connection.getErrorStream();
                        StringBuilder errorMessageBuilder = new StringBuilder();
                        if (stream != null) {
                            int bufferLength;
                            InputStreamReader reader = new InputStreamReader(stream);
                            char[] buffer = new char[128];
                            while ((bufferLength = reader.read(buffer, 0, buffer.length)) > 0) {
                                errorMessageBuilder.append(buffer, 0, bufferLength);
                            }
                            Utility.closeQuietly(reader);
                        } else {
                            errorMessageBuilder.append("Unexpected error while downloading an image.");
                        }
                        error = new FacebookException(errorMessageBuilder.toString());
                    }
                }
                Utility.closeQuietly(stream);
            }
            catch (IOException e) {
                error = e;
                break block13;
            }
            finally {
                Utility.closeQuietly(stream);
                Utility.disconnectQuietly(connection);
            }
            Utility.disconnectQuietly(connection);
        }
        if (issueResponse) {
            ImageDownloader.issueResponse(key, error, bitmap, false);
        }
    }

    private static synchronized Handler getHandler() {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DownloaderContext removePendingRequest(RequestKey key) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            return pendingRequests.remove(key);
        }
    }

    static {
        downloadQueue = new WorkQueue(8);
        cacheReadQueue = new WorkQueue(2);
        pendingRequests = new HashMap<RequestKey, DownloaderContext>();
    }

    private static class DownloadImageWorkItem
    implements Runnable {
        private Context context;
        private RequestKey key;

        DownloadImageWorkItem(Context context, RequestKey key) {
            this.context = context;
            this.key = key;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                ImageDownloader.download(this.key, this.context);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }
    }

    private static class CacheReadWorkItem
    implements Runnable {
        private Context context;
        private RequestKey key;
        private boolean allowCachedRedirects;

        CacheReadWorkItem(Context context, RequestKey key, boolean allowCachedRedirects) {
            this.context = context;
            this.key = key;
            this.allowCachedRedirects = allowCachedRedirects;
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                ImageDownloader.readFromCache(this.key, this.context, this.allowCachedRedirects);
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }
    }

    private static class DownloaderContext {
        WorkQueue.WorkItem workItem;
        ImageRequest request;
        boolean isCancelled;

        private DownloaderContext() {
        }
    }

    private static class RequestKey {
        private static final int HASH_SEED = 29;
        private static final int HASH_MULTIPLIER = 37;
        Uri uri;
        Object tag;

        RequestKey(Uri url, Object tag) {
            this.uri = url;
            this.tag = tag;
        }

        public int hashCode() {
            int result = 29;
            result = result * 37 + this.uri.hashCode();
            result = result * 37 + this.tag.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            boolean isEqual = false;
            if (o != null && o instanceof RequestKey) {
                RequestKey compareTo = (RequestKey)o;
                isEqual = compareTo.uri == this.uri && compareTo.tag == this.tag;
            }
            return isEqual;
        }
    }
}

