/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.suggestedevents;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.appevents.suggestedevents.SuggestedEventViewHierarchy;
import com.facebook.appevents.suggestedevents.ViewOnClickListener;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class ViewObserver
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = ViewObserver.class.getCanonicalName();
    private WeakReference<Activity> activityWeakReference;
    private final Handler uiThreadHandler;
    private AtomicBoolean isTracking;
    private static final Map<Integer, ViewObserver> observers = new HashMap<Integer, ViewObserver>();
    private static final int MAX_TEXT_LENGTH = 300;

    static void startTrackingActivity(Activity activity) {
        int key = activity.hashCode();
        if (!observers.containsKey(key)) {
            ViewObserver observer = new ViewObserver(activity);
            observers.put(key, observer);
            observer.startTracking();
        }
    }

    static void stopTrackingActivity(Activity activity) {
        int key = activity.hashCode();
        if (observers.containsKey(key)) {
            ViewObserver observer = observers.get(key);
            observers.remove(key);
            observer.stopTracking();
        }
    }

    private ViewObserver(Activity activity) {
        this.activityWeakReference = new WeakReference<Activity>(activity);
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        this.isTracking = new AtomicBoolean(false);
    }

    private void startTracking() {
        if (this.isTracking.getAndSet(true)) {
            return;
        }
        View rootView = this.getRootView();
        if (rootView == null) {
            return;
        }
        ViewTreeObserver observer = rootView.getViewTreeObserver();
        if (observer.isAlive()) {
            observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            this.process();
        }
    }

    private void stopTracking() {
        if (!this.isTracking.getAndSet(false)) {
            return;
        }
        View rootView = this.getRootView();
        if (rootView == null) {
            return;
        }
        ViewTreeObserver observer = rootView.getViewTreeObserver();
        if (!observer.isAlive()) {
            return;
        }
        if (Build.VERSION.SDK_INT < 16) {
            observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public void onGlobalLayout() {
        this.process();
    }

    private void process() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    try {
                        View rootView = ViewObserver.this.getRootView();
                        Activity activity = (Activity)ViewObserver.this.activityWeakReference.get();
                        if (rootView == null || activity == null) {
                            return;
                        }
                        List<View> clickableViews = SuggestedEventViewHierarchy.getAllClickableViews(rootView);
                        for (View view : clickableViews) {
                            String text;
                            if (SensitiveUserDataUtils.isSensitiveUserData(view) || (text = ViewHierarchy.getTextOfView(view)).isEmpty() || text.length() > 300) continue;
                            ViewOnClickListener.attachListener(view, rootView, activity.getLocalClassName());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        };
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.uiThreadHandler.post(runnable);
        }
    }

    @Nullable
    private View getRootView() {
        Activity activity = (Activity)this.activityWeakReference.get();
        if (activity == null) {
            return null;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return null;
        }
        return window.getDecorView().getRootView();
    }
}

