/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.ml;

import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.appevents.ml.Operator;
import com.facebook.appevents.ml.Utils;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Model {
    private static final String DIR_NAME = "facebook_ml/";
    public static final String SHOULD_FILTER = "SHOULD_FILTER";
    private static final List<String> SUGGESTED_EVENTS_PREDICTION = Arrays.asList("fb_mobile_add_to_cart", "fb_mobile_complete_registration", "other", "fb_mobile_purchase");
    private String useCase;
    private File modelFile;
    private File ruleFile;
    private File dir;
    private int versionID;
    private float[] thresholds;
    @Nullable
    private String modelUri;
    @Nullable
    private String ruleUri;
    @Nullable
    private Weight embedding;
    @Nullable
    private Weight convs_1_weight;
    @Nullable
    private Weight convs_2_weight;
    @Nullable
    private Weight convs_3_weight;
    @Nullable
    private Weight convs_1_bias;
    @Nullable
    private Weight convs_2_bias;
    @Nullable
    private Weight convs_3_bias;
    @Nullable
    private Weight fc1_weight;
    @Nullable
    private Weight fc2_weight;
    @Nullable
    private Weight fc3_weight;
    @Nullable
    private Weight fc1_bias;
    @Nullable
    private Weight fc2_bias;
    @Nullable
    private Weight fc3_bias;
    private static final int SEQ_LEN = 128;
    private static final int EMBEDDING_SIZE = 64;
    private static final Map<String, String> WEIGHTS_KEY_MAPPING = new HashMap<String, String>(){
        {
            this.put("embedding.weight", "embed.weight");
            this.put("dense1.weight", "fc1.weight");
            this.put("dense2.weight", "fc2.weight");
            this.put("dense3.weight", "fc3.weight");
            this.put("dense1.bias", "fc1.bias");
            this.put("dense2.bias", "fc2.bias");
            this.put("dense3.bias", "fc3.bias");
        }
    };

    Model(String useCase, int versionID, String modelUri, @Nullable String ruleUri, float[] thresholds) {
        this.useCase = useCase;
        this.versionID = versionID;
        this.thresholds = thresholds;
        this.modelUri = modelUri;
        this.ruleUri = ruleUri;
        this.dir = new File(FacebookSdk.getApplicationContext().getFilesDir(), DIR_NAME);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        this.modelFile = new File(this.dir, useCase + "_" + versionID);
        this.ruleFile = new File(this.dir, useCase + "_" + versionID + "_rule");
    }

    void initialize(final Runnable onModelInitialized) {
        this.downloadModel(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    if (Model.this.initializeWeights()) {
                        Model.this.downloadRule(onModelInitialized);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        });
        this.deleteOldFiles();
    }

    private void deleteOldFiles() {
        File[] existingFiles = this.dir.listFiles();
        if (existingFiles == null || existingFiles.length == 0) {
            return;
        }
        String prefixWithVersion = this.useCase + "_" + this.versionID;
        for (File f : existingFiles) {
            String name = f.getName();
            if (!name.startsWith(this.useCase) || name.startsWith(prefixWithVersion)) continue;
            f.delete();
        }
    }

    @Nullable
    File getRuleFile() {
        return this.ruleFile;
    }

    private void downloadModel(Runnable onDownloaded) {
        if (this.modelFile.exists()) {
            onDownloaded.run();
            return;
        }
        if (this.modelUri != null) {
            new FileDownloadTask(this.modelUri, this.modelFile, onDownloaded).execute(new String[0]);
        }
    }

    private void downloadRule(Runnable onDownloaded) {
        if (this.ruleFile.exists() || this.ruleUri == null) {
            onDownloaded.run();
            return;
        }
        new FileDownloadTask(this.ruleUri, this.ruleFile, onDownloaded).execute(new String[0]);
    }

    private boolean initializeWeights() {
        try {
            FileInputStream inputStream = new FileInputStream(this.modelFile);
            int length = ((InputStream)inputStream).available();
            DataInputStream dataIs = new DataInputStream(inputStream);
            byte[] allData = new byte[length];
            dataIs.readFully(allData);
            dataIs.close();
            if (length < 4) {
                return false;
            }
            ByteBuffer bb = ByteBuffer.wrap(allData, 0, 4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            int jsonLen = bb.getInt();
            if (length < jsonLen + 4) {
                return false;
            }
            String jsonStr = new String(allData, 4, jsonLen);
            JSONObject info = new JSONObject(jsonStr);
            JSONArray names = info.names();
            Object[] keys = new String[names.length()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = names.getString(i);
            }
            Arrays.sort(keys);
            int offset = 4 + jsonLen;
            HashMap<Object, Weight> weights = new HashMap<Object, Weight>();
            for (Object key : keys) {
                int count = 1;
                JSONArray shapes = info.getJSONArray((String)key);
                int[] shape = new int[shapes.length()];
                for (int i = 0; i < shape.length; ++i) {
                    shape[i] = shapes.getInt(i);
                    count *= shape[i];
                }
                if (offset + count * 4 > length) {
                    return false;
                }
                bb = ByteBuffer.wrap(allData, offset, count * 4);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                float[] data = new float[count];
                bb.asFloatBuffer().get(data, 0, count);
                Object finalKey = key;
                if (WEIGHTS_KEY_MAPPING.containsKey(key)) {
                    finalKey = WEIGHTS_KEY_MAPPING.get(key);
                }
                weights.put(finalKey, new Weight(shape, data));
                offset += count * 4;
            }
            this.embedding = (Weight)weights.get("embed.weight");
            this.convs_1_weight = (Weight)weights.get("convs.0.weight");
            this.convs_2_weight = (Weight)weights.get("convs.1.weight");
            this.convs_3_weight = (Weight)weights.get("convs.2.weight");
            this.convs_1_weight.data = Operator.transpose3D(this.convs_1_weight.data, this.convs_1_weight.shape[0], this.convs_1_weight.shape[1], this.convs_1_weight.shape[2]);
            this.convs_2_weight.data = Operator.transpose3D(this.convs_2_weight.data, this.convs_2_weight.shape[0], this.convs_2_weight.shape[1], this.convs_2_weight.shape[2]);
            this.convs_3_weight.data = Operator.transpose3D(this.convs_3_weight.data, this.convs_3_weight.shape[0], this.convs_3_weight.shape[1], this.convs_3_weight.shape[2]);
            this.convs_1_bias = (Weight)weights.get("convs.0.bias");
            this.convs_2_bias = (Weight)weights.get("convs.1.bias");
            this.convs_3_bias = (Weight)weights.get("convs.2.bias");
            this.fc1_weight = (Weight)weights.get("fc1.weight");
            this.fc2_weight = (Weight)weights.get("fc2.weight");
            this.fc3_weight = (Weight)weights.get("fc3.weight");
            this.fc1_weight.data = Operator.transpose2D(this.fc1_weight.data, this.fc1_weight.shape[0], this.fc1_weight.shape[1]);
            this.fc2_weight.data = Operator.transpose2D(this.fc2_weight.data, this.fc2_weight.shape[0], this.fc2_weight.shape[1]);
            this.fc3_weight.data = Operator.transpose2D(this.fc3_weight.data, this.fc3_weight.shape[0], this.fc3_weight.shape[1]);
            this.fc1_bias = (Weight)weights.get("fc1.bias");
            this.fc2_bias = (Weight)weights.get("fc2.bias");
            this.fc3_bias = (Weight)weights.get("fc3.bias");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    String predict(float[] dense, String text) {
        int[] x = Utils.vectorize(text, 128);
        float[] embed_x = Operator.embedding(x, this.embedding.data, 1, 128, 64);
        float[] c1 = Operator.conv1D(embed_x, this.convs_1_weight.data, 1, 128, 64, this.convs_1_weight.shape[2], this.convs_1_weight.shape[0]);
        float[] c2 = Operator.conv1D(embed_x, this.convs_2_weight.data, 1, 128, 64, this.convs_2_weight.shape[2], this.convs_2_weight.shape[0]);
        float[] c3 = Operator.conv1D(embed_x, this.convs_3_weight.data, 1, 128, 64, this.convs_3_weight.shape[2], this.convs_3_weight.shape[0]);
        Operator.add(c1, this.convs_1_bias.data, 1, 128 - this.convs_1_weight.shape[2] + 1, this.convs_1_weight.shape[0]);
        Operator.add(c2, this.convs_2_bias.data, 1, 128 - this.convs_2_weight.shape[2] + 1, this.convs_2_weight.shape[0]);
        Operator.add(c3, this.convs_3_bias.data, 1, 128 - this.convs_3_weight.shape[2] + 1, this.convs_3_weight.shape[0]);
        Operator.relu(c1, (128 - this.convs_1_weight.shape[2] + 1) * this.convs_1_weight.shape[0]);
        Operator.relu(c2, (128 - this.convs_2_weight.shape[2] + 1) * this.convs_2_weight.shape[0]);
        Operator.relu(c3, (128 - this.convs_3_weight.shape[2] + 1) * this.convs_3_weight.shape[0]);
        float[] ca = Operator.maxPool1D(c1, 128 - this.convs_1_weight.shape[2] + 1, this.convs_1_weight.shape[0], 128 - this.convs_1_weight.shape[2] + 1);
        float[] cb = Operator.maxPool1D(c2, 128 - this.convs_2_weight.shape[2] + 1, this.convs_2_weight.shape[0], 128 - this.convs_2_weight.shape[2] + 1);
        float[] cc = Operator.maxPool1D(c3, 128 - this.convs_3_weight.shape[2] + 1, this.convs_3_weight.shape[0], 128 - this.convs_3_weight.shape[2] + 1);
        float[] concat = Operator.concatenate(Operator.concatenate(Operator.concatenate(ca, cb), cc), dense);
        float[] dense1_x = Operator.dense(concat, this.fc1_weight.data, this.fc1_bias.data, 1, this.fc1_weight.shape[1], this.fc1_weight.shape[0]);
        Operator.relu(dense1_x, this.fc1_bias.shape[0]);
        float[] dense2_x = Operator.dense(dense1_x, this.fc2_weight.data, this.fc2_bias.data, 1, this.fc2_weight.shape[1], this.fc2_weight.shape[0]);
        Operator.relu(dense2_x, this.fc2_bias.shape[0]);
        float[] predictedRaw = Operator.dense(dense2_x, this.fc3_weight.data, this.fc3_bias.data, 1, this.fc3_weight.shape[1], this.fc3_weight.shape[0]);
        Operator.softmax(predictedRaw, this.fc3_bias.shape[0]);
        return this.processPredictionResult(predictedRaw);
    }

    @Nullable
    String processPredictionResult(float[] predictedResult) {
        if (predictedResult.length == 0 || this.thresholds.length == 0) {
            return null;
        }
        if (this.useCase.equals("SUGGEST_EVENT")) {
            return this.processSuggestedEventResult(predictedResult);
        }
        if (this.useCase.equals("DATA_DETECTION_ADDRESS")) {
            return this.processAddressDetectionResult(predictedResult);
        }
        return null;
    }

    @Nullable
    String processSuggestedEventResult(float[] predictedResult) {
        if (this.thresholds.length != predictedResult.length) {
            return null;
        }
        for (int i = 0; i < this.thresholds.length; ++i) {
            if (!(predictedResult[i] >= this.thresholds[i])) continue;
            return SUGGESTED_EVENTS_PREDICTION.get(i);
        }
        return "other";
    }

    @Nullable
    String processAddressDetectionResult(float[] predictedResult) {
        return predictedResult[1] >= this.thresholds[0] ? SHOULD_FILTER : null;
    }

    private static class Weight {
        public int[] shape;
        public float[] data;

        Weight(int[] shape, float[] data) {
            this.shape = shape;
            this.data = data;
        }
    }

    static class FileDownloadTask
    extends AsyncTask<String, Void, Boolean> {
        Runnable onSuccess;
        File destFile;
        String uriStr;

        FileDownloadTask(String uriStr, File destFile, Runnable onSuccess) {
            this.uriStr = uriStr;
            this.destFile = destFile;
            this.onSuccess = onSuccess;
        }

        protected Boolean doInBackground(String ... stringArray) {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return null;
            }
            try {
                try {
                    URL url = new URL(this.uriStr);
                    URLConnection conn = url.openConnection();
                    int contentLength = conn.getContentLength();
                    DataInputStream stream = new DataInputStream(url.openStream());
                    byte[] buffer = new byte[contentLength];
                    stream.readFully(buffer);
                    stream.close();
                    DataOutputStream fos = new DataOutputStream(new FileOutputStream(this.destFile));
                    fos.write(buffer);
                    fos.flush();
                    fos.close();
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, (Object)this);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void onPostExecute(Boolean bl) {
            if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                return;
            }
            try {
                void isSuccess;
                if (isSuccess.booleanValue()) {
                    this.onSuccess.run();
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, (Object)this);
                return;
            }
        }
    }
}

