/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.ListView;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.appevents.codeless.CodelessLoggingEventListener;
import com.facebook.appevents.codeless.RCTCodelessLoggingEventListener;
import com.facebook.appevents.codeless.internal.EventBinding;
import com.facebook.appevents.codeless.internal.ParameterComponent;
import com.facebook.appevents.codeless.internal.PathComponent;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.InternalSettings;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

class CodelessMatcher {
    private static final String PARENT_CLASS_NAME = "..";
    private static final String CURRENT_CLASS_NAME = ".";
    private static final String TAG = CodelessMatcher.class.getCanonicalName();
    private final Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    private Set<Activity> activitiesSet = Collections.newSetFromMap(new WeakHashMap());
    private Set<ViewMatcher> viewMatchers = new HashSet<ViewMatcher>();
    private HashSet<String> listenerSet = new HashSet();
    private HashMap<Integer, HashSet<String>> activityToListenerMap = new HashMap();
    private static CodelessMatcher codelessMatcher = null;

    private CodelessMatcher() {
    }

    public static synchronized CodelessMatcher getInstance() {
        if (codelessMatcher == null) {
            codelessMatcher = new CodelessMatcher();
        }
        return codelessMatcher;
    }

    public void add(Activity activity) {
        if (InternalSettings.isUnityApp()) {
            return;
        }
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new FacebookException("Can't add activity to CodelessMatcher on non-UI thread");
        }
        this.activitiesSet.add(activity);
        this.listenerSet.clear();
        if (this.activityToListenerMap.containsKey(activity.hashCode())) {
            this.listenerSet = this.activityToListenerMap.get(activity.hashCode());
        }
        this.startTracking();
    }

    public void remove(Activity activity) {
        if (InternalSettings.isUnityApp()) {
            return;
        }
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new FacebookException("Can't remove activity from CodelessMatcher on non-UI thread");
        }
        this.activitiesSet.remove(activity);
        this.viewMatchers.clear();
        this.activityToListenerMap.put(activity.hashCode(), (HashSet)this.listenerSet.clone());
        this.listenerSet.clear();
    }

    public void destroy(Activity activity) {
        this.activityToListenerMap.remove(activity.hashCode());
    }

    public static Bundle getParameters(EventBinding mapping, View rootView, View hostView) {
        Bundle params = new Bundle();
        if (null == mapping) {
            return params;
        }
        List<ParameterComponent> parameters = mapping.getViewParameters();
        if (null != parameters) {
            block0: for (ParameterComponent component : parameters) {
                if (component.value != null && component.value.length() > 0) {
                    params.putString(component.name, component.value);
                    continue;
                }
                if (component.path.size() <= 0) continue;
                String pathType = component.pathType;
                List<MatchedView> matchedViews = pathType.equals("relative") ? ViewMatcher.findViewByPath(mapping, hostView, component.path, 0, -1, hostView.getClass().getSimpleName()) : ViewMatcher.findViewByPath(mapping, rootView, component.path, 0, -1, rootView.getClass().getSimpleName());
                for (MatchedView view : matchedViews) {
                    String text;
                    if (view.getView() == null || (text = ViewHierarchy.getTextOfView(view.getView())).length() <= 0) continue;
                    params.putString(component.name, text);
                    continue block0;
                }
            }
        }
        return params;
    }

    private void startTracking() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.matchViews();
        } else {
            this.uiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (CrashShieldHandler.isObjectCrashing(this)) {
                        return;
                    }
                    try {
                        CodelessMatcher.this.matchViews();
                        return;
                    }
                    catch (Throwable throwable) {
                        CrashShieldHandler.handleThrowable(throwable, this);
                        return;
                    }
                }
            });
        }
    }

    private void matchViews() {
        for (Activity activity : this.activitiesSet) {
            if (null == activity) continue;
            View rootView = activity.getWindow().getDecorView().getRootView();
            String activityName = activity.getClass().getSimpleName();
            ViewMatcher matcher = new ViewMatcher(rootView, this.uiThreadHandler, this.listenerSet, activityName);
            this.viewMatchers.add(matcher);
        }
    }

    protected static class ViewMatcher
    implements ViewTreeObserver.OnGlobalLayoutListener,
    ViewTreeObserver.OnScrollChangedListener,
    Runnable {
        private WeakReference<View> rootView;
        @Nullable
        private List<EventBinding> eventBindings;
        private final Handler handler;
        private HashSet<String> listenerSet;
        private final String activityName;

        public ViewMatcher(View rootView, Handler handler, HashSet<String> listenerSet, String activityName) {
            this.rootView = new WeakReference<View>(rootView);
            this.handler = handler;
            this.listenerSet = listenerSet;
            this.activityName = activityName;
            this.handler.postDelayed((Runnable)this, 200L);
        }

        @Override
        public void run() {
            if (CrashShieldHandler.isObjectCrashing(this)) {
                return;
            }
            try {
                String appId = FacebookSdk.getApplicationId();
                FetchedAppSettings appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
                if (appSettings == null || !appSettings.getCodelessEventsEnabled()) {
                    return;
                }
                this.eventBindings = EventBinding.parseArray(appSettings.getEventBindings());
                if (this.eventBindings != null) {
                    View rootView = (View)this.rootView.get();
                    if (rootView == null) {
                        return;
                    }
                    ViewTreeObserver observer = rootView.getViewTreeObserver();
                    if (observer.isAlive()) {
                        observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        observer.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    }
                    this.startMatch();
                }
                return;
            }
            catch (Throwable throwable) {
                CrashShieldHandler.handleThrowable(throwable, this);
                return;
            }
        }

        public void onGlobalLayout() {
            this.startMatch();
        }

        public void onScrollChanged() {
            this.startMatch();
        }

        private void startMatch() {
            if (this.eventBindings != null && this.rootView.get() != null) {
                for (int i = 0; i < this.eventBindings.size(); ++i) {
                    EventBinding binding = this.eventBindings.get(i);
                    this.findView(binding, (View)this.rootView.get());
                }
            }
        }

        public void findView(EventBinding mapping, View rootView) {
            if (mapping == null || rootView == null) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)mapping.getActivityName()) && !mapping.getActivityName().equals(this.activityName)) {
                return;
            }
            List<PathComponent> path = mapping.getViewPath();
            if (path.size() > 25) {
                return;
            }
            List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, rootView, path, 0, -1, this.activityName);
            for (MatchedView view : matchedViews) {
                this.attachListener(view, rootView, mapping);
            }
        }

        public static List<MatchedView> findViewByPath(EventBinding mapping, View view, List<PathComponent> path, int level, int index, String mapKey) {
            mapKey = mapKey + CodelessMatcher.CURRENT_CLASS_NAME + String.valueOf(index);
            ArrayList<MatchedView> result = new ArrayList<MatchedView>();
            if (null == view) {
                return result;
            }
            if (level >= path.size()) {
                result.add(new MatchedView(view, mapKey));
            } else {
                PathComponent pathElement = path.get(level);
                if (pathElement.className.equals(CodelessMatcher.PARENT_CLASS_NAME)) {
                    ViewParent parent = view.getParent();
                    if (parent instanceof ViewGroup) {
                        ViewGroup viewGroup = (ViewGroup)parent;
                        List<View> visibleViews = ViewMatcher.findVisibleChildren(viewGroup);
                        int childCount = visibleViews.size();
                        for (int i = 0; i < childCount; ++i) {
                            View child = visibleViews.get(i);
                            List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, child, path, level + 1, i, mapKey);
                            result.addAll(matchedViews);
                        }
                    }
                    return result;
                }
                if (pathElement.className.equals(CodelessMatcher.CURRENT_CLASS_NAME)) {
                    result.add(new MatchedView(view, mapKey));
                    return result;
                }
                if (!ViewMatcher.isTheSameView(view, pathElement, index)) {
                    return result;
                }
                if (level == path.size() - 1) {
                    result.add(new MatchedView(view, mapKey));
                }
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                List<View> visibleViews = ViewMatcher.findVisibleChildren(viewGroup);
                int childCount = visibleViews.size();
                for (int i = 0; i < childCount; ++i) {
                    View child = visibleViews.get(i);
                    List<MatchedView> matchedViews = ViewMatcher.findViewByPath(mapping, child, path, level + 1, i, mapKey);
                    result.addAll(matchedViews);
                }
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isTheSameView(View targetView, PathComponent pathElement, int index) {
            if (pathElement.index != -1 && index != pathElement.index) {
                return false;
            }
            if (!targetView.getClass().getCanonicalName().equals(pathElement.className)) {
                if (!pathElement.className.matches(".*android\\..*")) return false;
                String[] names = pathElement.className.split("\\.");
                if (names.length <= 0) return false;
                String SimpleName = names[names.length - 1];
                if (!targetView.getClass().getSimpleName().equals(SimpleName)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.ID.getValue()) > 0 && pathElement.id != targetView.getId()) {
                return false;
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.TEXT.getValue()) > 0) {
                String pathText = pathElement.text;
                String text = ViewHierarchy.getTextOfView(targetView);
                String hashedText = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(text), "");
                if (!pathText.equals(text) && !pathText.equals(hashedText)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.DESCRIPTION.getValue()) > 0) {
                String pathDesc = pathElement.description;
                String targetDesc = targetView.getContentDescription() == null ? "" : String.valueOf(targetView.getContentDescription());
                String hashedDesc = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetDesc), "");
                if (!pathDesc.equals(targetDesc) && !pathDesc.equals(hashedDesc)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.HINT.getValue()) > 0) {
                String pathHint = pathElement.hint;
                String targetHint = ViewHierarchy.getHintOfView(targetView);
                String hashedHint = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetHint), "");
                if (!pathHint.equals(targetHint) && !pathHint.equals(hashedHint)) {
                    return false;
                }
            }
            if ((pathElement.matchBitmask & PathComponent.MatchBitmaskType.TAG.getValue()) <= 0) return true;
            String tag = pathElement.tag;
            String targetTag = targetView.getTag() == null ? "" : String.valueOf(targetView.getTag());
            String hashedTag = Utility.coerceValueIfNullOrEmpty(Utility.sha256hash(targetTag), "");
            if (tag.equals(targetTag) || tag.equals(hashedTag)) return true;
            return false;
        }

        private static List<View> findVisibleChildren(ViewGroup viewGroup) {
            ArrayList<View> visibleViews = new ArrayList<View>();
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                visibleViews.add(child);
            }
            return visibleViews;
        }

        private void attachListener(MatchedView matchedView, View rootView, EventBinding mapping) {
            if (mapping == null) {
                return;
            }
            try {
                View view = matchedView.getView();
                if (view == null) {
                    return;
                }
                View RCTRootView = ViewHierarchy.findRCTRootView(view);
                if (null != RCTRootView && ViewHierarchy.isRCTButton(view, RCTRootView)) {
                    this.attachRCTListener(matchedView, rootView, mapping);
                    return;
                }
                if (view.getClass().getName().startsWith("com.facebook.react")) {
                    return;
                }
                if (!(view instanceof AdapterView)) {
                    this.attachOnClickListener(matchedView, rootView, mapping);
                } else if (view instanceof ListView) {
                    this.attachOnItemClickListener(matchedView, rootView, mapping);
                }
            }
            catch (Exception e) {
                Utility.logd(TAG, e);
            }
        }

        private void attachOnClickListener(MatchedView matchedView, View rootView, EventBinding mapping) {
            boolean listenerSupportCodelessLogging;
            View view = matchedView.getView();
            if (view == null) {
                return;
            }
            String mapKey = matchedView.getViewMapKey();
            View.OnClickListener existingListener = ViewHierarchy.getExistingOnClickListener(view);
            boolean isCodelessListener = existingListener instanceof CodelessLoggingEventListener.AutoLoggingOnClickListener;
            boolean bl = listenerSupportCodelessLogging = isCodelessListener && ((CodelessLoggingEventListener.AutoLoggingOnClickListener)existingListener).getSupportCodelessLogging();
            if (!this.listenerSet.contains(mapKey) && !listenerSupportCodelessLogging) {
                CodelessLoggingEventListener.AutoLoggingOnClickListener listener = CodelessLoggingEventListener.getOnClickListener(mapping, rootView, view);
                view.setOnClickListener((View.OnClickListener)listener);
                this.listenerSet.add(mapKey);
            }
        }

        private void attachOnItemClickListener(MatchedView matchedView, View rootView, EventBinding mapping) {
            boolean listenerSupportCodelessLogging;
            AdapterView view = (AdapterView)matchedView.getView();
            if (view == null) {
                return;
            }
            String mapKey = matchedView.getViewMapKey();
            AdapterView.OnItemClickListener existingListener = view.getOnItemClickListener();
            boolean isCodelessListener = existingListener instanceof CodelessLoggingEventListener.AutoLoggingOnItemClickListener;
            boolean bl = listenerSupportCodelessLogging = isCodelessListener && ((CodelessLoggingEventListener.AutoLoggingOnItemClickListener)existingListener).getSupportCodelessLogging();
            if (!this.listenerSet.contains(mapKey) && !listenerSupportCodelessLogging) {
                CodelessLoggingEventListener.AutoLoggingOnItemClickListener listener = CodelessLoggingEventListener.getOnItemClickListener(mapping, rootView, view);
                view.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
                this.listenerSet.add(mapKey);
            }
        }

        private void attachRCTListener(MatchedView matchedView, View rootView, EventBinding mapping) {
            boolean listenerSupportCodelessLogging;
            View view = matchedView.getView();
            if (view == null) {
                return;
            }
            String mapKey = matchedView.getViewMapKey();
            View.OnTouchListener existingListener = ViewHierarchy.getExistingOnTouchListener(view);
            boolean isRCTCodelessListener = existingListener instanceof RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener;
            boolean bl = listenerSupportCodelessLogging = isRCTCodelessListener && ((RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener)existingListener).getSupportCodelessLogging();
            if (!this.listenerSet.contains(mapKey) && !listenerSupportCodelessLogging) {
                RCTCodelessLoggingEventListener.AutoLoggingOnTouchListener listener = RCTCodelessLoggingEventListener.getOnTouchListener(mapping, rootView, view);
                view.setOnTouchListener((View.OnTouchListener)listener);
                this.listenerSet.add(mapKey);
            }
        }
    }

    public static class MatchedView {
        private WeakReference<View> view;
        private String viewMapKey;

        public MatchedView(View view, String viewMapKey) {
            this.view = new WeakReference<View>(view);
            this.viewMapKey = viewMapKey;
        }

        @Nullable
        public View getView() {
            return this.view == null ? null : (View)this.view.get();
        }

        public String getViewMapKey() {
            return this.viewMapKey;
        }
    }
}

