/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.codeless;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.appevents.codeless.ViewIndexer;
import com.facebook.appevents.codeless.ViewIndexingTrigger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashreport.CrashShieldHandler;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CodelessManager {
    private static final ViewIndexingTrigger viewIndexingTrigger = new ViewIndexingTrigger();
    @Nullable
    private static SensorManager sensorManager;
    @Nullable
    private static ViewIndexer viewIndexer;
    @Nullable
    private static String deviceSessionID;
    private static final AtomicBoolean isCodelessEnabled;
    private static Boolean isAppIndexingEnabled;
    private static volatile Boolean isCheckingSession;

    public static void onActivityResumed(Activity activity) {
        if (!isCodelessEnabled.get()) {
            return;
        }
        CodelessMatcher.getInstance().add(activity);
        Context applicationContext = activity.getApplicationContext();
        final String appId = FacebookSdk.getApplicationId();
        final FetchedAppSettings appSettings = FetchedAppSettingsManager.getAppSettingsWithoutQuery(appId);
        if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
            sensorManager = (SensorManager)applicationContext.getSystemService("sensor");
            if (sensorManager == null) {
                return;
            }
            Sensor accelerometer = sensorManager.getDefaultSensor(1);
            viewIndexer = new ViewIndexer(activity);
            viewIndexingTrigger.setOnShakeListener(new ViewIndexingTrigger.OnShakeListener(){

                @Override
                public void onShake() {
                    boolean codelessSetupEnabled;
                    boolean codelessEventsEnabled;
                    boolean bl = codelessEventsEnabled = appSettings != null && appSettings.getCodelessEventsEnabled();
                    boolean bl2 = FacebookSdk.getCodelessSetupEnabled() ? true : (codelessSetupEnabled = false);
                    if (codelessEventsEnabled && codelessSetupEnabled) {
                        CodelessManager.checkCodelessSession(appId);
                    }
                }
            });
            sensorManager.registerListener((SensorEventListener)viewIndexingTrigger, accelerometer, 2);
            if (appSettings != null && appSettings.getCodelessEventsEnabled()) {
                viewIndexer.schedule();
            }
        }
    }

    public static void onActivityPaused(Activity activity) {
        if (!isCodelessEnabled.get()) {
            return;
        }
        CodelessMatcher.getInstance().remove(activity);
        if (null != viewIndexer) {
            viewIndexer.unschedule();
        }
        if (null != sensorManager) {
            sensorManager.unregisterListener((SensorEventListener)viewIndexingTrigger);
        }
    }

    public static void onActivityDestroyed(Activity activity) {
        CodelessMatcher.getInstance().destroy(activity);
    }

    public static void enable() {
        isCodelessEnabled.set(true);
    }

    public static void disable() {
        isCodelessEnabled.set(false);
    }

    private static void checkCodelessSession(final String applicationId) {
        if (isCheckingSession.booleanValue()) {
            return;
        }
        isCheckingSession = true;
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (CrashShieldHandler.isObjectCrashing(this)) {
                    return;
                }
                try {
                    GraphRequest request = GraphRequest.newPostRequest(null, String.format(Locale.US, "%s/app_indexing_session", applicationId), null, null);
                    Bundle requestParameters = request.getParameters();
                    if (requestParameters == null) {
                        requestParameters = new Bundle();
                    }
                    Context context = FacebookSdk.getApplicationContext();
                    AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
                    JSONArray extInfoArray = new JSONArray();
                    extInfoArray.put((Object)(Build.MODEL != null ? Build.MODEL : ""));
                    if (identifiers != null && identifiers.getAndroidAdvertiserId() != null) {
                        extInfoArray.put((Object)identifiers.getAndroidAdvertiserId());
                    } else {
                        extInfoArray.put((Object)"");
                    }
                    extInfoArray.put((Object)"0");
                    extInfoArray.put((Object)(AppEventUtility.isEmulator() ? "1" : "0"));
                    Locale locale = Utility.getCurrentLocale();
                    extInfoArray.put((Object)(locale.getLanguage() + "_" + locale.getCountry()));
                    String extInfo = extInfoArray.toString();
                    requestParameters.putString("device_session_id", CodelessManager.getCurrentDeviceSessionID());
                    requestParameters.putString("extinfo", extInfo);
                    request.setParameters(requestParameters);
                    GraphResponse res = request.executeAndWait();
                    JSONObject jsonRes = res.getJSONObject();
                    isAppIndexingEnabled = jsonRes != null && jsonRes.optBoolean("is_app_indexing_enabled", false);
                    if (!isAppIndexingEnabled.booleanValue()) {
                        deviceSessionID = null;
                    } else if (null != viewIndexer) {
                        viewIndexer.schedule();
                    }
                    isCheckingSession = false;
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable(throwable, this);
                    return;
                }
            }
        });
    }

    static String getCurrentDeviceSessionID() {
        if (null == deviceSessionID) {
            deviceSessionID = UUID.randomUUID().toString();
        }
        return deviceSessionID;
    }

    static boolean getIsAppIndexingEnabled() {
        return isAppIndexingEnabled;
    }

    static void updateAppIndexing(Boolean appIndexingEnalbed) {
        isAppIndexingEnabled = appIndexingEnalbed;
    }

    static {
        isCodelessEnabled = new AtomicBoolean(true);
        isAppIndexingEnabled = false;
        isCheckingSession = false;
    }
}

